/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BlockCommand
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockCommand> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("automatic").forGetter(commandBlock -> commandBlock.e), BlockCommand.x()).apply((Applicative)instance, BlockCommand::new));
    private static final Logger d = LogUtils.getLogger();
    public static final BlockStateEnum<EnumDirection> b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.f;
    private final boolean e;

    public MapCodec<BlockCommand> a() {
        return a;
    }

    public BlockCommand(boolean automatic, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(c, false));
        this.e = automatic;
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        TileEntityCommand commandBlockEntity = new TileEntityCommand(pos, state);
        commandBlockEntity.b(this.e);
        return commandBlockEntity;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        TileEntity tileEntity;
        if (!level.B_() && (tileEntity = level.c_(pos)) instanceof TileEntityCommand) {
            TileEntityCommand commandBlockEntity = (TileEntityCommand)tileEntity;
            this.a(level, pos, commandBlockEntity, level.I(pos));
        }
    }

    private void a(World level, BlockPosition pos, TileEntityCommand blockEntity, boolean powered) {
        boolean isPowered = blockEntity.c();
        CraftBlock bukkitBlock = CraftBlock.at(level, pos);
        int old = isPowered ? 15 : 0;
        int current = powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, old, current);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        boolean bl = powered = eventRedstone.getNewCurrent() > 0;
        if (powered != isPowered) {
            blockEntity.a(powered);
            if (powered) {
                if (blockEntity.d() || blockEntity.l() == TileEntityCommand.Type.a) {
                    return;
                }
                blockEntity.k();
                level.a(pos, (Block)this, 1);
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityCommand) {
            TileEntityCommand commandBlockEntity = (TileEntityCommand)tileEntity;
            CommandBlockListenerAbstract commandBlock = commandBlockEntity.a();
            boolean flag = !UtilColor.b(commandBlock.d());
            TileEntityCommand.Type mode = commandBlockEntity.l();
            boolean wasConditionMet = commandBlockEntity.h();
            if (mode == TileEntityCommand.Type.b) {
                commandBlockEntity.k();
                if (wasConditionMet) {
                    this.a(state, level, pos, commandBlock, flag);
                } else if (commandBlockEntity.m()) {
                    commandBlock.a(0);
                }
                if (commandBlockEntity.c() || commandBlockEntity.d()) {
                    level.a(pos, (Block)this, 1);
                }
            } else if (mode == TileEntityCommand.Type.c) {
                if (wasConditionMet) {
                    this.a(state, level, pos, commandBlock, flag);
                } else if (commandBlockEntity.m()) {
                    commandBlock.a(0);
                }
            }
            level.b(pos, this);
        }
    }

    private void a(IBlockData state, WorldServer level, BlockPosition pos, CommandBlockListenerAbstract logic, boolean canTrigger) {
        if (canTrigger) {
            logic.b(level);
        } else {
            logic.a(0);
        }
        BlockCommand.a(level, pos, state.c(b));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityCommand && (player.hi() || player.ha() && player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            player.a((TileEntityCommand)blockEntity);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        TileEntity blockEntity = level.c_(pos);
        return blockEntity instanceof TileEntityCommand ? ((TileEntityCommand)blockEntity).a().b() : 0;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityCommand) {
            TileEntityCommand commandBlockEntity = (TileEntityCommand)tileEntity;
            CommandBlockListenerAbstract commandBlock = commandBlockEntity.a();
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (!stack.c(DataComponents.ah)) {
                    commandBlock.a(serverLevel.U().a(GameRules.R));
                    commandBlockEntity.b(this.e);
                }
                boolean hasNeighborSignal = level.I(pos);
                this.a(level, pos, commandBlockEntity, hasNeighborSignal);
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(b, context.d().g());
    }

    private static void a(WorldServer level, BlockPosition pos, EnumDirection direction) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        GameRules gameRules = level.U();
        int i2 = gameRules.a(GameRules.z);
        while (i2-- > 0) {
            TileEntityCommand commandBlockEntity;
            TileEntity tileEntity;
            mutableBlockPos.c(direction);
            IBlockData blockState = level.a_(mutableBlockPos);
            Block block = blockState.b();
            if (!blockState.a(Blocks.lD) || !((tileEntity = level.c_(mutableBlockPos)) instanceof TileEntityCommand) || (commandBlockEntity = (TileEntityCommand)tileEntity).l() != TileEntityCommand.Type.a) break;
            if (commandBlockEntity.c() || commandBlockEntity.d()) {
                CommandBlockListenerAbstract commandBlock = commandBlockEntity.a();
                if (commandBlockEntity.k()) {
                    if (!commandBlock.b(level)) break;
                    level.b((BlockPosition)mutableBlockPos, block);
                } else if (commandBlockEntity.m()) {
                    commandBlock.a(0);
                }
            }
            direction = blockState.c(b);
        }
        if (i2 <= 0) {
            int max = Math.max(gameRules.a(GameRules.z), 0);
            d.warn("Command Block chain tried to execute more than {} steps!", (Object)max);
        }
    }
}

