/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.ticks.TickListPriority;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public abstract class BlockDiodeAbstract
extends BlockFacingHorizontal {
    public static final BlockStateBoolean c = BlockProperties.A;
    private static final VoxelShape a = Block.b(16.0, 0.0, 2.0);

    protected BlockDiodeAbstract(BlockBase.Info properties) {
        super(properties);
    }

    protected abstract MapCodec<? extends BlockDiodeAbstract> a();

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return this.a(level, blockPos, level.a_(blockPos));
    }

    protected boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.a((IBlockAccess)level, pos, EnumDirection.b, EnumBlockSupport.c);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!this.b((IWorldReader)level, pos, state)) {
            boolean poweredValue = state.c(c);
            boolean shouldTurnOn = this.a((World)level, pos, state);
            if (poweredValue && !shouldTurnOn) {
                if (CraftEventFactory.callRedstoneChange(level, pos, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                level.a(pos, (IBlockData)state.b(c, false), 2);
            } else if (!poweredValue) {
                if (CraftEventFactory.callRedstoneChange(level, pos, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                level.a(pos, (IBlockData)state.b(c, true), 2);
                if (!shouldTurnOn) {
                    level.a(pos, (Block)this, this.h(state), TickListPriority.b);
                }
            }
        }
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.a(level, pos, side);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        if (!state.c(c).booleanValue()) {
            return 0;
        }
        return state.c(BlockFacingHorizontal.f) == side ? this.a(level, pos, state) : 0;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (state.a((IWorldReader)level, pos)) {
            this.c(level, pos, state);
        } else {
            TileEntity blockEntity = state.x() ? level.c_(pos) : null;
            BlockDiodeAbstract.a(state, level, pos, blockEntity);
            level.a(pos, false);
            for (EnumDirection direction : EnumDirection.values()) {
                level.a(pos.a(direction), this);
            }
        }
    }

    protected void c(World level, BlockPosition pos, IBlockData state) {
        boolean shouldTurnOn;
        boolean poweredValue;
        if (!this.b((IWorldReader)level, pos, state) && (poweredValue = state.c(c).booleanValue()) != (shouldTurnOn = this.a(level, pos, state)) && !level.af().b(pos, this)) {
            TickListPriority tickPriority = TickListPriority.c;
            if (this.b((IBlockAccess)level, pos, state)) {
                tickPriority = TickListPriority.a;
            } else if (poweredValue) {
                tickPriority = TickListPriority.b;
            }
            level.a(pos, (Block)this, this.h(state), tickPriority);
        }
    }

    public boolean b(IWorldReader level, BlockPosition pos, IBlockData state) {
        return false;
    }

    protected boolean a(World level, BlockPosition pos, IBlockData state) {
        return this.b(level, pos, state) > 0;
    }

    protected int b(World level, BlockPosition pos, IBlockData state) {
        EnumDirection direction = state.c(BlockFacingHorizontal.f);
        BlockPosition blockPos = pos.a(direction);
        int signal = level.c(blockPos, direction);
        if (signal >= 15) {
            return signal;
        }
        IBlockData blockState = level.a_(blockPos);
        return Math.max(signal, blockState.a(Blocks.cT) ? blockState.c(BlockRedstoneWire.f) : 0);
    }

    protected int a(SignalGetter level, BlockPosition pos, IBlockData state) {
        EnumDirection direction = state.c(BlockFacingHorizontal.f);
        EnumDirection clockWise = direction.h();
        EnumDirection counterClockWise = direction.i();
        boolean flag = this.b();
        return Math.max(level.a(pos.a(clockWise), clockWise, flag), level.a(pos.a(counterClockWise), counterClockWise, flag));
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(BlockFacingHorizontal.f, context.g().g());
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        if (this.a(level, pos, state)) {
            level.a(pos, (Block)this, 1);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        this.d(level, pos, state);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston) {
            this.d(level, pos, state);
        }
    }

    protected void d(World level, BlockPosition pos, IBlockData state) {
        EnumDirection direction = state.c(BlockFacingHorizontal.f);
        BlockPosition blockPos = pos.a(direction.g());
        Orientation orientation = ExperimentalRedstoneUtils.a(level, direction.g(), EnumDirection.b);
        level.b(blockPos, this, orientation);
        level.a(blockPos, (Block)this, direction, orientation);
    }

    protected boolean b() {
        return false;
    }

    protected int a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        return 15;
    }

    public static boolean n(IBlockData state) {
        return state.b() instanceof BlockDiodeAbstract;
    }

    public boolean b(IBlockAccess level, BlockPosition pos, IBlockData state) {
        EnumDirection opposite = state.c(BlockFacingHorizontal.f).g();
        IBlockData blockState = level.a_(pos.a(opposite));
        return BlockDiodeAbstract.n(blockState) && blockState.c(BlockFacingHorizontal.f) != opposite;
    }

    protected abstract int h(IBlockData var1);
}

