/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public abstract class BlockDirtSnowSpreadable
extends BlockDirtSnow {
    protected BlockDirtSnowSpreadable(BlockBase.Info properties) {
        super(properties);
    }

    private static boolean b(IBlockData state, IWorldReader level, BlockPosition pos) {
        return BlockDirtSnowSpreadable.canBeGrass(level.E(pos), state, level, pos);
    }

    private static boolean canBeGrass(IChunkAccess chunk, IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = chunk.a_(blockPos);
        if (blockState.a(Blocks.ep) && blockState.c(BlockSnow.c) == 1) {
            return true;
        }
        if (blockState.y().e() == 8) {
            return false;
        }
        int lightBlockInto = LightEngine.a(state, blockState, EnumDirection.b, blockState.g());
        return lightBlockInto < 15;
    }

    protected abstract MapCodec<? extends BlockDirtSnowSpreadable> a();

    private static boolean c(IBlockData state, IWorldReader level, BlockPosition pos) {
        return BlockDirtSnowSpreadable.canPropagate(level.E(pos), state, level, pos);
    }

    private static boolean canPropagate(IChunkAccess chunk, IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        return BlockDirtSnowSpreadable.canBeGrass(chunk, state, level, pos) && !chunk.b_(blockPos).a(TagsFluid.a);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (this instanceof BlockGrass && level.paperConfig().tickRates.grassSpread != 1 && (level.paperConfig().tickRates.grassSpread < 1 || (MinecraftServer.currentTick + pos.hashCode()) % level.paperConfig().tickRates.grassSpread != 0)) {
            return;
        }
        Chunk cachedBlockChunk = level.getChunkIfLoaded(pos);
        if (cachedBlockChunk == null) {
            return;
        }
        if (!BlockDirtSnowSpreadable.canBeGrass(cachedBlockChunk, state, level, pos)) {
            if (CraftEventFactory.callBlockFadeEvent(level, pos, Blocks.j.m()).isCancelled()) {
                return;
            }
            level.c(pos, Blocks.j.m());
        } else if (level.G(pos.d()) >= 9) {
            IBlockData blockState = this.m();
            for (int i2 = 0; i2 < 4; ++i2) {
                Chunk access;
                BlockPosition blockPos = pos.b(random.a(3) - 1, random.a(5) - 3, random.a(3) - 1);
                if (pos.u() == blockPos.u() && pos.v() == blockPos.v() && pos.w() == blockPos.w() || !(access = cachedBlockChunk.locX == blockPos.u() >> 4 && cachedBlockChunk.locZ == blockPos.w() >> 4 ? cachedBlockChunk : level.q(blockPos)).a_(blockPos).a(Blocks.j) || !BlockDirtSnowSpreadable.canPropagate(access, blockState, level, blockPos)) continue;
                CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos, (IBlockData)blockState.b(BlockDirtSnow.c, BlockDirtSnowSpreadable.p(access.a_(blockPos.d()))), 3);
            }
        }
    }
}

