/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class BlockDoor
extends Block {
    public static final MapCodec<BlockDoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(BlockDoor::b), BlockDoor.x()).apply((Applicative)instance, BlockDoor::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.f;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> c = BlockProperties.ah;
    public static final BlockStateEnum<BlockPropertyDoorHinge> d = BlockProperties.bj;
    public static final BlockStateBoolean e = BlockProperties.y;
    public static final BlockStateBoolean f = BlockProperties.A;
    private static final Map<EnumDirection, VoxelShape> g = VoxelShapes.c(Block.c(16.0, 13.0, 16.0));
    private final BlockSetType h;

    public MapCodec<? extends BlockDoor> a() {
        return a;
    }

    protected BlockDoor(BlockSetType type, BlockBase.Info properties) {
        super(properties.a(type.g()));
        this.h = type;
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(e, false)).b(d, BlockPropertyDoorHinge.a)).b(f, false)).b(c, BlockPropertyDoubleBlockHalf.b));
    }

    public BlockSetType b() {
        return this.h;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection direction = state.c(b);
        EnumDirection direction1 = state.c(e).booleanValue() ? (state.c(d) == BlockPropertyDoorHinge.b ? direction.i() : direction.h()) : direction;
        return g.get(direction1);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyDoubleBlockHalf doubleBlockHalf = state.c(c);
        if (direction.o() != EnumDirection.EnumAxis.b || doubleBlockHalf == BlockPropertyDoubleBlockHalf.b != (direction == EnumDirection.b)) {
            return doubleBlockHalf == BlockPropertyDoubleBlockHalf.b && direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return neighborState.b() instanceof BlockDoor && neighborState.c(c) != doubleBlockHalf ? (IBlockData)neighborState.b(c, doubleBlockHalf) : Blocks.a.m();
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g() && state.c(c) == BlockPropertyDoubleBlockHalf.b && this.h.d() && !state.c(f).booleanValue()) {
            this.a(null, (World)level, state, pos, !this.n(state));
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!(level.B_() || !player.gM() && player.d(state))) {
            BlockTallPlant.b(level, pos, state, player);
        }
        return super.a(level, pos, state, player);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return switch (pathComputationType) {
            default -> throw new MatchException(null, null);
            case PathMode.a, PathMode.c -> state.c(e);
            case PathMode.b -> false;
        };
    }

    @Override
    public @Nullable IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos = context.a();
        World level = context.q();
        if (clickedPos.v() < level.aw() && level.a_(clickedPos.d()).a(context)) {
            boolean flag = level.I(clickedPos) || level.I(clickedPos.d());
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.m().b(b, context.g())).b(d, this.b(context))).b(f, flag)).b(e, flag)).b(c, BlockPropertyDoubleBlockHalf.b);
        }
        return null;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        level.a(pos.d(), (IBlockData)state.b(c, BlockPropertyDoubleBlockHalf.a), 3);
    }

    private BlockPropertyDoorHinge b(BlockActionContext context) {
        boolean flag1;
        World level = context.q();
        BlockPosition clickedPos = context.a();
        EnumDirection horizontalDirection = context.g();
        BlockPosition blockPos = clickedPos.d();
        EnumDirection counterClockWise = horizontalDirection.i();
        BlockPosition blockPos1 = clickedPos.a(counterClockWise);
        IBlockData blockState = level.a_(blockPos1);
        BlockPosition blockPos2 = blockPos.a(counterClockWise);
        IBlockData blockState1 = level.a_(blockPos2);
        EnumDirection clockWise = horizontalDirection.h();
        BlockPosition blockPos3 = clickedPos.a(clockWise);
        IBlockData blockState2 = level.a_(blockPos3);
        BlockPosition blockPos4 = blockPos.a(clockWise);
        IBlockData blockState3 = level.a_(blockPos4);
        int i2 = (blockState.m(level, blockPos1) ? -1 : 0) + (blockState1.m(level, blockPos2) ? -1 : 0) + (blockState2.m(level, blockPos3) ? 1 : 0) + (blockState3.m(level, blockPos4) ? 1 : 0);
        boolean flag = blockState.b() instanceof BlockDoor && blockState.c(c) == BlockPropertyDoubleBlockHalf.b;
        boolean bl = flag1 = blockState2.b() instanceof BlockDoor && blockState2.c(c) == BlockPropertyDoubleBlockHalf.b;
        if ((!flag || flag1) && i2 <= 0) {
            if ((!flag1 || flag) && i2 >= 0) {
                int stepX = horizontalDirection.j();
                int stepZ = horizontalDirection.l();
                Vec3D clickLocation = context.l();
                double d2 = clickLocation.g - (double)clickedPos.u();
                double d1 = clickLocation.i - (double)clickedPos.w();
                return !(stepX < 0 && d1 < 0.5 || stepX > 0 && d1 > 0.5 || stepZ < 0 && d2 > 0.5 || stepZ > 0 && d2 < 0.5) ? BlockPropertyDoorHinge.a : BlockPropertyDoorHinge.b;
            }
            return BlockPropertyDoorHinge.a;
        }
        return BlockPropertyDoorHinge.b;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (!this.h.c()) {
            return EnumInteractionResult.e;
        }
        state = (IBlockData)state.a(e);
        level.a(pos, state, 10);
        this.a(player, level, pos, (boolean)state.c(e));
        level.a((Entity)player, this.n(state) ? GameEvent.h : GameEvent.d, pos);
        return EnumInteractionResult.a;
    }

    public boolean n(IBlockData state) {
        return state.c(e);
    }

    public void a(@Nullable Entity entity, World level, IBlockData state, BlockPosition pos, boolean _open) {
        if (state.a(this) && state.c(e) != _open) {
            level.a(pos, (IBlockData)state.b(e, _open), 10);
            this.a(entity, level, pos, _open);
            level.a(entity, _open ? GameEvent.h : GameEvent.d, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        int oldPower;
        BlockPosition otherHalf = pos.a(state.c(c) == BlockPropertyDoubleBlockHalf.b ? EnumDirection.b : EnumDirection.a);
        CraftBlock bukkitBlock = CraftBlock.at(level, pos);
        CraftBlock blockTop = CraftBlock.at(level, otherHalf);
        int power = bukkitBlock.getBlockPower();
        int powerTop = blockTop.getBlockPower();
        if (powerTop > power) {
            power = powerTop;
        }
        if ((oldPower = state.c(f) != false ? 15 : 0) == 0 ^ power == 0) {
            boolean flag;
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, power);
            event.callEvent();
            boolean bl = flag = event.getNewCurrent() > 0;
            if (flag != state.c(e)) {
                this.a(null, level, pos, flag);
                level.a(null, flag ? GameEvent.h : GameEvent.d, pos);
            }
            level.a(pos, (IBlockData)((IBlockData)state.b(f, flag)).b(e, flag), 2);
        }
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return state.c(c) == BlockPropertyDoubleBlockHalf.b ? blockState.c((IBlockAccess)level, blockPos, EnumDirection.b) : blockState.a(this);
    }

    private void a(@Nullable Entity source, World level, BlockPosition pos, boolean isOpening) {
        level.a(source, pos, isOpening ? this.h.i() : this.h.h(), SoundCategory.e, 1.0f, level.G_().i() * 0.1f + 0.9f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return mirror == EnumBlockMirror.a ? state : (IBlockData)state.a(mirror.a(state.c(b))).a(d);
    }

    @Override
    protected long a(IBlockData state, BlockPosition pos) {
        return MathHelper.b(pos.u(), pos.c(state.c(c) == BlockPropertyDoubleBlockHalf.b ? 0 : 1).v(), pos.w());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, b, e, d, f);
    }

    public static boolean a(World level, BlockPosition pos) {
        return BlockDoor.p(level.a_(pos));
    }

    public static boolean p(IBlockData state) {
        BlockDoor doorBlock;
        Block block = state.b();
        return block instanceof BlockDoor && (doorBlock = (BlockDoor)block).b().c();
    }
}

