/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Set;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.EndPlatformFeature;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.event.PortalEventResult;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.Nullable;

public class BlockEnderPortal
extends BlockTileEntity
implements Portal {
    public static final MapCodec<BlockEnderPortal> a = BlockEnderPortal.b(BlockEnderPortal::new);
    private static final VoxelShape b = Block.b(16.0, 6.0, 12.0);

    public MapCodec<BlockEnderPortal> a() {
        return a;
    }

    protected BlockEnderPortal(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderPortal(pos, state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return state.f(level, pos);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!entity.o(false)) return;
        EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)pos, level), PortalType.ENDER);
        level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!level.B_() && level.aq() == World.j && entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            if (!serverPlayer.i) {
                if (level.paperConfig().misc.disableEndCredits) {
                    serverPlayer.i = true;
                    return;
                }
                serverPlayer.p();
                return;
            }
        }
        entity.a(this, pos);
    }

    @Override
    public @Nullable TeleportTransition a(WorldServer level, net.minecraft.world.entity.Entity entity, BlockPosition pos) {
        Set<Relative> set;
        float f1;
        float f2;
        WorldData.a respawnData = level.C();
        ResourceKey<World> resourceKey = level.aq();
        boolean flag = level.getTypeKey() == WorldDimension.d;
        ResourceKey<World> resourceKey1 = flag ? respawnData.a() : World.j;
        BlockPosition blockPos = flag ? respawnData.b() : WorldServer.a;
        WorldServer level1 = level.s().a(resourceKey1);
        if (level1 == null) {
            return null;
        }
        Vec3D bottomCenter = blockPos.c();
        if (!flag) {
            EndPlatformFeature.createEndPlatform(level1, BlockPosition.a(bottomCenter).e(), true, entity);
            f2 = EnumDirection.e.p();
            f1 = 0.0f;
            set = Relative.a(Relative.l, Set.of(Relative.e));
            if (entity instanceof EntityPlayer) {
                bottomCenter = bottomCenter.a(0.0, 1.0, 0.0);
            }
        } else {
            f2 = respawnData.d();
            f1 = respawnData.e();
            set = Relative.a(Relative.l, Relative.k);
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                return serverPlayer.findRespawnPositionAndUseSpawnBlock(false, TeleportTransition.a, PlayerRespawnEvent.RespawnReason.END_PORTAL);
            }
            bottomCenter = entity.a(level1, blockPos).c();
        }
        set.removeAll(Relative.k);
        float absoluteYaw = !flag ? f2 : entity.ec() + f2;
        float absolutePitch = entity.ee() + f1;
        PortalEventResult result = CraftEventFactory.handlePortalEvents(entity, CraftLocation.toBukkit(bottomCenter, (World)level1, absoluteYaw, absolutePitch), PortalType.ENDER, 0, 0);
        if (result == null) {
            return null;
        }
        Location to = result.to();
        return new TeleportTransition(((CraftWorld)to.getWorld()).getHandle(), CraftLocation.toVec3(to), Vec3D.c, to.getYaw(), to.getPitch(), set, TeleportTransition.b.then(TeleportTransition.c), PlayerTeleportEvent.TeleportCause.END_PORTAL);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        double d2 = (double)pos.u() + random.j();
        double d1 = (double)pos.v() + 0.8;
        double d22 = (double)pos.w() + random.j();
        level.a(Particles.ai, d2, d1, d22, 0.0, 0.0, 0.0);
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return ItemStack.l;
    }

    @Override
    protected boolean a(IBlockData state, FluidType fluid) {
        return false;
    }

    @Override
    protected EnumRenderType a_(IBlockData state) {
        return EnumRenderType.a;
    }
}

