/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockFire
extends BlockFireAbstract {
    public static final MapCodec<BlockFire> b = BlockFire.b(BlockFire::new);
    public static final int c = 15;
    public static final BlockStateInteger d = BlockProperties.aA;
    public static final BlockStateBoolean e = BlockSprawling.b;
    public static final BlockStateBoolean f = BlockSprawling.c;
    public static final BlockStateBoolean g = BlockSprawling.d;
    public static final BlockStateBoolean h = BlockSprawling.e;
    public static final BlockStateBoolean i = BlockSprawling.f;
    public static final Map<EnumDirection, BlockStateBoolean> D = BlockSprawling.h.entrySet().stream().filter(directionEntry -> directionEntry.getKey() != EnumDirection.a).collect(SystemUtils.a());
    private final Function<IBlockData, VoxelShape> R;
    private static final int S = 60;
    private static final int T = 30;
    private static final int U = 15;
    private static final int V = 5;
    private static final int W = 100;
    private static final int X = 60;
    private static final int Y = 20;
    private static final int Z = 5;
    public final Object2IntMap<Block> aa = new Object2IntOpenHashMap();
    private final Object2IntMap<Block> ab = new Object2IntOpenHashMap();

    public MapCodec<BlockFire> a() {
        return b;
    }

    public BlockFire(BlockBase.Info properties) {
        super(properties, 1.0f);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(d, 0)).b(e, false)).b(f, false)).b(g, false)).b(h, false)).b(i, false));
        this.R = this.q();
    }

    private Function<IBlockData, VoxelShape> q() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
        return this.a((IBlockData blockState) -> {
            VoxelShape voxelShape = VoxelShapes.a();
            for (Map.Entry<EnumDirection, BlockStateBoolean> entry : D.entrySet()) {
                if (!((Boolean)blockState.c(entry.getValue())).booleanValue()) continue;
                voxelShape = VoxelShapes.a(voxelShape, (VoxelShape)map.get(entry.getKey()));
            }
            return voxelShape.c() ? BlockFireAbstract.a : voxelShape;
        }, d);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!(level instanceof WorldServer)) {
            return this.a(state, level, pos) ? this.a(level, pos, (int)state.c(d)) : Blocks.a.m();
        }
        if (!this.a(state, level, pos)) {
            if (!(level instanceof World)) {
                return Blocks.a.m();
            }
            World world1 = (World)level;
            CraftBlockState blockState = CraftBlockStates.getBlockState(world1, pos);
            blockState.setData(Blocks.a.m());
            BlockFadeEvent event = new BlockFadeEvent((org.bukkit.block.Block)blockState.getBlock(), (BlockState)blockState);
            world1.getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                return blockState.getHandle();
            }
        }
        return this.a(level, pos, (int)state.c(d));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.R.apply(state);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return this.b(context.q(), context.a());
    }

    protected IBlockData b(IBlockAccess level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        if (!this.g(blockState) && !blockState.c(level, blockPos, EnumDirection.b)) {
            IBlockData blockState1 = this.m();
            for (EnumDirection direction : EnumDirection.values()) {
                BlockStateBoolean booleanProperty = D.get(direction);
                if (booleanProperty == null) continue;
                blockState1 = (IBlockData)blockState1.b(booleanProperty, this.g(level.a_(pos.a(direction))));
            }
            return blockState1;
        }
        return this.m();
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return level.a_(blockPos).c((IBlockAccess)level, blockPos, EnumDirection.b) || this.d(level, pos);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        level.a(pos, (Block)this, BlockFire.getFireTickDelay(level));
        if (level.j(pos)) {
            if (!state.a((IWorldReader)level, pos)) {
                this.fireExtinguished(level, pos);
            }
            IBlockData blockState = level.a_(pos.e());
            boolean isTag = blockState.a(level.F_().k());
            int ageValue = state.c(d);
            if (!isTag && level.ao() && this.a(level, pos) && random.i() < 0.2f + (float)ageValue * 0.03f) {
                this.fireExtinguished(level, pos);
            } else {
                boolean value;
                int min = Math.min(15, ageValue + random.a(3) / 2);
                if (ageValue != min) {
                    state = (IBlockData)state.b(d, min);
                    level.a(pos, state, 260);
                }
                if (!isTag) {
                    if (!this.d(level, pos)) {
                        BlockPosition blockPos = pos.e();
                        if (!level.a_(blockPos).c((IBlockAccess)level, blockPos, EnumDirection.b) || ageValue > 3) {
                            this.fireExtinguished(level, pos);
                        }
                        return;
                    }
                    if (ageValue == 15 && random.a(4) == 0 && !this.g(level.a_(pos.e()))) {
                        this.fireExtinguished(level, pos);
                        return;
                    }
                }
                int i2 = (value = level.c().a(EnvironmentAttributes.G, pos).booleanValue()) ? -50 : 0;
                this.checkBurnOut(level, pos.i(), 300 + i2, random, ageValue, pos);
                this.checkBurnOut(level, pos.h(), 300 + i2, random, ageValue, pos);
                this.checkBurnOut(level, pos.e(), 250 + i2, random, ageValue, pos);
                this.checkBurnOut(level, pos.d(), 250 + i2, random, ageValue, pos);
                this.checkBurnOut(level, pos.f(), 300 + i2, random, ageValue, pos);
                this.checkBurnOut(level, pos.g(), 300 + i2, random, ageValue, pos);
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
                for (int i1 = -1; i1 <= 1; ++i1) {
                    for (int i22 = -1; i22 <= 1; ++i22) {
                        for (int i3 = -1; i3 <= 4; ++i3) {
                            if (i1 == 0 && i3 == 0 && i22 == 0) continue;
                            int i4 = 100;
                            if (i3 > 1) {
                                i4 += (i3 - 1) * 100;
                            }
                            mutableBlockPos.a(pos, i1, i3, i22);
                            int igniteOdds = this.a((IWorldReader)level, (BlockPosition)mutableBlockPos);
                            if (igniteOdds <= 0) continue;
                            int i5 = (igniteOdds + 40 + level.av().a() * 7) / (ageValue + 30);
                            if (value) {
                                i5 /= 2;
                            }
                            if (i5 <= 0 || random.a(i4) > i5 || level.ao() && this.a(level, (BlockPosition)mutableBlockPos)) continue;
                            int min1 = Math.min(15, ageValue + random.a(5) / 4);
                            if (level.a_(mutableBlockPos).a(Blocks.cN) || CraftEventFactory.callBlockIgniteEvent((World)level, (BlockPosition)mutableBlockPos, pos).isCancelled()) continue;
                            CraftEventFactory.handleBlockSpreadEvent(level, pos, mutableBlockPos, this.a((IWorldReader)level, (BlockPosition)mutableBlockPos, min1), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean a(World level, BlockPosition pos) {
        return level.v(pos) || level.v(pos.h()) || level.v(pos.i()) || level.v(pos.f()) || level.v(pos.g());
    }

    private int p(IBlockData state) {
        return state.b(BlockProperties.I) && state.c(BlockProperties.I) != false ? 0 : this.ab.getInt((Object)state.b());
    }

    private int r(IBlockData state) {
        return state.b(BlockProperties.I) && state.c(BlockProperties.I) != false ? 0 : this.aa.getInt((Object)state.b());
    }

    private void checkBurnOut(World level, BlockPosition pos, int chance, RandomSource random, int age, BlockPosition sourcePos) {
        int burnOdds = this.p(level.a_(pos));
        if (random.a(chance) < burnOdds) {
            CraftBlock sourceBlock;
            IBlockData blockState = level.a_(pos);
            CraftBlock burnBlock = CraftBlock.at(level, pos);
            BlockBurnEvent event = new BlockBurnEvent((org.bukkit.block.Block)burnBlock, (org.bukkit.block.Block)(sourceBlock = CraftBlock.at(level, sourcePos)));
            if (!event.callEvent()) {
                return;
            }
            if (blockState.b() instanceof BlockTNT && !CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.FIRE, null, sourcePos)) {
                return;
            }
            if (random.a(age + 10) < 5 && !level.v(pos)) {
                int min = Math.min(age + random.a(5) / 4, 15);
                level.a(pos, this.a((IWorldReader)level, pos, min), 3);
            } else if (!blockState.a(Blocks.cu)) {
                level.a(pos, false);
            }
            Block block = blockState.b();
            if (block instanceof BlockTNT) {
                CraftBlock tntBlock = CraftBlock.at(level, pos);
                if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.FIRE, null).callEvent()) {
                    return;
                }
                level.a(pos, false);
                BlockTNT.a(level, pos);
            }
        }
    }

    private IBlockData a(IWorldReader level, BlockPosition pos, int age) {
        IBlockData state = BlockFire.a(level, pos);
        return state.a(Blocks.cN) ? (IBlockData)state.b(d, age) : state;
    }

    private boolean d(IBlockAccess level, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            if (!this.g(level.a_(pos.a(direction)))) continue;
            return true;
        }
        return false;
    }

    private int a(IWorldReader level, BlockPosition pos) {
        if (!level.A(pos)) {
            return 0;
        }
        int i2 = 0;
        for (EnumDirection direction : EnumDirection.values()) {
            IBlockData blockState = level.a_(pos.a(direction));
            i2 = Math.max(this.r(blockState), i2);
        }
        return i2;
    }

    @Override
    protected boolean g(IBlockData state) {
        return this.r(state) > 0;
    }

    @Override
    protected void onPlace(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston, ItemActionContext context) {
        super.onPlace(state, level, pos, oldState, movedByPiston, context);
        level.a(pos, (Block)this, BlockFire.getFireTickDelay(level));
    }

    private static int getFireTickDelay(World level) {
        return level.paperConfig().environment.fireTickDelay + level.y.a(10);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(d, e, f, g, h, i);
    }

    public void a(Block block, int encouragement, int flammability) {
        this.aa.put((Object)block, encouragement);
        this.ab.put((Object)block, flammability);
    }

    public static void b() {
        BlockFire fireBlock = (BlockFire)Blocks.cN;
        fireBlock.a(Blocks.n, 5, 20);
        fireBlock.a(Blocks.o, 5, 20);
        fireBlock.a(Blocks.p, 5, 20);
        fireBlock.a(Blocks.q, 5, 20);
        fireBlock.a(Blocks.r, 5, 20);
        fireBlock.a(Blocks.s, 5, 20);
        fireBlock.a(Blocks.t, 5, 20);
        fireBlock.a(Blocks.v, 5, 20);
        fireBlock.a(Blocks.w, 5, 20);
        fireBlock.a(Blocks.x, 5, 20);
        fireBlock.a(Blocks.y, 5, 20);
        fireBlock.a(Blocks.kl, 5, 20);
        fireBlock.a(Blocks.km, 5, 20);
        fireBlock.a(Blocks.kn, 5, 20);
        fireBlock.a(Blocks.ko, 5, 20);
        fireBlock.a(Blocks.kp, 5, 20);
        fireBlock.a(Blocks.kq, 5, 20);
        fireBlock.a(Blocks.kr, 5, 20);
        fireBlock.a(Blocks.ks, 5, 20);
        fireBlock.a(Blocks.kt, 5, 20);
        fireBlock.a(Blocks.ku, 5, 20);
        fireBlock.a(Blocks.kv, 5, 20);
        fireBlock.a(Blocks.fQ, 5, 20);
        fireBlock.a(Blocks.kO, 5, 20);
        fireBlock.a(Blocks.kP, 5, 20);
        fireBlock.a(Blocks.kQ, 5, 20);
        fireBlock.a(Blocks.kR, 5, 20);
        fireBlock.a(Blocks.kS, 5, 20);
        fireBlock.a(Blocks.kT, 5, 20);
        fireBlock.a(Blocks.kU, 5, 20);
        fireBlock.a(Blocks.kV, 5, 20);
        fireBlock.a(Blocks.kW, 5, 20);
        fireBlock.a(Blocks.ex, 5, 20);
        fireBlock.a(Blocks.kX, 5, 20);
        fireBlock.a(Blocks.kY, 5, 20);
        fireBlock.a(Blocks.kZ, 5, 20);
        fireBlock.a(Blocks.la, 5, 20);
        fireBlock.a(Blocks.lb, 5, 20);
        fireBlock.a(Blocks.lc, 5, 20);
        fireBlock.a(Blocks.ld, 5, 20);
        fireBlock.a(Blocks.le, 5, 20);
        fireBlock.a(Blocks.lf, 5, 20);
        fireBlock.a(Blocks.cR, 5, 20);
        fireBlock.a(Blocks.gA, 5, 20);
        fireBlock.a(Blocks.gz, 5, 20);
        fireBlock.a(Blocks.gB, 5, 20);
        fireBlock.a(Blocks.iG, 5, 20);
        fireBlock.a(Blocks.iH, 5, 20);
        fireBlock.a(Blocks.iI, 5, 20);
        fireBlock.a(Blocks.iJ, 5, 20);
        fireBlock.a(Blocks.iK, 5, 20);
        fireBlock.a(Blocks.iL, 5, 20);
        fireBlock.a(Blocks.iM, 5, 20);
        fireBlock.a(Blocks.X, 5, 5);
        fireBlock.a(Blocks.Y, 5, 5);
        fireBlock.a(Blocks.Z, 5, 5);
        fireBlock.a(Blocks.aa, 5, 5);
        fireBlock.a(Blocks.ab, 5, 5);
        fireBlock.a(Blocks.ac, 5, 5);
        fireBlock.a(Blocks.ae, 5, 5);
        fireBlock.a(Blocks.ad, 5, 5);
        fireBlock.a(Blocks.af, 5, 5);
        fireBlock.a(Blocks.ai, 5, 5);
        fireBlock.a(Blocks.aq, 5, 5);
        fireBlock.a(Blocks.aj, 5, 5);
        fireBlock.a(Blocks.ak, 5, 5);
        fireBlock.a(Blocks.al, 5, 5);
        fireBlock.a(Blocks.am, 5, 5);
        fireBlock.a(Blocks.an, 5, 5);
        fireBlock.a(Blocks.ao, 5, 5);
        fireBlock.a(Blocks.ap, 5, 5);
        fireBlock.a(Blocks.ar, 5, 5);
        fireBlock.a(Blocks.as, 5, 5);
        fireBlock.a(Blocks.aB, 5, 5);
        fireBlock.a(Blocks.aC, 5, 5);
        fireBlock.a(Blocks.aD, 5, 5);
        fireBlock.a(Blocks.aE, 5, 5);
        fireBlock.a(Blocks.aF, 5, 5);
        fireBlock.a(Blocks.aG, 5, 5);
        fireBlock.a(Blocks.aH, 5, 5);
        fireBlock.a(Blocks.aI, 5, 5);
        fireBlock.a(Blocks.aJ, 5, 5);
        fireBlock.a(Blocks.at, 5, 5);
        fireBlock.a(Blocks.au, 5, 5);
        fireBlock.a(Blocks.av, 5, 5);
        fireBlock.a(Blocks.aw, 5, 5);
        fireBlock.a(Blocks.ax, 5, 5);
        fireBlock.a(Blocks.ay, 5, 5);
        fireBlock.a(Blocks.u, 5, 5);
        fireBlock.a(Blocks.az, 5, 5);
        fireBlock.a(Blocks.aA, 5, 5);
        fireBlock.a(Blocks.ag, 5, 20);
        fireBlock.a(Blocks.aK, 30, 60);
        fireBlock.a(Blocks.aL, 30, 60);
        fireBlock.a(Blocks.aM, 30, 60);
        fireBlock.a(Blocks.aN, 30, 60);
        fireBlock.a(Blocks.aO, 30, 60);
        fireBlock.a(Blocks.aP, 30, 60);
        fireBlock.a(Blocks.aQ, 30, 60);
        fireBlock.a(Blocks.aR, 30, 60);
        fireBlock.a(Blocks.aS, 30, 60);
        fireBlock.a(Blocks.cv, 30, 20);
        fireBlock.a(Blocks.cu, 15, 100);
        fireBlock.a(Blocks.bA, 60, 100);
        fireBlock.a(Blocks.bB, 60, 100);
        fireBlock.a(Blocks.bC, 60, 100);
        fireBlock.a(Blocks.bE, 60, 100);
        fireBlock.a(Blocks.bF, 60, 100);
        fireBlock.a(Blocks.jv, 60, 100);
        fireBlock.a(Blocks.jw, 60, 100);
        fireBlock.a(Blocks.jx, 60, 100);
        fireBlock.a(Blocks.jy, 60, 100);
        fireBlock.a(Blocks.jz, 60, 100);
        fireBlock.a(Blocks.jA, 60, 100);
        fireBlock.a(Blocks.cb, 60, 100);
        fireBlock.a(Blocks.cd, 60, 100);
        fireBlock.a(Blocks.uW, 60, 100);
        fireBlock.a(Blocks.uX, 60, 100);
        fireBlock.a(Blocks.ce, 60, 100);
        fireBlock.a(Blocks.cf, 60, 100);
        fireBlock.a(Blocks.cg, 60, 100);
        fireBlock.a(Blocks.ch, 60, 100);
        fireBlock.a(Blocks.ci, 60, 100);
        fireBlock.a(Blocks.cj, 60, 100);
        fireBlock.a(Blocks.ck, 60, 100);
        fireBlock.a(Blocks.cl, 60, 100);
        fireBlock.a(Blocks.cm, 60, 100);
        fireBlock.a(Blocks.co, 60, 100);
        fireBlock.a(Blocks.cc, 60, 100);
        fireBlock.a(Blocks.ly, 60, 100);
        fireBlock.a(Blocks.cn, 60, 100);
        fireBlock.a(Blocks.tY, 60, 100);
        fireBlock.a(Blocks.tZ, 60, 100);
        fireBlock.a(Blocks.ua, 60, 100);
        fireBlock.a(Blocks.et, 60, 100);
        fireBlock.a(Blocks.bK, 30, 60);
        fireBlock.a(Blocks.bL, 30, 60);
        fireBlock.a(Blocks.bM, 30, 60);
        fireBlock.a(Blocks.bN, 30, 60);
        fireBlock.a(Blocks.bO, 30, 60);
        fireBlock.a(Blocks.bP, 30, 60);
        fireBlock.a(Blocks.bQ, 30, 60);
        fireBlock.a(Blocks.bR, 30, 60);
        fireBlock.a(Blocks.bS, 30, 60);
        fireBlock.a(Blocks.bT, 30, 60);
        fireBlock.a(Blocks.bU, 30, 60);
        fireBlock.a(Blocks.bV, 30, 60);
        fireBlock.a(Blocks.bW, 30, 60);
        fireBlock.a(Blocks.bX, 30, 60);
        fireBlock.a(Blocks.bY, 30, 60);
        fireBlock.a(Blocks.bZ, 30, 60);
        fireBlock.a(Blocks.fN, 15, 100);
        fireBlock.a(Blocks.jt, 5, 5);
        fireBlock.a(Blocks.jb, 60, 20);
        fireBlock.a(Blocks.qd, 15, 20);
        fireBlock.a(Blocks.jc, 60, 20);
        fireBlock.a(Blocks.jd, 60, 20);
        fireBlock.a(Blocks.je, 60, 20);
        fireBlock.a(Blocks.jf, 60, 20);
        fireBlock.a(Blocks.jg, 60, 20);
        fireBlock.a(Blocks.jh, 60, 20);
        fireBlock.a(Blocks.ji, 60, 20);
        fireBlock.a(Blocks.jj, 60, 20);
        fireBlock.a(Blocks.jk, 60, 20);
        fireBlock.a(Blocks.jl, 60, 20);
        fireBlock.a(Blocks.jm, 60, 20);
        fireBlock.a(Blocks.jn, 60, 20);
        fireBlock.a(Blocks.jo, 60, 20);
        fireBlock.a(Blocks.jp, 60, 20);
        fireBlock.a(Blocks.jq, 60, 20);
        fireBlock.a(Blocks.jr, 60, 20);
        fireBlock.a(Blocks.uT, 5, 100);
        fireBlock.a(Blocks.uU, 5, 100);
        fireBlock.a(Blocks.uV, 5, 100);
        fireBlock.a(Blocks.na, 30, 60);
        fireBlock.a(Blocks.nW, 60, 60);
        fireBlock.a(Blocks.oP, 60, 60);
        fireBlock.a(Blocks.oX, 30, 20);
        fireBlock.a(Blocks.qc, 5, 20);
        fireBlock.a(Blocks.pg, 60, 100);
        fireBlock.a(Blocks.qf, 5, 20);
        fireBlock.a(Blocks.qe, 30, 20);
        fireBlock.a(Blocks.aT, 30, 60);
        fireBlock.a(Blocks.aU, 30, 60);
        fireBlock.a(Blocks.tS, 15, 60);
        fireBlock.a(Blocks.tT, 15, 60);
        fireBlock.a(Blocks.tU, 60, 100);
        fireBlock.a(Blocks.tV, 30, 60);
        fireBlock.a(Blocks.tW, 30, 60);
        fireBlock.a(Blocks.uc, 60, 100);
        fireBlock.a(Blocks.ud, 60, 100);
        fireBlock.a(Blocks.ue, 60, 100);
        fireBlock.a(Blocks.uf, 30, 60);
        fireBlock.a(Blocks.fO, 15, 100);
        fireBlock.a(Blocks.va, 60, 100);
        fireBlock.a(Blocks.bD, 60, 100);
        fireBlock.a(Blocks.cx, 30, 20);
        fireBlock.a(Blocks.cy, 30, 20);
        fireBlock.a(Blocks.cz, 30, 20);
        fireBlock.a(Blocks.cA, 30, 20);
        fireBlock.a(Blocks.cC, 30, 20);
        fireBlock.a(Blocks.cD, 30, 20);
        fireBlock.a(Blocks.cE, 30, 20);
        fireBlock.a(Blocks.cF, 30, 20);
        fireBlock.a(Blocks.cG, 30, 20);
        fireBlock.a(Blocks.cH, 30, 20);
    }
}

