/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.player.PlayerFlowerPotManipulateEvent;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockFlowerPot
extends Block {
    public static final MapCodec<BlockFlowerPot> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("potted").forGetter(flowerPotBlock -> flowerPotBlock.d), BlockFlowerPot.x()).apply((Applicative)instance, BlockFlowerPot::new));
    private static final Map<Block, Block> b = Maps.newHashMap();
    private static final VoxelShape c = Block.b(6.0, 0.0, 6.0);
    private final Block d;

    public MapCodec<BlockFlowerPot> a() {
        return a;
    }

    public BlockFlowerPot(Block potted, BlockBase.Info properties) {
        super(properties);
        this.d = potted;
        b.put(potted, this);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        Block block;
        Item item = stack.h();
        if (item instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)item;
            block = b.getOrDefault(blockItem.c(), Blocks.a);
        } else {
            block = Blocks.a;
        }
        IBlockData blockState = block.m();
        if (blockState.l()) {
            return EnumInteractionResult.f;
        }
        if (!this.q()) {
            return EnumInteractionResult.c;
        }
        CraftBlock block2 = CraftBlock.at(level, pos);
        ItemStack placedStack = CraftItemStack.asBukkitCopy(stack);
        PlayerFlowerPotManipulateEvent event = new PlayerFlowerPotManipulateEvent((Player)player.getBukkitEntity(), (org.bukkit.block.Block)block2, placedStack, true);
        if (!event.callEvent()) {
            player.cn.forceHeldSlot(hand);
            return EnumInteractionResult.c;
        }
        level.a(pos, blockState, 3);
        level.a((Entity)player, GameEvent.c, pos);
        player.a(StatisticList.aj);
        stack.a(1, (EntityLiving)player);
        return EnumInteractionResult.a;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (this.q()) {
            return EnumInteractionResult.c;
        }
        net.minecraft.world.item.ItemStack itemStack = new net.minecraft.world.item.ItemStack(this.d);
        CraftBlock block = CraftBlock.at(level, pos);
        ItemStack pottedStack = new ItemStack(CraftBlockType.minecraftToBukkit(this.d));
        PlayerFlowerPotManipulateEvent event = new PlayerFlowerPotManipulateEvent((Player)player.getBukkitEntity(), (org.bukkit.block.Block)block, pottedStack, false);
        if (!event.callEvent()) {
            player.cn.b();
            return EnumInteractionResult.e;
        }
        if (!player.h(itemStack)) {
            player.a(itemStack, false);
        }
        level.a(pos, Blocks.gG.m(), 3);
        level.a((Entity)player, GameEvent.c, pos);
        return EnumInteractionResult.a;
    }

    @Override
    protected net.minecraft.world.item.ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return this.q() ? super.a(level, pos, state, includeData) : new net.minecraft.world.item.ItemStack(this.d);
    }

    private boolean q() {
        return this.d == Blocks.a;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public Block b() {
        return this.d;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.a(Blocks.uY) || state.a(Blocks.uZ);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        boolean flag1;
        boolean flag;
        if (this.f(state) && (flag = this.d == Blocks.uW) != (flag1 = level.c().a(EnvironmentAttributes.H, pos).b(flag))) {
            level.a(pos, this.p(state), 3);
            EyeblossomBlock.a type = EyeblossomBlock.a.a(flag).c();
            type.a(level, pos, random);
            level.a(null, pos, type.e(), SoundCategory.e, 1.0f, 1.0f);
        }
        super.b(state, level, pos, random);
    }

    public IBlockData p(IBlockData state) {
        if (state.a(Blocks.uY)) {
            return Blocks.uZ.m();
        }
        return state.a(Blocks.uZ) ? Blocks.uY.m() : state;
    }
}

