/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.Nullable;

public class BlockHopper
extends BlockTileEntity {
    public static final MapCodec<BlockHopper> a = BlockHopper.b(BlockHopper::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.S;
    public static final BlockStateBoolean c = BlockProperties.i;
    private final Function<IBlockData, VoxelShape> d;
    private final Map<EnumDirection, VoxelShape> e;

    public MapCodec<BlockHopper> a() {
        return a;
    }

    public BlockHopper(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.a)).b(c, true));
        VoxelShape voxelShape = Block.b(12.0, 11.0, 16.0);
        this.d = this.b(voxelShape);
        this.e = ImmutableMap.builderWithExpectedSize((int)5).putAll(VoxelShapes.c(VoxelShapes.a(voxelShape, Block.a(4.0, 8.0, 10.0, 0.0, 4.0)))).put((Object)EnumDirection.a, (Object)voxelShape).build();
    }

    private Function<IBlockData, VoxelShape> b(VoxelShape shape) {
        VoxelShape voxelShape = VoxelShapes.a(Block.b(16.0, 10.0, 16.0), Block.b(8.0, 4.0, 10.0));
        VoxelShape voxelShape1 = VoxelShapes.a(voxelShape, shape, OperatorBoolean.e);
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.a(4.0, 4.0, 8.0, 0.0, 8.0), new Vec3D(8.0, 6.0, 8.0).c(0.0625));
        return this.a((IBlockData state) -> VoxelShapes.a(voxelShape1, VoxelShapes.a((VoxelShape)map.get(state.c(b)), VoxelShapes.b(), OperatorBoolean.i)), c);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.d.apply(state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return this.e.get(state.c(b));
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection opposite = context.k().g();
        return (IBlockData)((IBlockData)this.m().b(b, opposite.o() == EnumDirection.EnumAxis.b ? EnumDirection.a : opposite)).b(c, true);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityHopper(pos, state);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.B_() ? null : BlockHopper.a(blockEntityType, TileEntityTypes.s, TileEntityHopper::a);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (!oldState.a(state.b())) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntityHopper hopperBlockEntity;
        TileEntity tileEntity;
        if (!level.B_() && (tileEntity = level.c_(pos)) instanceof TileEntityHopper && player.a(hopperBlockEntity = (TileEntityHopper)tileEntity).isPresent()) {
            player.a(StatisticList.af);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        this.a(level, pos, state);
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        boolean flag;
        boolean bl = flag = !level.I(pos);
        if (flag != state.c(c)) {
            level.a(pos, (IBlockData)state.b(c, flag), 2);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return Container.a(level.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityHopper) {
            TileEntityHopper.a(level, pos, state, entity, (TileEntityHopper)blockEntity);
        }
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

