/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.OptionalInt;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.LeavesDecayEvent;

public abstract class BlockLeaves
extends Block
implements IBlockWaterlogged {
    public static final int a = 7;
    public static final BlockStateInteger b = BlockProperties.aG;
    public static final BlockStateBoolean c = BlockProperties.z;
    public static final BlockStateBoolean d = BlockProperties.I;
    protected final float e;
    private static final int f = 1;
    private static boolean g = true;

    public abstract MapCodec<? extends BlockLeaves> a();

    public BlockLeaves(float leafParticleChance, BlockBase.Info properties) {
        super(properties);
        this.e = leafParticleChance;
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, 7)).b(c, false)).b(d, false));
    }

    @Override
    protected boolean b(IBlockData state, IBlockData adjacentState, EnumDirection direction) {
        return !g && adjacentState.b() instanceof BlockLeaves || super.b(state, adjacentState, direction);
    }

    public static void a(boolean cutoutLeaves) {
        g = cutoutLeaves;
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return VoxelShapes.a();
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(b) == 7 && state.c(c) == false;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (this.p(state)) {
            LeavesDecayEvent event = new LeavesDecayEvent((org.bukkit.block.Block)CraftBlock.at(level, pos));
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || !level.a_(pos).a(this)) {
                return;
            }
            BlockLeaves.b(state, level, pos);
            level.a(pos, false);
        }
    }

    protected boolean p(IBlockData state) {
        return state.c(c) == false && state.c(b) == 7;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        level.a(pos, BlockLeaves.a(state, level, pos), 3);
    }

    @Override
    protected int i_(IBlockData state) {
        return 1;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        int i2;
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if ((i2 = BlockLeaves.s(neighborState) + 1) != 1 || state.c(b) != i2) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return state;
    }

    private static IBlockData a(IBlockData state, GeneratorAccess level, BlockPosition pos) {
        int i2 = 7;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EnumDirection direction : EnumDirection.values()) {
            mutableBlockPos.a((BaseBlockPosition)pos, direction);
            i2 = Math.min(i2, BlockLeaves.s(level.a_(mutableBlockPos)) + 1);
            if (i2 == 1) break;
        }
        return (IBlockData)state.b(b, i2);
    }

    private static int s(IBlockData neighbor) {
        return BlockLeaves.r(neighbor).orElse(7);
    }

    public static OptionalInt r(IBlockData state) {
        if (state.a(TagsBlock.E)) {
            return OptionalInt.of(0);
        }
        return state.b(b) ? OptionalInt.of(state.c(b)) : OptionalInt.empty();
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        super.a(state, level, pos, random);
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        BlockLeaves.a(level, pos, random, blockState, blockPos);
        this.b(level, pos, random, blockState, blockPos);
    }

    private static void a(World level, BlockPosition pos, RandomSource random, IBlockData blockBelow, BlockPosition belowPos) {
        if (!(!level.v(pos.d()) || random.a(15) != 1 || blockBelow.t() && blockBelow.c((IBlockAccess)level, belowPos, EnumDirection.b))) {
            ParticleUtils.a(level, pos, random, (ParticleParam)Particles.m);
        }
    }

    private void b(World level, BlockPosition pos, RandomSource random, IBlockData blockBelow, BlockPosition belowPos) {
        if (!(random.i() >= this.e) && !BlockLeaves.a(blockBelow.g(level, belowPos), EnumDirection.b)) {
            this.a(level, pos, random);
        }
    }

    protected abstract void a(World var1, BlockPosition var2, RandomSource var3);

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        IBlockData blockState = (IBlockData)((IBlockData)this.m().b(c, true)).b(d, fluidState.a() == FluidTypes.c);
        return BlockLeaves.a(blockState, context.q(), context.a());
    }
}

