/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.player.PlayerInsertLecternBookEvent;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public class BlockLectern
extends BlockTileEntity {
    public static final MapCodec<BlockLectern> a = BlockLectern.b(BlockLectern::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.f;
    public static final BlockStateBoolean c = BlockProperties.A;
    public static final BlockStateBoolean d = BlockProperties.r;
    private static final VoxelShape e = VoxelShapes.a(Block.b(16.0, 0.0, 2.0), Block.b(8.0, 2.0, 14.0));
    private static final Map<EnumDirection, VoxelShape> f = VoxelShapes.c(VoxelShapes.a(Block.a(16.0, 10.0, 14.0, 1.0, 5.333333), Block.a(16.0, 12.0, 16.0, 5.333333, 9.666667), Block.a(16.0, 14.0, 18.0, 9.666667, 14.0), e));
    private static final int g = 2;

    public MapCodec<BlockLectern> a() {
        return a;
    }

    protected BlockLectern(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(c, false)).b(d, false));
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return e;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        TypedEntityData<TileEntityTypes<?>> typedEntityData;
        World level = context.q();
        net.minecraft.world.item.ItemStack itemInHand = context.n();
        EntityHuman player = context.o();
        boolean flag = false;
        if (!level.B_() && player != null && player.hi() && (typedEntityData = itemInHand.a(DataComponents.ah)) != null && typedEntityData.a("Book")) {
            flag = true;
        }
        return (IBlockData)((IBlockData)this.m().b(b, context.g().g())).b(d, flag);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return f.get(state.c(b));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityLectern(pos, state);
    }

    public static boolean a(@Nullable EntityLiving entity, World level, BlockPosition pos, IBlockData state, net.minecraft.world.item.ItemStack stack) {
        if (!state.c(d).booleanValue()) {
            if (!level.B_()) {
                BlockLectern.b(entity, level, pos, state, stack);
            }
            return true;
        }
        return false;
    }

    private static void b(@Nullable EntityLiving entity, World level, BlockPosition pos, IBlockData state, net.minecraft.world.item.ItemStack stack) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityLectern) {
            TileEntityLectern lecternBlockEntity = (TileEntityLectern)tileEntity;
            net.minecraft.world.item.ItemStack eventSourcedBookStack = null;
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                PlayerInsertLecternBookEvent event = new PlayerInsertLecternBookEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos), (ItemStack)CraftItemStack.asCraftMirror(stack.c(1)));
                if (!event.callEvent()) {
                    return;
                }
                eventSourcedBookStack = CraftItemStack.unwrap(event.getBook());
            }
            if (eventSourcedBookStack == null) {
                eventSourcedBookStack = stack.b(1, entity);
            } else {
                stack.a(1, entity);
            }
            lecternBlockEntity.b(eventSourcedBookStack);
            BlockLectern.a((Entity)entity, level, pos, state, true);
            level.a(null, pos, SoundEffects.cL, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    public static void a(@Nullable Entity entity, World level, BlockPosition pos, IBlockData state, boolean hasBook) {
        IBlockData blockState = (IBlockData)((IBlockData)state.b(c, false)).b(d, hasBook);
        level.a(pos, blockState, 3);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
        BlockLectern.b(level, pos, state);
    }

    public static void a(World level, BlockPosition pos, IBlockData state) {
        BlockLectern.a(level, pos, state, true);
        level.a(pos, state.b(), 2);
        level.c(1043, pos, 0);
    }

    private static void a(World level, BlockPosition pos, IBlockData state, boolean powered) {
        BlockRedstoneEvent event;
        int targetRedstoneLevel;
        int currentRedstoneLevel = state.c(c) != false ? 15 : 0;
        int n2 = targetRedstoneLevel = powered ? 15 : 0;
        if (currentRedstoneLevel != targetRedstoneLevel && (event = CraftEventFactory.callRedstoneChange(level, pos, currentRedstoneLevel, targetRedstoneLevel)).getNewCurrent() != targetRedstoneLevel) {
            return;
        }
        level.a(pos, (IBlockData)state.b(c, powered), 3);
        BlockLectern.b(level, pos, state);
    }

    private static void b(World level, BlockPosition pos, IBlockData state) {
        Orientation orientation = ExperimentalRedstoneUtils.a(level, state.c(b).g(), EnumDirection.b);
        level.a(pos.e(), state.b(), orientation);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        BlockLectern.a((World)level, pos, state, false);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (state.c(c).booleanValue()) {
            BlockLectern.b(level, pos, state);
        }
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return state.c(c) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection side) {
        return side == EnumDirection.b && state.c(c) != false ? 15 : 0;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        TileEntity blockEntity;
        if (state.c(d).booleanValue() && (blockEntity = level.c_(pos)) instanceof TileEntityLectern) {
            return ((TileEntityLectern)blockEntity).k();
        }
        return 0;
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (state.c(d).booleanValue()) {
            return EnumInteractionResult.f;
        }
        if (stack.a(TagsItem.bs)) {
            return (EnumInteractionResult)((Object)(BlockLectern.a(player, level, pos, state, stack) ? EnumInteractionResult.a : EnumInteractionResult.e));
        }
        return (EnumInteractionResult)((Object)(stack.f() && hand == EnumHand.a ? EnumInteractionResult.e : EnumInteractionResult.f));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(d).booleanValue()) {
            if (!level.B_()) {
                this.a(level, pos, player);
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.c;
    }

    @Override
    public @Nullable ITileInventory a(IBlockData state, World level, BlockPosition pos) {
        return state.c(d) == false ? null : super.a(state, level, pos);
    }

    private void a(World level, BlockPosition pos, EntityHuman player) {
        TileEntityLectern lecternBlockEntity;
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityLectern && player.a(lecternBlockEntity = (TileEntityLectern)blockEntity).isPresent()) {
            player.a(StatisticList.aw);
        }
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

