/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.MinecartTrackLogic;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.jspecify.annotations.Nullable;

public abstract class BlockMinecartTrackAbstract
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean a = BlockProperties.I;
    private static final VoxelShape b = Block.b(16.0, 0.0, 2.0);
    private static final VoxelShape c = Block.b(16.0, 0.0, 8.0);
    private final boolean d;

    public static boolean a(World level, BlockPosition pos) {
        return BlockMinecartTrackAbstract.h(level.a_(pos));
    }

    public static boolean h(IBlockData state) {
        return state.a(TagsBlock.L) && state.b() instanceof BlockMinecartTrackAbstract;
    }

    protected BlockMinecartTrackAbstract(boolean isStraight, BlockBase.Info properties) {
        super(properties);
        this.d = isStraight;
    }

    protected abstract MapCodec<? extends BlockMinecartTrackAbstract> a();

    public boolean b() {
        return this.d;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(this.c()).b() ? c : b;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return BlockMinecartTrackAbstract.c(level, pos.e());
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (!oldState.a(state.b())) {
            this.a(state, level, pos, movedByPiston);
        }
    }

    protected IBlockData a(IBlockData state, World level, BlockPosition pos, boolean movedByPiston) {
        state = this.a(level, pos, state, true);
        if (this.d) {
            level.a(state, pos, this, null, movedByPiston);
            state = level.a_(pos);
        }
        return state;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.B_() && level.a_(pos).a(this)) {
            BlockPropertyTrackPosition railShape = state.c(this.c());
            if (BlockMinecartTrackAbstract.a(pos, level, railShape)) {
                BlockMinecartTrackAbstract.b(state, level, pos);
                level.a(pos, movedByPiston);
            } else {
                this.a(state, level, pos, neighborBlock);
            }
        }
    }

    private static boolean a(BlockPosition pos, World level, BlockPropertyTrackPosition shape) {
        if (!BlockMinecartTrackAbstract.c(level, pos.e())) {
            return true;
        }
        switch (shape) {
            case c: {
                return !BlockMinecartTrackAbstract.c(level, pos.i());
            }
            case d: {
                return !BlockMinecartTrackAbstract.c(level, pos.h());
            }
            case e: {
                return !BlockMinecartTrackAbstract.c(level, pos.f());
            }
            case f: {
                return !BlockMinecartTrackAbstract.c(level, pos.g());
            }
        }
        return false;
    }

    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock) {
    }

    protected IBlockData a(World level, BlockPosition pos, IBlockData state, boolean alwaysPlace) {
        if (level.B_()) {
            return state;
        }
        BlockPropertyTrackPosition railShape = state.c(this.c());
        return new MinecartTrackLogic(level, pos, state).a(level.I(pos), alwaysPlace, railShape).c();
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston) {
            if (state.c(this.c()).b()) {
                level.a(pos.d(), this);
            }
            if (this.d) {
                level.a(pos, this);
                level.a(pos.e(), this);
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        boolean flag = fluidState.a() == FluidTypes.c;
        IBlockData blockState = super.m();
        EnumDirection horizontalDirection = context.g();
        boolean flag1 = horizontalDirection == EnumDirection.f || horizontalDirection == EnumDirection.e;
        return (IBlockData)((IBlockData)blockState.b(this.c(), flag1 ? BlockPropertyTrackPosition.b : BlockPropertyTrackPosition.a)).b(a, flag);
    }

    public abstract IBlockState<BlockPropertyTrackPosition> c();

    protected BlockPropertyTrackPosition a(BlockPropertyTrackPosition railShape, EnumBlockRotation rotation) {
        return switch (rotation) {
            case EnumBlockRotation.c -> {
                switch (railShape) {
                    case c: {
                        yield BlockPropertyTrackPosition.d;
                    }
                    case d: {
                        yield BlockPropertyTrackPosition.c;
                    }
                    case e: {
                        yield BlockPropertyTrackPosition.f;
                    }
                    case f: {
                        yield BlockPropertyTrackPosition.e;
                    }
                    case a: {
                        yield BlockPropertyTrackPosition.a;
                    }
                    case b: {
                        yield BlockPropertyTrackPosition.b;
                    }
                    case g: {
                        yield BlockPropertyTrackPosition.i;
                    }
                    case h: {
                        yield BlockPropertyTrackPosition.j;
                    }
                    case i: {
                        yield BlockPropertyTrackPosition.g;
                    }
                    case j: {
                        yield BlockPropertyTrackPosition.h;
                    }
                }
                throw new MatchException(null, null);
            }
            case EnumBlockRotation.d -> {
                switch (railShape) {
                    case c: {
                        yield BlockPropertyTrackPosition.e;
                    }
                    case d: {
                        yield BlockPropertyTrackPosition.f;
                    }
                    case e: {
                        yield BlockPropertyTrackPosition.d;
                    }
                    case f: {
                        yield BlockPropertyTrackPosition.c;
                    }
                    case a: {
                        yield BlockPropertyTrackPosition.b;
                    }
                    case b: {
                        yield BlockPropertyTrackPosition.a;
                    }
                    case g: {
                        yield BlockPropertyTrackPosition.j;
                    }
                    case h: {
                        yield BlockPropertyTrackPosition.g;
                    }
                    case i: {
                        yield BlockPropertyTrackPosition.h;
                    }
                    case j: {
                        yield BlockPropertyTrackPosition.i;
                    }
                }
                throw new MatchException(null, null);
            }
            case EnumBlockRotation.b -> {
                switch (railShape) {
                    case c: {
                        yield BlockPropertyTrackPosition.f;
                    }
                    case d: {
                        yield BlockPropertyTrackPosition.e;
                    }
                    case e: {
                        yield BlockPropertyTrackPosition.c;
                    }
                    case f: {
                        yield BlockPropertyTrackPosition.d;
                    }
                    case a: {
                        yield BlockPropertyTrackPosition.b;
                    }
                    case b: {
                        yield BlockPropertyTrackPosition.a;
                    }
                    case g: {
                        yield BlockPropertyTrackPosition.h;
                    }
                    case h: {
                        yield BlockPropertyTrackPosition.i;
                    }
                    case i: {
                        yield BlockPropertyTrackPosition.j;
                    }
                    case j: {
                        yield BlockPropertyTrackPosition.g;
                    }
                }
                throw new MatchException(null, null);
            }
            default -> railShape;
        };
    }

    protected BlockPropertyTrackPosition a(BlockPropertyTrackPosition railShape, EnumBlockMirror mirror) {
        return switch (mirror) {
            case EnumBlockMirror.b -> {
                switch (railShape) {
                    case e: {
                        yield BlockPropertyTrackPosition.f;
                    }
                    case f: {
                        yield BlockPropertyTrackPosition.e;
                    }
                    default: {
                        yield railShape;
                    }
                    case g: {
                        yield BlockPropertyTrackPosition.j;
                    }
                    case h: {
                        yield BlockPropertyTrackPosition.i;
                    }
                    case i: {
                        yield BlockPropertyTrackPosition.h;
                    }
                    case j: 
                }
                yield BlockPropertyTrackPosition.g;
            }
            case EnumBlockMirror.c -> {
                switch (railShape) {
                    case c: {
                        yield BlockPropertyTrackPosition.d;
                    }
                    case d: {
                        yield BlockPropertyTrackPosition.c;
                    }
                    default: {
                        yield railShape;
                    }
                    case g: {
                        yield BlockPropertyTrackPosition.h;
                    }
                    case h: {
                        yield BlockPropertyTrackPosition.g;
                    }
                    case i: {
                        yield BlockPropertyTrackPosition.j;
                    }
                    case j: 
                }
                yield BlockPropertyTrackPosition.i;
            }
            default -> railShape;
        };
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(a).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(a) != false ? FluidTypes.c.a(false) : super.b_(state);
    }
}

