/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateWeighted> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)1024).fieldOf("max_weight").forGetter(weightedPressurePlateBlock -> weightedPressurePlateBlock.e), (App)BlockSetType.a.fieldOf("block_set_type").forGetter(weightedPressurePlateBlock -> weightedPressurePlateBlock.b), BlockPressurePlateWeighted.x()).apply((Applicative)instance, BlockPressurePlateWeighted::new));
    public static final BlockStateInteger d = BlockProperties.aX;
    private final int e;

    public MapCodec<BlockPressurePlateWeighted> a() {
        return c;
    }

    protected BlockPressurePlateWeighted(int maxWeight, BlockSetType type, BlockBase.Info properties) {
        super(properties, type);
        this.l((IBlockData)this.C.b().b(d, 0));
        this.e = maxWeight;
    }

    @Override
    protected int b(World level, BlockPosition pos) {
        int min = 0;
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateWeighted.getEntities(level, BlockPressurePlateAbstract.a.a(pos), net.minecraft.world.entity.Entity.class)) {
            EntityInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                cancellable = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos));
                level.getCraftServer().getPluginManager().callEvent((Event)cancellable);
            }
            if (cancellable.isCancelled()) continue;
            ++min;
        }
        if (min > 0) {
            float f2 = (float)Math.min(this.e, min) / (float)this.e;
            return MathHelper.d(f2 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int h(IBlockData state) {
        return state.c(d);
    }

    @Override
    protected IBlockData a(IBlockData state, int strength) {
        return (IBlockData)state.b(d, strength);
    }

    @Override
    protected int b() {
        return 10;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }
}

