/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.jspecify.annotations.Nullable;

public class BlockRespawnAnchor
extends Block {
    public static final MapCodec<BlockRespawnAnchor> a = BlockRespawnAnchor.b(BlockRespawnAnchor::new);
    public static final int b = 0;
    public static final int c = 4;
    public static final BlockStateInteger d = BlockProperties.bd;
    private static final ImmutableList<BaseBlockPosition> e = ImmutableList.of((Object)new BaseBlockPosition(0, 0, -1), (Object)new BaseBlockPosition(-1, 0, 0), (Object)new BaseBlockPosition(0, 0, 1), (Object)new BaseBlockPosition(1, 0, 0), (Object)new BaseBlockPosition(-1, 0, -1), (Object)new BaseBlockPosition(1, 0, -1), (Object)new BaseBlockPosition(-1, 0, 1), (Object)new BaseBlockPosition(1, 0, 1));
    private static final ImmutableList<BaseBlockPosition> f = new ImmutableList.Builder().addAll(e).addAll(e.stream().map(BaseBlockPosition::p).iterator()).addAll(e.stream().map(BaseBlockPosition::q).iterator()).add((Object)new BaseBlockPosition(0, 1, 0)).build();

    public MapCodec<BlockRespawnAnchor> a() {
        return a;
    }

    public BlockRespawnAnchor(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.C.b().b(d, 0));
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (BlockRespawnAnchor.a(stack) && BlockRespawnAnchor.p(state)) {
            BlockRespawnAnchor.a(player, level, pos, state);
            stack.a(1, (EntityLiving)player);
            return EnumInteractionResult.a;
        }
        return (EnumInteractionResult)((Object)(hand == EnumHand.a && BlockRespawnAnchor.a(player.b(EnumHand.b)) && BlockRespawnAnchor.p(state) ? EnumInteractionResult.e : EnumInteractionResult.f));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(d) == 0) {
            return EnumInteractionResult.e;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (!BlockRespawnAnchor.a(serverLevel, pos)) {
                this.a(state, serverLevel, pos);
                return EnumInteractionResult.b;
            }
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                EntityPlayer.RespawnConfig respawnConfig = serverPlayer.V();
                EntityPlayer.RespawnConfig respawnConfig1 = new EntityPlayer.RespawnConfig(WorldData.a.a(serverLevel.aq(), pos, 0.0f, 0.0f), false);
                if (respawnConfig == null || !respawnConfig.a(respawnConfig1)) {
                    if (serverPlayer.setRespawnPosition(respawnConfig1, true, PlayerSetSpawnEvent.Cause.RESPAWN_ANCHOR)) {
                        serverLevel.a(null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.yt, SoundCategory.e, 1.0f, 1.0f);
                        return EnumInteractionResult.b;
                    }
                    return EnumInteractionResult.d;
                }
            }
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.c;
    }

    private static boolean a(ItemStack stack) {
        return stack.a(Items.gd);
    }

    private static boolean p(IBlockData state) {
        return state.c(d) < 4;
    }

    private static boolean a(BlockPosition pos, World level) {
        Fluid fluidState = level.b_(pos);
        if (!fluidState.a(TagsFluid.a)) {
            return false;
        }
        if (fluidState.b()) {
            return true;
        }
        float f2 = fluidState.e();
        if (f2 < 2.0f) {
            return false;
        }
        Fluid fluidState1 = level.b_(pos.e());
        return !fluidState1.a(TagsFluid.a);
    }

    private void a(IBlockData state, WorldServer level, final BlockPosition pos2) {
        BlockState blockState = CraftBlock.at(level, pos2).getState();
        level.a(pos2, false);
        boolean flag = EnumDirection.EnumDirectionLimit.a.a().map(pos2::a).anyMatch(blockPos -> BlockRespawnAnchor.a(blockPos, level));
        final boolean flag1 = flag || level.b_(pos2.d()).a(TagsFluid.a);
        ExplosionDamageCalculator explosionDamageCalculator = new ExplosionDamageCalculator(this){

            @Override
            public Optional<Float> a(Explosion explosion, IBlockAccess level1, BlockPosition pos, IBlockData state1, Fluid fluid) {
                return pos.equals(pos2) && flag1 ? Optional.of(Float.valueOf(Blocks.J.e())) : super.a(explosion, level1, pos, state1, fluid);
            }
        };
        Vec3D center = pos2.b();
        level.a(null, level.as().a(center).causingBlockSnapshot(blockState), explosionDamageCalculator, center, 5.0f, true, World.a.b);
    }

    public static boolean a(WorldServer level, BlockPosition pos) {
        return level.c().a(EnvironmentAttributes.D, pos);
    }

    public static void a(@Nullable Entity entity, World level, BlockPosition pos, IBlockData state) {
        IBlockData blockState = (IBlockData)state.b(d, state.c(d) + 1);
        level.a(pos, blockState, 3);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
        level.a(null, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.yr, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(d) != 0) {
            if (random.a(100) == 0) {
                level.a(pos, SoundEffects.yq, SoundCategory.e, 1.0f, 1.0f, false);
            }
            double d2 = (double)pos.u() + 0.5 + (0.5 - random.j());
            double d1 = (double)pos.v() + 1.0;
            double d22 = (double)pos.w() + 0.5 + (0.5 - random.j());
            double d3 = (double)random.i() * 0.04;
            level.a(Particles.aL, d2, d1, d22, 0.0, d3, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    public static int a(IBlockData state, int scale) {
        return MathHelper.b((float)(state.c(d) - 0) / 4.0f * (float)scale);
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return BlockRespawnAnchor.a(state, 15);
    }

    public static Optional<Vec3D> a(EntityTypes<?> entityType, ICollisionAccess level, BlockPosition pos) {
        Optional<Vec3D> optional = BlockRespawnAnchor.a(entityType, level, pos, true);
        return optional.isPresent() ? optional : BlockRespawnAnchor.a(entityType, level, pos, false);
    }

    private static Optional<Vec3D> a(EntityTypes<?> entityType, ICollisionAccess level, BlockPosition pos, boolean simulate) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (BaseBlockPosition vec3i : f) {
            mutableBlockPos.g(pos).h(vec3i);
            Vec3D vec3 = DismountUtil.a(entityType, level, mutableBlockPos, simulate);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

