/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class BlockStem
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockStem> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.i).fieldOf("fruit").forGetter(stemBlock -> stemBlock.e), (App)ResourceKey.a(Registries.i).fieldOf("attached_stem").forGetter(stemBlock -> stemBlock.f), (App)ResourceKey.a(Registries.R).fieldOf("seed").forGetter(stemBlock -> stemBlock.g), BlockStem.x()).apply((Applicative)instance, BlockStem::new));
    public static final int b = 7;
    public static final BlockStateInteger c = BlockProperties.az;
    private static final VoxelShape[] d = Block.a(7, (int i2) -> Block.b(2.0, 0.0, 2 + i2 * 2));
    private final ResourceKey<Block> e;
    private final ResourceKey<Block> f;
    private final ResourceKey<Item> g;

    public MapCodec<BlockStem> a() {
        return a;
    }

    protected BlockStem(ResourceKey<Block> fruit, ResourceKey<Block> attachedStem, ResourceKey<Item> seed, BlockBase.Info properties) {
        super(properties);
        this.e = fruit;
        this.f = attachedStem;
        this.g = seed;
        this.l((IBlockData)this.C.b().b(c, 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d[state.c(c)];
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(Blocks.cZ);
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.b(pos, 0) >= 9) {
            float growthSpeed = BlockCrops.a(this, level, pos);
            double d2 = random.i();
            int n2 = this == Blocks.fL ? level.spigotConfig.pumpkinModifier : level.spigotConfig.melonModifier;
            if (d2 < (double)n2 / (100.0 * Math.floor(25.0f / growthSpeed + 1.0f))) {
                int ageValue = state.c(c);
                if (ageValue < 7) {
                    state = (IBlockData)state.b(c, ageValue + 1);
                    CraftEventFactory.handleBlockGrowEvent(level, pos, state, 2);
                } else {
                    EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
                    BlockPosition blockPos = pos.a(randomDirection);
                    IBlockData blockState = level.a_(blockPos.e());
                    if (level.a_(blockPos).l() && (blockState.a(Blocks.cZ) || blockState.a(TagsBlock.ae))) {
                        IRegistry<Block> registry = level.J_().f(Registries.i);
                        Optional<Block> optional = registry.f(this.e);
                        Optional<Block> optional1 = registry.f(this.f);
                        if (optional.isPresent() && optional1.isPresent()) {
                            if (!CraftEventFactory.handleBlockGrowEvent(level, blockPos, optional.get().m(), 3)) {
                                return;
                            }
                            level.c(pos, (IBlockData)optional1.get().m().b(BlockFacingHorizontal.f, randomDirection));
                        }
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(level.J_().f(Registries.R).f(this.g), (Object)this));
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.c(c) != 7;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        int min = Math.min(7, state.c(c) + MathHelper.a(level.y, 2, 5));
        IBlockData blockState = (IBlockData)state.b(c, min);
        CraftEventFactory.handleBlockGrowEvent(level, pos, blockState, 2);
        if (min == 7) {
            blockState.b(level, pos, level.y);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }
}

