/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockStepAbstract
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStepAbstract> a = BlockStepAbstract.b(BlockStepAbstract::new);
    public static final BlockStateEnum<BlockPropertySlabType> b = BlockProperties.bm;
    public static final BlockStateBoolean c = BlockProperties.I;
    private static final VoxelShape d = Block.b(16.0, 0.0, 8.0);
    private static final VoxelShape e = Block.b(16.0, 8.0, 16.0);

    public MapCodec<? extends BlockStepAbstract> a() {
        return a;
    }

    public BlockStepAbstract(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.m().b(b, BlockPropertySlabType.b)).b(c, false));
    }

    @Override
    protected boolean g_(IBlockData state) {
        return state.c(b) != BlockPropertySlabType.c;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return switch (state.c(b)) {
            default -> throw new MatchException(null, null);
            case BlockPropertySlabType.a -> e;
            case BlockPropertySlabType.b -> d;
            case BlockPropertySlabType.c -> VoxelShapes.b();
        };
    }

    @Override
    public @Nullable IBlockData a(BlockActionContext context) {
        BlockPosition clickedPos = context.a();
        IBlockData blockState = context.q().a_(clickedPos);
        if (blockState.a(this)) {
            return (IBlockData)((IBlockData)blockState.b(b, BlockPropertySlabType.c)).b(c, false);
        }
        Fluid fluidState = context.q().b_(clickedPos);
        IBlockData blockState1 = (IBlockData)((IBlockData)this.m().b(b, BlockPropertySlabType.b)).b(c, fluidState.a() == FluidTypes.c);
        EnumDirection clickedFace = context.k();
        return !(clickedFace == EnumDirection.a || clickedFace != EnumDirection.b && context.l().h - (double)clickedPos.v() > 0.5) ? blockState1 : (IBlockData)blockState1.b(b, BlockPropertySlabType.a);
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        ItemStack itemInHand = useContext.n();
        BlockPropertySlabType slabType = state.c(b);
        if (slabType == BlockPropertySlabType.c || !itemInHand.a(this.h())) {
            return false;
        }
        if (useContext.c()) {
            boolean flag = useContext.l().h - (double)useContext.a().v() > 0.5;
            EnumDirection clickedFace = useContext.k();
            return slabType == BlockPropertySlabType.b ? clickedFace == EnumDirection.b || flag && clickedFace.o().d() : clickedFace == EnumDirection.a || !flag && clickedFace.o().d();
        }
        return true;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    public boolean a(GeneratorAccess level, BlockPosition pos, IBlockData state, Fluid fluidState) {
        return state.c(b) != BlockPropertySlabType.c && IBlockWaterlogged.super.a(level, pos, state, fluidState);
    }

    @Override
    public boolean a(@Nullable EntityLiving owner, IBlockAccess level, BlockPosition pos, IBlockData state, FluidType fluid) {
        return state.c(b) != BlockPropertySlabType.c && IBlockWaterlogged.super.a(owner, level, pos, state, fluid);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        switch (pathComputationType) {
            case a: {
                return false;
            }
            case b: {
                return state.y().a(TagsFluid.a);
            }
            case c: {
                return false;
            }
        }
        return false;
    }
}

