/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class BrushableBlock
extends BlockTileEntity
implements Fallable {
    public static final MapCodec<BrushableBlock> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("turns_into").forGetter(BrushableBlock::b), (App)BuiltInRegistries.b.q().fieldOf("brush_sound").forGetter(BrushableBlock::c), (App)BuiltInRegistries.b.q().fieldOf("brush_completed_sound").forGetter(BrushableBlock::d), BrushableBlock.x()).apply((Applicative)instance, BrushableBlock::new));
    private static final BlockStateInteger c = BlockProperties.bA;
    public static final int b = 2;
    private final Block d;
    private final SoundEffect e;
    private final SoundEffect f;

    public MapCodec<BrushableBlock> a() {
        return a;
    }

    public BrushableBlock(Block turnsInto, SoundEffect brushSound, SoundEffect brushCompletedSound, BlockBase.Info properties) {
        super(properties);
        this.d = turnsInto;
        this.e = brushSound;
        this.f = brushCompletedSound;
        this.l((IBlockData)this.C.b().b(c, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        level.a(pos, (Block)this, 2);
    }

    @Override
    public IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        scheduledTickAccess.a(pos, this, 2);
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof BrushableBlockEntity) {
            BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)tileEntity;
            brushableBlockEntity.a(level);
        }
        if (BlockFalling.n(level.a_(pos.e())) && pos.v() >= level.K_()) {
            EntityFallingBlock fallingBlockEntity = EntityFallingBlock.a(level, pos, state);
            fallingBlockEntity.f();
        }
    }

    @Override
    public void a(World level, BlockPosition pos, EntityFallingBlock fallingBlock) {
        Vec3D center = fallingBlock.dj().f();
        level.c(2001, BlockPosition.a(center), Block.j(fallingBlock.i()));
        level.a((Entity)fallingBlock, GameEvent.f, center);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos;
        if (random.a(16) == 0 && BlockFalling.n(level.a_(blockPos = pos.e()))) {
            double d2 = (double)pos.u() + random.j();
            double d1 = (double)pos.v() - 0.05;
            double d22 = (double)pos.w() + random.j();
            level.a(new ParticleParamBlock(Particles.D, state), d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public @Nullable TileEntity a(BlockPosition pos, IBlockData state) {
        return new BrushableBlockEntity(pos, state);
    }

    public Block b() {
        return this.d;
    }

    public SoundEffect c() {
        return this.e;
    }

    public SoundEffect d() {
        return this.f;
    }
}

