/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jspecify.annotations.Nullable;

public class ChiseledBookShelfBlock
extends BlockTileEntity
implements SelectableSlotContainer {
    public static final MapCodec<ChiseledBookShelfBlock> a = ChiseledBookShelfBlock.b(ChiseledBookShelfBlock::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.f;
    public static final BlockStateBoolean c = BlockProperties.bu;
    public static final BlockStateBoolean d = BlockProperties.bv;
    public static final BlockStateBoolean e = BlockProperties.bw;
    public static final BlockStateBoolean f = BlockProperties.bx;
    public static final BlockStateBoolean g = BlockProperties.by;
    public static final BlockStateBoolean h = BlockProperties.bz;
    private static final int D = 6;
    private static final int R = 3;
    public static final List<BlockStateBoolean> i = List.of(c, d, e, f, g, h);

    public MapCodec<ChiseledBookShelfBlock> a() {
        return a;
    }

    @Override
    public int b() {
        return 2;
    }

    @Override
    public int c() {
        return 3;
    }

    public ChiseledBookShelfBlock(BlockBase.Info properties) {
        super(properties);
        IBlockData blockState = (IBlockData)this.C.b().b(b, EnumDirection.c);
        for (BlockStateBoolean booleanProperty : i) {
            blockState = (IBlockData)blockState.b(booleanProperty, false);
        }
        this.l(blockState);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            if (!stack.a(TagsItem.bt)) {
                return EnumInteractionResult.f;
            }
            OptionalInt hitSlot = this.a(hitResult, state.c(b));
            if (hitSlot.isEmpty()) {
                return EnumInteractionResult.e;
            }
            if (((Boolean)state.c(i.get(hitSlot.getAsInt()))).booleanValue()) {
                return EnumInteractionResult.f;
            }
            ChiseledBookShelfBlock.a(level, pos, player, chiseledBookShelfBlockEntity, stack, hitSlot.getAsInt());
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            OptionalInt hitSlot = this.a(hitResult, state.c(b));
            if (hitSlot.isEmpty()) {
                return EnumInteractionResult.e;
            }
            if (!((Boolean)state.c(i.get(hitSlot.getAsInt()))).booleanValue()) {
                return EnumInteractionResult.c;
            }
            ChiseledBookShelfBlock.a(level, pos, player, chiseledBookShelfBlockEntity, hitSlot.getAsInt());
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    private static void a(World level, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, ItemStack bookStack, int slot) {
        if (!level.B_()) {
            player.b(StatisticList.c.b(bookStack.h()));
            SoundEffect soundEvent = bookStack.a(Items.wI) ? SoundEffects.fB : SoundEffects.fA;
            blockEntity.a(slot, bookStack.b(1, (EntityLiving)player));
            level.a(null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    private static void a(World level, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, int slot) {
        if (!level.B_()) {
            ItemStack itemStack = blockEntity.a(slot, 1);
            SoundEffect soundEvent = itemStack.a(Items.wI) ? SoundEffects.fE : SoundEffects.fD;
            level.a(null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
            if (!player.gK().g(itemStack)) {
                player.a(itemStack, false);
            }
            level.a((Entity)player, GameEvent.c, pos);
        }
    }

    @Override
    public @Nullable TileEntity a(BlockPosition pos, IBlockData state) {
        return new ChiseledBookShelfBlockEntity(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
        i.forEach(property -> builder.a(new IBlockState[]{property}));
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(b, context.g().g());
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        int n2;
        if (level.B_()) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            n2 = chiseledBookShelfBlockEntity.k() + 1;
        } else {
            n2 = 0;
        }
        return n2;
    }
}

