/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;

public class CopperChestBlock
extends BlockChest {
    public static final MapCodec<CopperChestBlock> g = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeatheringCopper.a.f.fieldOf("weathering_state").forGetter(CopperChestBlock::t), (App)BuiltInRegistries.b.q().fieldOf("open_sound").forGetter(BlockChest::r), (App)BuiltInRegistries.b.q().fieldOf("close_sound").forGetter(BlockChest::s), CopperChestBlock.x()).apply((Applicative)instance, CopperChestBlock::new));
    private static final Map<Block, Supplier<Block>> h = Map.of(Blocks.rW, () -> Blocks.ts, Blocks.rX, () -> Blocks.tt, Blocks.rY, () -> Blocks.tu, Blocks.rZ, () -> Blocks.tv, Blocks.sw, () -> Blocks.ts, Blocks.sy, () -> Blocks.tt, Blocks.sx, () -> Blocks.tu, Blocks.sz, () -> Blocks.tv);
    private final WeatheringCopper.a i;

    @Override
    public MapCodec<? extends CopperChestBlock> a() {
        return g;
    }

    public CopperChestBlock(WeatheringCopper.a weatherState, SoundEffect openSound, SoundEffect closeSound, BlockBase.Info properties) {
        super(() -> TileEntityTypes.b, openSound, closeSound, properties);
        this.i = weatherState;
    }

    @Override
    public boolean i(IBlockData state) {
        return state.a(TagsBlock.ai) && state.b(BlockChest.d);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = super.a(context);
        return CopperChestBlock.c(blockState, context.q(), context.a());
    }

    private static IBlockData c(IBlockData state, World level, BlockPosition pos) {
        Block block;
        IBlockData blockState = level.a_(pos.a(CopperChestBlock.n(state)));
        if (!state.c(BlockChest.d).equals(BlockPropertyChestType.a) && (block = state.b()) instanceof CopperChestBlock) {
            CopperChestBlock copperChestBlock = (CopperChestBlock)block;
            block = blockState.b();
            if (block instanceof CopperChestBlock) {
                CopperChestBlock copperChestBlock1 = (CopperChestBlock)block;
                IBlockData blockState1 = state;
                IBlockData blockState2 = blockState;
                if (copperChestBlock.u() != copperChestBlock1.u()) {
                    blockState1 = CopperChestBlock.a(copperChestBlock, state).orElse(state);
                    blockState2 = CopperChestBlock.a(copperChestBlock1, blockState).orElse(blockState);
                }
                Block block2 = copperChestBlock.i.ordinal() <= copperChestBlock1.i.ordinal() ? blockState1.b() : blockState2.b();
                return block2.m(blockState1);
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        BlockPropertyChestType chestType;
        IBlockData blockState = super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        if (this.i(neighborState) && !(chestType = blockState.c(BlockChest.d)).equals(BlockPropertyChestType.a) && CopperChestBlock.n(blockState) == direction) {
            return neighborState.b().m(blockState);
        }
        return blockState;
    }

    private static Optional<IBlockData> a(CopperChestBlock chestBlock, IBlockData state) {
        return !chestBlock.u() ? Optional.of(state) : Optional.ofNullable((Block)HoneycombItem.b.get().get((Object)state.b())).map(block -> block.m(state));
    }

    public WeatheringCopper.a t() {
        return this.i;
    }

    public static IBlockData a(Block copperBlock, EnumDirection direction, World level, BlockPosition pos) {
        CopperChestBlock copperChestBlock = (CopperChestBlock)h.getOrDefault(copperBlock, Blocks.ts::o).get();
        BlockPropertyChestType chestType = copperChestBlock.a(level, pos, direction);
        IBlockData blockState = (IBlockData)((IBlockData)copperChestBlock.m().b(BlockChest.c, direction)).b(BlockChest.d, chestType);
        return CopperChestBlock.c(blockState, level, pos);
    }

    public boolean u() {
        return true;
    }

    @Override
    public boolean o(IBlockData state) {
        return state.a(TagsBlock.ai);
    }
}

