/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public class CrafterBlock
extends BlockTileEntity {
    public static final MapCodec<CrafterBlock> a = CrafterBlock.b(CrafterBlock::new);
    public static final BlockStateBoolean b = BlockProperties.bC;
    public static final BlockStateBoolean c = BlockProperties.G;
    private static final BlockStateEnum<BlockPropertyJigsawOrientation> d = BlockProperties.W;
    private static final int e = 6;
    private static final int f = 4;
    private static final RecipeCache g = new RecipeCache(10);
    private static final int h = 17;

    public CrafterBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(d, BlockPropertyJigsawOrientation.k)).b(c, false)).b(b, false));
    }

    protected MapCodec<CrafterBlock> a() {
        return a;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        int n2;
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)tileEntity;
            n2 = crafterBlockEntity.w();
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean hasNeighborSignal = level.I(pos);
        boolean triggeredValue = state.c(c);
        TileEntity blockEntity = level.c_(pos);
        if (hasNeighborSignal && !triggeredValue) {
            level.a(pos, (Block)this, 4);
            level.a(pos, (IBlockData)state.b(c, true), 2);
            this.a(blockEntity, true);
        } else if (!hasNeighborSignal && triggeredValue) {
            level.a(pos, (IBlockData)((IBlockData)state.b(c, false)).b(b, false), 2);
            this.a(blockEntity, false);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        this.a(state, level, pos);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.B_() ? null : CrafterBlock.a(blockEntityType, TileEntityTypes.R, CrafterBlockEntity::a);
    }

    private void a(@Nullable TileEntity blockEntity, boolean triggered) {
        if (blockEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)blockEntity;
            crafterBlockEntity.a(triggered);
        }
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        CrafterBlockEntity crafterBlockEntity = new CrafterBlockEntity(pos, state);
        crafterBlockEntity.a(state.b(c) && state.c(c) != false);
        return crafterBlockEntity;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection opposite = context.d().g();
        EnumDirection direction = switch (opposite) {
            default -> throw new MatchException(null, null);
            case EnumDirection.a -> context.g().g();
            case EnumDirection.b -> context.g();
            case EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f -> EnumDirection.b;
        };
        return (IBlockData)((IBlockData)this.m().b(d, BlockPropertyJigsawOrientation.a(opposite, direction))).b(c, context.q().I(context.a()));
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, net.minecraft.world.item.ItemStack stack) {
        if (state.c(c).booleanValue()) {
            level.a(pos, (Block)this, 4);
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity;
        if (!level.B_() && (tileEntity = level.c_(pos)) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)tileEntity;
            player.a(crafterBlockEntity);
        }
        return EnumInteractionResult.a;
    }

    protected void a(IBlockData state, WorldServer level, BlockPosition pos) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterBlockEntity = (CrafterBlockEntity)tileEntity;
            CraftingInput var11 = crafterBlockEntity.aE_();
            Optional<RecipeHolder<RecipeCrafting>> potentialResults = CrafterBlock.a(level, var11);
            if (potentialResults.isEmpty()) {
                level.c(1050, pos, 0);
            } else {
                RecipeHolder<RecipeCrafting> recipeHolder = potentialResults.get();
                net.minecraft.world.item.ItemStack itemStack = recipeHolder.b().a(var11, level.J_());
                CrafterCraftEvent event = CraftEventFactory.callCrafterCraftEvent(pos, level, itemStack, recipeHolder);
                if (event.isCancelled()) {
                    return;
                }
                itemStack = CraftItemStack.asNMSCopy(event.getResult());
                if (itemStack.f()) {
                    level.c(1050, pos, 0);
                } else {
                    crafterBlockEntity.e(6);
                    level.a(pos, (IBlockData)state.b(b, true), 2);
                    itemStack.a(level);
                    this.a(level, pos, crafterBlockEntity, itemStack, state, recipeHolder);
                    for (net.minecraft.world.item.ItemStack itemStack1 : recipeHolder.b().a(var11)) {
                        if (itemStack1.f()) continue;
                        this.a(level, pos, crafterBlockEntity, itemStack1, state, recipeHolder);
                    }
                    crafterBlockEntity.g().forEach(stack -> {
                        if (!stack.f()) {
                            stack.h(1);
                        }
                    });
                    crafterBlockEntity.e();
                }
            }
        }
    }

    public static Optional<RecipeHolder<RecipeCrafting>> a(WorldServer level, CraftingInput craftingInput) {
        return g.a(level, craftingInput);
    }

    private void a(WorldServer level, BlockPosition pos, CrafterBlockEntity crafter, net.minecraft.world.item.ItemStack stack, IBlockData state, RecipeHolder<?> recipe) {
        EnumDirection direction = state.c(d).a();
        IInventory containerAt = TileEntityHopper.a((World)level, pos.a(direction));
        net.minecraft.world.item.ItemStack itemStack = stack.v();
        if (containerAt != null && (containerAt instanceof CrafterBlockEntity || stack.N() > containerAt.f_(stack))) {
            net.minecraft.world.item.ItemStack itemStack1;
            net.minecraft.world.item.ItemStack itemStack2;
            oitemstack = CraftItemStack.asCraftMirror(itemStack);
            if (containerAt instanceof InventoryLargeChest) {
                compoundContainer = (InventoryLargeChest)containerAt;
                destinationInventory = new CraftInventoryDoubleChest(compoundContainer);
            } else {
                destinationInventory = containerAt.getOwner().getInventory();
            }
            event = new InventoryMoveItemEvent(crafter.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            itemStack = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemStack.f() && !event.isCancelled() && (itemStack2 = TileEntityHopper.a((IInventory)crafter, containerAt, itemStack1 = itemStack.c(1), direction.g())).f()) {
                itemStack.h(1);
            }
        } else if (containerAt != null) {
            int count;
            oitemstack = CraftItemStack.asCraftMirror(itemStack);
            if (containerAt instanceof InventoryLargeChest) {
                compoundContainer = (InventoryLargeChest)containerAt;
                destinationInventory = new CraftInventoryDoubleChest(compoundContainer);
            } else {
                destinationInventory = containerAt.getOwner().getInventory();
            }
            event = new InventoryMoveItemEvent(crafter.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            itemStack = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemStack.f() && !event.isCancelled() && (count = itemStack.N()) != (itemStack = TileEntityHopper.a((IInventory)crafter, containerAt, itemStack, direction.g())).N()) {
            }
        }
        if (!itemStack.f()) {
            Vec3D vec3 = Vec3D.b(pos);
            Vec3D vec31 = vec3.a(direction, 0.7);
            DispenseBehaviorItem.a(level, itemStack, 6, direction, vec31);
            for (EntityPlayer serverPlayer : level.a(EntityPlayer.class, AxisAlignedBB.a(vec3, 17.0, 17.0, 17.0))) {
                CriterionTriggers.af.a(serverPlayer, recipe.a(), crafter.g());
            }
            level.c(1049, pos, 0);
            level.c(2010, pos, direction.d());
        }
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(d, rotation.a().a(state.c(d)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return (IBlockData)state.b(d, mirror.a().a(state.c(d)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(d, c, b);
    }
}

