/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = MinecraftKey.b("sherds");
    public static final BlockStateEnum<EnumDirection> c = BlockProperties.T;
    public static final BlockStateBoolean d = BlockProperties.bB;
    public static final BlockStateBoolean e = BlockProperties.I;
    private static final VoxelShape f = Block.b(14.0, 0.0, 16.0);

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(c, EnumDirection.c)).b(e, false)).b(d, false));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, context.g())).b(e, fluidState.a() == FluidTypes.c)).b(d, false);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            if (level.B_()) {
                return EnumInteractionResult.a;
            }
            ItemStack theItem = decoratedPotBlockEntity.g();
            if (!stack.f() && (theItem.f() || ItemStack.c(theItem, stack) && theItem.N() < theItem.k())) {
                float f2;
                decoratedPotBlockEntity.a(DecoratedPotBlockEntity.a.a);
                player.b(StatisticList.c.b(stack.h()));
                ItemStack itemStack = stack.b(1, (EntityLiving)player);
                if (decoratedPotBlockEntity.c()) {
                    decoratedPotBlockEntity.b(itemStack);
                    f2 = (float)itemStack.N() / (float)itemStack.k();
                } else {
                    theItem.g(1);
                    f2 = (float)theItem.N() / (float)theItem.k();
                }
                level.a(null, pos, SoundEffects.hX, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (level instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)level;
                    serverLevel.a(Particles.bb, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedPotBlockEntity.e();
                level.a((Entity)player, GameEvent.c, pos);
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            level.a(null, pos, SoundEffects.hY, SoundCategory.e, 1.0f, 1.0f);
            decoratedPotBlockEntity.a(DecoratedPotBlockEntity.a.b);
            level.a((Entity)player, GameEvent.c, pos);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return f;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, e, d);
    }

    @Override
    public @Nullable TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        TileEntity blockEntity = params.b(LootContextParameters.j);
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)blockEntity;
            params.a(b, (Consumer<ItemStack> output) -> {
                for (Item item : decoratedPotBlockEntity.m().a()) {
                    output.accept(item.m());
                }
            });
        }
        return super.a(state, params);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        ItemStack mainHandItem = player.fx();
        IBlockData blockState = state;
        if (mainHandItem.a(TagsItem.cg) && !EnchantmentManager.a(mainHandItem, EnchantmentTags.r)) {
            blockState = (IBlockData)state.b(d, true);
            level.a(pos, blockState, 260);
        }
        return super.a(level, pos, blockState, player);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected SoundEffectType h_(IBlockData state) {
        return state.c(d) != false ? SoundEffectType.bg : SoundEffectType.bf;
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        WorldServer serverLevel;
        BlockPosition blockPos = hit.b();
        if (level instanceof WorldServer && projectile.c(serverLevel = (WorldServer)level, blockPos) && projectile.a(serverLevel)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, this.b_(state).g())) {
                return;
            }
            level.a(blockPos, (IBlockData)state.b(d, true), 260);
            level.a(blockPos, true, projectile);
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            PotDecorations decorations = decoratedPotBlockEntity.m();
            return DecoratedPotBlockEntity.a(decorations);
        }
        return super.a(level, pos, state, includeData);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return Container.a(level.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(c, rotation.a(state.c(c)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }
}

