/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class DriedGhastBlock
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<DriedGhastBlock> a = DriedGhastBlock.b(DriedGhastBlock::new);
    public static final int b = 3;
    public static final BlockStateInteger c = BlockProperties.be;
    public static final BlockStateBoolean d = BlockProperties.I;
    public static final int e = 5000;
    private static final VoxelShape g = Block.a(10.0, 10.0, 0.0, 10.0);

    public MapCodec<DriedGhastBlock> a() {
        return a;
    }

    public DriedGhastBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(BlockFacingHorizontal.f, EnumDirection.c)).b(c, 0)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.f, c, d);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return g;
    }

    public int n(IBlockData state) {
        return state.c(c);
    }

    private boolean p(IBlockData state) {
        return this.n(state) == 3;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(d).booleanValue()) {
            this.c(state, level, pos, random);
        } else {
            int hydrationLevel = this.n(state);
            if (hydrationLevel > 0) {
                level.a(pos, (IBlockData)state.b(c, hydrationLevel - 1), 2);
                level.a(GameEvent.c, pos, GameEvent.a.a(state));
            }
        }
    }

    private void c(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!this.p(state)) {
            if (!CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(c, this.n(state) + 1), 2)) {
                return;
            }
            level.a(null, pos, SoundEffects.iS, SoundCategory.e, 1.0f, 1.0f);
            level.a(GameEvent.c, pos, GameEvent.a.a(state));
        } else {
            if (CraftEventFactory.callBlockFadeEvent(level, pos, state.y().g()).isCancelled()) {
                return;
            }
            this.a(level, pos, state);
        }
    }

    private void a(WorldServer level, BlockPosition pos, IBlockData state) {
        level.a(pos, false);
        HappyGhast happyGhast = EntityTypes.ai.a(level, EntitySpawnReason.e);
        if (happyGhast != null) {
            Vec3D bottomCenter = pos.c();
            happyGhast.a_(true);
            float yRot = EnumDirection.a(state.c(BlockFacingHorizontal.f));
            happyGhast.r(yRot);
            happyGhast.b(bottomCenter.a(), bottomCenter.b(), bottomCenter.c(), yRot, 0.0f);
            level.addFreshEntity(happyGhast, CreatureSpawnEvent.SpawnReason.REHYDRATION);
            level.a(null, happyGhast, SoundEffects.mh, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        double d2 = (double)pos.u() + 0.5;
        double d1 = (double)pos.v() + 0.5;
        double d22 = (double)pos.w() + 0.5;
        if (!state.c(d).booleanValue()) {
            if (random.a(40) == 0 && level.a_(pos.e()).a(TagsBlock.cU)) {
                level.a(d2, d1, d22, SoundEffects.iO, SoundCategory.e, 1.0f, 1.0f, false);
            }
            if (random.a(6) == 0) {
                level.a(Particles.aj, d2, d1, d22, 0.0, 0.02, 0.0);
            }
        } else {
            if (random.a(40) == 0) {
                level.a(d2, d1, d22, SoundEffects.iP, SoundCategory.e, 1.0f, 1.0f, false);
            }
            if (random.a(6) == 0) {
                level.a(Particles.R, d2 + (double)((random.i() * 2.0f - 1.0f) / 3.0f), d1 + 0.4, d22 + (double)((random.i() * 2.0f - 1.0f) / 3.0f), 0.0, (double)random.i(), 0.0);
            }
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if ((state.c(d).booleanValue() || state.c(c) > 0) && !level.q().a(pos, this)) {
            level.a(pos, (Block)this, 5000);
        }
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        boolean flag = fluidState.a() == FluidTypes.c;
        return (IBlockData)((IBlockData)super.a(context).b(d, flag)).b(BlockFacingHorizontal.f, context.g().g());
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    public boolean a(GeneratorAccess level, BlockPosition pos, IBlockData state, Fluid fluidState) {
        if (!state.c(BlockProperties.I).booleanValue() && fluidState.a() == FluidTypes.c) {
            if (!level.B_()) {
                level.a(pos, (IBlockData)state.b(BlockProperties.I, true), 3);
                level.a(pos, fluidState.a(), fluidState.a().a(level));
                level.a(null, pos, SoundEffects.iR, SoundCategory.e, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        super.a(level, pos, state, placer, stack);
        level.a(null, pos, state.c(d) != false ? SoundEffects.iR : SoundEffects.iQ, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    public boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

