/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.InsideBlockEffectType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeBase.Precipitation.d.fieldOf("precipitation").forGetter(layeredCauldronBlock -> layeredCauldronBlock.R), (App)CauldronInteraction.b.fieldOf("interactions").forGetter(layeredCauldronBlock -> layeredCauldronBlock.c), LayeredCauldronBlock.x()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int e = 1;
    public static final int f = 3;
    public static final BlockStateInteger g = BlockProperties.aO;
    private static final int h = 6;
    private static final double i = 3.0;
    private static final VoxelShape[] D = SystemUtils.a(() -> Block.a(2, (int i2) -> VoxelShapes.a(AbstractCauldronBlock.b, Block.b(12.0, 4.0, LayeredCauldronBlock.b(i2 + 1)))));
    private final BiomeBase.Precipitation R;

    public MapCodec<LayeredCauldronBlock> a() {
        return d;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation precipitationType, CauldronInteraction.a interactions, BlockBase.Info properties) {
        super(properties, interactions);
        this.R = precipitationType;
        this.l((IBlockData)this.C.b().b(g, 1));
    }

    @Override
    public boolean d(IBlockData state) {
        return state.c(g) == 3;
    }

    @Override
    protected boolean a(FluidType fluid) {
        return fluid == FluidTypes.c && this.R == BiomeBase.Precipitation.b;
    }

    @Override
    protected double b(IBlockData state) {
        return LayeredCauldronBlock.b(state.c(g)) / 16.0;
    }

    private static double b(int level) {
        return 6.0 + (double)level * 3.0;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return D[state.c(g) - 1];
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = pos.j();
            effectApplier.a(InsideBlockEffectType.e, (net.minecraft.world.entity.Entity entity1) -> {
                if (entity1.cp() && (entity instanceof EntityHuman || serverLevel.U().a(GameRules.F).booleanValue()) && entity1.c(serverLevel, blockPos) && this.handleEntityOnFireInside(state, level, blockPos, (net.minecraft.world.entity.Entity)entity1)) {
                    InsideBlockEffectType.e.effect().affect((net.minecraft.world.entity.Entity)entity1, blockPos);
                }
            });
        }
    }

    private boolean handleEntityOnFireInside(IBlockData state, World level, BlockPosition pos, @Nullable net.minecraft.world.entity.Entity entity) {
        if (this.R == BiomeBase.Precipitation.c) {
            return LayeredCauldronBlock.lowerFillLevel((IBlockData)Blocks.gj.m().b(g, state.c(g)), level, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
        }
        return LayeredCauldronBlock.lowerFillLevel(state, level, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
    }

    public static void c(IBlockData state, World level, BlockPosition pos) {
        LayeredCauldronBlock.lowerFillLevel(state, level, pos, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData state, World level, BlockPosition pos, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = state.c(g) - 1;
        IBlockData blockState = i2 == 0 ? Blocks.gi.m() : (IBlockData)state.b(g, i2);
        return LayeredCauldronBlock.changeLevel(level, pos, blockState, entity, reason);
    }

    public static boolean changeLevel(World level, BlockPosition pos, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        return LayeredCauldronBlock.changeLevel(level, pos, newBlock, entity, reason, true);
    }

    public static boolean changeLevel(World level, BlockPosition pos, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason, boolean sendGameEvent) {
        CraftBlockState newState = CraftBlockStates.getBlockState(level, pos);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        if (!event.callEvent()) {
            return false;
        }
        newState.place(3);
        if (sendGameEvent) {
            level.a(GameEvent.c, pos, GameEvent.a.a(newBlock));
        }
        return true;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, BiomeBase.Precipitation precipitation) {
        if (BlockCauldron.a(level, precipitation) && state.c(g) != 3 && precipitation == this.R) {
            IBlockData blockState = (IBlockData)state.a(g);
            LayeredCauldronBlock.changeLevel(level, pos, blockState, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        return state.c(g);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{g});
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, FluidType fluid) {
        if (!this.d(state)) {
            IBlockData blockState = (IBlockData)state.b(g, state.c(g) + 1);
            if (!LayeredCauldronBlock.changeLevel(level, pos, blockState, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            level.c(1047, pos, 0);
        }
    }
}

