/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.Nullable;

public class PitcherCropBlock
extends BlockTallPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<PitcherCropBlock> c = PitcherCropBlock.b(PitcherCropBlock::new);
    public static final int d = 4;
    public static final BlockStateInteger e = BlockProperties.ax;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> f = BlockTallPlant.b;
    private static final int g = 3;
    private static final int h = 1;
    private static final VoxelShape i = Block.b(6.0, -1.0, 3.0);
    private static final VoxelShape D = Block.b(10.0, -1.0, 5.0);
    private final Function<IBlockData, VoxelShape> R = this.b();

    public MapCodec<PitcherCropBlock> a() {
        return c;
    }

    public PitcherCropBlock(BlockBase.Info properties) {
        super(properties);
    }

    private Function<IBlockData, VoxelShape> b() {
        int[] ints = new int[]{0, 9, 11, 22, 26};
        return this.a((IBlockData blockState) -> {
            int i2 = (blockState.c(e) == 0 ? 4 : 6) + ints[blockState.c(e)];
            int i1 = blockState.c(e) == 0 ? 6 : 10;
            return switch (blockState.c(f)) {
                default -> throw new MatchException(null, null);
                case BlockPropertyDoubleBlockHalf.b -> Block.b(i1, -1.0, Math.min(16, -1 + i2));
                case BlockPropertyDoubleBlockHalf.a -> Block.b(i1, 0.0, Math.max(0, -1 + i2 - 16));
            };
        });
    }

    @Override
    public @Nullable IBlockData a(BlockActionContext context) {
        return this.m();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.R.apply(state);
    }

    @Override
    public VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(f) == BlockPropertyDoubleBlockHalf.b) {
            return state.c(e) == 0 ? i : D;
        }
        return VoxelShapes.a();
    }

    @Override
    public IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (PitcherCropBlock.b(state.c(e))) {
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return state.a(level, pos) ? state : Blocks.a.m();
    }

    @Override
    public boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return (!PitcherCropBlock.p(state) || PitcherCropBlock.b(level, pos)) && super.a(state, level, pos);
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(Blocks.cZ);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{e});
        super.a(builder);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, boolean pastEdges) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (entity instanceof EntityRavager && serverLevel.U().a(GameRules.F).booleanValue()) {
                serverLevel.a(pos, true, entity);
            }
        }
    }

    @Override
    public boolean a(IBlockData state, BlockActionContext useContext) {
        return false;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
    }

    @Override
    public boolean f(IBlockData state) {
        return state.c(f) == BlockPropertyDoubleBlockHalf.b && !this.r(state);
    }

    @Override
    public void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        boolean flag;
        float growthSpeed = BlockCrops.a(this, level, pos);
        boolean bl = flag = (double)random.i() < (double)level.spigotConfig.pitcherPlantModifier / (100.0 * (Math.floor(25.0f / growthSpeed) + 1.0));
        if (flag) {
            this.a(level, state, pos, 1);
        }
    }

    private void a(WorldServer level, IBlockData state, BlockPosition pos, int ageIncrement) {
        int min = Math.min(state.c(e) + ageIncrement, 4);
        if (this.a((IWorldReader)level, pos, state, min)) {
            IBlockData blockState = (IBlockData)state.b(e, min);
            if (!CraftEventFactory.handleBlockGrowEvent(level, pos, blockState, 2)) {
                return;
            }
            if (PitcherCropBlock.b(min)) {
                level.a(pos.d(), (IBlockData)blockState.b(f, BlockPropertyDoubleBlockHalf.a), 3);
            }
        }
    }

    private static boolean a(IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return blockState.l() || blockState.a(Blocks.lx);
    }

    private static boolean b(IWorldReader level, BlockPosition pos) {
        return BlockCrops.a(level, pos);
    }

    private static boolean p(IBlockData state) {
        return state.a(Blocks.lx) && state.c(f) == BlockPropertyDoubleBlockHalf.b;
    }

    private static boolean b(int age) {
        return age >= 3;
    }

    private boolean a(IWorldReader level, BlockPosition pos, IBlockData state, int age) {
        return !this.r(state) && PitcherCropBlock.b(level, pos) && (!PitcherCropBlock.b(age) || PitcherCropBlock.a(level, pos.d()));
    }

    private boolean r(IBlockData state) {
        return state.c(e) >= 4;
    }

    private @Nullable a c(IWorldReader level, BlockPosition pos, IBlockData state) {
        if (PitcherCropBlock.p(state)) {
            return new a(pos, state);
        }
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return PitcherCropBlock.p(blockState) ? new a(blockPos, blockState) : null;
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        a lowerHalf = this.c(level, pos, state);
        return lowerHalf != null && this.a(level, lowerHalf.a, lowerHalf.b, lowerHalf.b.c(e) + 1);
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        a lowerHalf = this.c(level, pos, state);
        if (lowerHalf != null) {
            this.a(level, lowerHalf.b, lowerHalf.a, 1);
        }
    }

    record a(BlockPosition a, IBlockData b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this, o2);
        }
    }
}

