/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceSpreadeableBlock
implements SculkBehaviour {
    public static final MapCodec<SculkVeinBlock> e = SculkVeinBlock.b(SculkVeinBlock::new);
    private final MultifaceSpreader f = new MultifaceSpreader(new a(this, MultifaceSpreader.a));
    private final MultifaceSpreader g = new MultifaceSpreader(new a(this, MultifaceSpreader.e.a));

    public MapCodec<SculkVeinBlock> a() {
        return e;
    }

    public SculkVeinBlock(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public MultifaceSpreader c() {
        return this.f;
    }

    public MultifaceSpreader q() {
        return this.g;
    }

    public static boolean a(GeneratorAccess level, BlockPosition pos, IBlockData state, Collection<EnumDirection> directions) {
        boolean flag = false;
        IBlockData blockState = Blocks.rT.m();
        for (EnumDirection direction : directions) {
            if (!SculkVeinBlock.a((IBlockAccess)level, pos, direction)) continue;
            blockState = (IBlockData)blockState.b(SculkVeinBlock.b(direction), true);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!state.y().c()) {
            blockState = (IBlockData)blockState.b(MultifaceBlock.c, true);
        }
        level.a(pos, blockState, 3);
        return true;
    }

    @Override
    public void a(GeneratorAccess level, IBlockData state, BlockPosition pos, RandomSource random) {
        if (state.a(this)) {
            for (EnumDirection direction : MultifaceBlock.d) {
                BlockStateBoolean faceProperty = SculkVeinBlock.b(direction);
                if (!state.c(faceProperty).booleanValue() || !level.a_(pos.a(direction)).a(Blocks.rS)) continue;
                state = (IBlockData)state.b(faceProperty, false);
            }
            if (!SculkVeinBlock.r(state)) {
                Fluid fluidState = level.b_(pos);
                state = (fluidState.c() ? Blocks.a : Blocks.J).m();
            }
            level.a(pos, state, 3);
            SculkBehaviour.super.a(level, state, pos, random);
        }
    }

    @Override
    public int a(SculkSpreader.a cursor, GeneratorAccess level, BlockPosition pos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
        if (shouldConvertBlocks && this.attemptPlaceSculk(spreader, level, cursor.a(), random, pos)) {
            return cursor.b() - 1;
        }
        return random.a(spreader.f()) == 0 ? MathHelper.b((float)cursor.b() * 0.5f) : cursor.b();
    }

    private boolean attemptPlaceSculk(SculkSpreader spreader, GeneratorAccess level, BlockPosition pos, RandomSource random, BlockPosition sourceBlock) {
        IBlockData blockState = level.a_(pos);
        TagKey<Block> tagKey = spreader.c();
        for (EnumDirection direction : EnumDirection.a(random)) {
            BlockPosition blockPos;
            IBlockData blockState1;
            if (!SculkVeinBlock.a(blockState, direction) || !(blockState1 = level.a_(blockPos = pos.a(direction))).a(tagKey)) continue;
            IBlockData blockState2 = Blocks.rS.m();
            if (!CraftEventFactory.handleBlockSpreadEvent(level, sourceBlock, blockPos, blockState2, 3)) {
                return false;
            }
            Block.a(blockState1, blockState2, level, blockPos);
            level.a(null, blockPos, SoundEffects.yO, SoundCategory.e, 1.0f, 1.0f);
            this.f.a(blockState2, level, blockPos, spreader.h());
            EnumDirection opposite = direction.g();
            for (EnumDirection direction1 : MultifaceBlock.d) {
                BlockPosition blockPos1;
                IBlockData blockState3;
                if (direction1 == opposite || !(blockState3 = level.a_(blockPos1 = blockPos.a(direction1))).a(this)) continue;
                this.a(level, blockState3, blockPos1, random);
            }
            return true;
        }
        return false;
    }

    public static boolean a(GeneratorAccess level, IBlockData state, BlockPosition pos) {
        if (!state.a(Blocks.rT)) {
            return false;
        }
        for (EnumDirection direction : MultifaceBlock.d) {
            if (!SculkVeinBlock.a(state, direction) || !level.a_(pos.a(direction)).a(TagsBlock.ch)) continue;
            return true;
        }
        return false;
    }

    class a
    extends MultifaceSpreader.a {
        private final MultifaceSpreader.e[] b;

        public a(SculkVeinBlock this$0, MultifaceSpreader.e ... spreadTypes) {
            super(this$0);
            this.b = spreadTypes;
        }

        @Override
        public boolean a(IBlockAccess level, BlockPosition pos, BlockPosition spreadPos, EnumDirection direction, IBlockData state) {
            IBlockData blockState = level.a_(spreadPos.a(direction));
            if (!(blockState.a(Blocks.rS) || blockState.a(Blocks.rU) || blockState.a(Blocks.ca))) {
                BlockPosition blockPos;
                if (pos.k(spreadPos) == 2 && level.a_(blockPos = pos.a(direction.g())).c(level, blockPos, direction)) {
                    return false;
                }
                Fluid fluidState = state.y();
                return !(!fluidState.c() && !fluidState.b(FluidTypes.c) || state.a(TagsBlock.aY) || !state.v() && !super.a(level, pos, spreadPos, direction, state));
            }
            return false;
        }

        @Override
        public MultifaceSpreader.e[] a() {
            return this.b;
        }

        @Override
        public boolean a(IBlockData otherBlock) {
            return !otherBlock.a(Blocks.rT);
        }
    }
}

