/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.SideChainPartBlock;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.SideChainPart;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class ShelfBlock
extends BlockTileEntity
implements SelectableSlotContainer,
SideChainPartBlock,
IBlockWaterlogged {
    public static final MapCodec<ShelfBlock> a = ShelfBlock.b(ShelfBlock::new);
    public static final BlockStateBoolean b = BlockProperties.A;
    public static final BlockStateEnum<EnumDirection> c = BlockProperties.T;
    public static final BlockStateEnum<SideChainPart> d = BlockProperties.aj;
    public static final BlockStateBoolean e = BlockProperties.I;
    private static final Map<EnumDirection, VoxelShape> f = VoxelShapes.c(VoxelShapes.a(Block.a(0.0, 12.0, 11.0, 16.0, 16.0, 13.0), Block.a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), Block.a(0.0, 0.0, 11.0, 16.0, 4.0, 13.0)));

    public MapCodec<ShelfBlock> a() {
        return a;
    }

    public ShelfBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(c, EnumDirection.c)).b(b, false)).b(d, SideChainPart.a)).b(e, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return f.get(state.c(c));
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return pathComputationType == PathMode.b && state.y().a(TagsFluid.a);
    }

    @Override
    public @Nullable TileEntity a(BlockPosition pos, IBlockData state) {
        return new ShelfBlockEntity(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(c, b, d, e);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
        this.a_(level, pos, state);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.B_()) {
            boolean hasNeighborSignal = level.I(pos);
            if (state.c(b) != hasNeighborSignal) {
                if (!CraftEventFactory.callBinaryRedstoneChange(level, pos, hasNeighborSignal)) {
                    return;
                }
                IBlockData blockState = (IBlockData)state.b(b, hasNeighborSignal);
                if (!hasNeighborSignal) {
                    blockState = (IBlockData)blockState.b(d, SideChainPart.a);
                }
                level.a(pos, blockState, 3);
                this.a((GeneratorAccess)level, pos, hasNeighborSignal ? SoundEffects.zz : SoundEffects.zB);
                level.a(hasNeighborSignal ? GameEvent.a : GameEvent.e, pos, GameEvent.a.a(blockState));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, context.g().g())).b(b, context.q().I(context.a()))).b(e, fluidState.a() == FluidTypes.c);
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(c, rotation.a(state.c(c)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(c)));
    }

    @Override
    public int b() {
        return 1;
    }

    @Override
    public int c() {
        return 3;
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)tileEntity;
            if (!hand.equals((Object)EnumHand.b)) {
                OptionalInt hitSlot = this.a(hitResult, state.c(c));
                if (hitSlot.isEmpty()) {
                    return EnumInteractionResult.e;
                }
                PlayerInventory inventory = player.gK();
                if (level.B_()) {
                    return (EnumInteractionResult)((Object)(inventory.h().f() ? EnumInteractionResult.e : EnumInteractionResult.a));
                }
                if (!state.c(b).booleanValue()) {
                    boolean flag = ShelfBlock.a(stack, player, shelfBlockEntity, hitSlot.getAsInt(), inventory);
                    if (flag) {
                        this.a((GeneratorAccess)level, pos, stack.f() ? SoundEffects.zJ : SoundEffects.zH);
                    } else {
                        if (stack.f()) {
                            return EnumInteractionResult.e;
                        }
                        this.a((GeneratorAccess)level, pos, SoundEffects.zG);
                    }
                    return EnumInteractionResult.a.a(stack);
                }
                ItemStack selectedItem = inventory.h();
                boolean flag1 = this.a(level, pos, inventory);
                if (!flag1) {
                    return EnumInteractionResult.c;
                }
                this.a((GeneratorAccess)level, pos, SoundEffects.zE);
                return selectedItem == inventory.h() ? EnumInteractionResult.a : EnumInteractionResult.a.a(inventory.h());
            }
        }
        return EnumInteractionResult.e;
    }

    private static boolean a(ItemStack stack, EntityHuman player, ShelfBlockEntity blockEntity, int slot, PlayerInventory inventory) {
        ItemStack itemStack = blockEntity.d(slot, stack);
        ItemStack itemStack1 = player.gv() && itemStack.f() ? stack.v() : itemStack;
        inventory.a(inventory.g(), itemStack1);
        inventory.e();
        blockEntity.a((Holder.c<GameEvent>)(itemStack1.c(DataComponents.g) && !itemStack1.a(DataComponents.g).b() ? null : GameEvent.C));
        return !itemStack.f();
    }

    private boolean a(World level, BlockPosition pos, PlayerInventory inventory) {
        List<BlockPosition> allBlocksConnectedTo = this.a(level, pos);
        if (allBlocksConnectedTo.isEmpty()) {
            return false;
        }
        boolean flag = false;
        for (int i2 = 0; i2 < allBlocksConnectedTo.size(); ++i2) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)level.c_(allBlocksConnectedTo.get(i2));
            if (shelfBlockEntity == null) continue;
            for (int i1 = 0; i1 < shelfBlockEntity.b(); ++i1) {
                int i22 = 9 - (allBlocksConnectedTo.size() - i2) * shelfBlockEntity.b() + i1;
                if (i22 < 0 || i22 > inventory.b()) continue;
                ItemStack itemStack = inventory.b(i22);
                ItemStack itemStack1 = shelfBlockEntity.d(i1, itemStack);
                if (itemStack.f() && itemStack1.f()) continue;
                inventory.a(i22, itemStack1);
                flag = true;
            }
            inventory.e();
            shelfBlockEntity.a(GameEvent.r);
        }
        return flag;
    }

    @Override
    public SideChainPart p(IBlockData state) {
        return state.c(d);
    }

    @Override
    public IBlockData a(IBlockData state, SideChainPart chainPart) {
        return (IBlockData)state.b(d, chainPart);
    }

    @Override
    public EnumDirection r(IBlockData state) {
        return state.c(c);
    }

    @Override
    public boolean s(IBlockData state) {
        return state.a(TagsBlock.n) && state.b(b) && state.c(b) != false;
    }

    @Override
    public int d() {
        return 3;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (state.c(b).booleanValue()) {
            this.a((GeneratorAccess)level, pos, state, oldState);
        } else {
            this.a_(level, pos, state);
        }
    }

    private void a(GeneratorAccess level, BlockPosition pos, SoundEffect sound) {
        level.a(null, pos, sound, SoundCategory.e, 1.0f, 1.0f);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos, EnumDirection direction) {
        if (level.B_()) {
            return 0;
        }
        if (direction != state.c(c).g()) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)tileEntity;
            int i2 = shelfBlockEntity.a(0).f() ? 0 : 1;
            int i1 = shelfBlockEntity.a(1).f() ? 0 : 1;
            int i22 = shelfBlockEntity.a(2).f() ? 0 : 1;
            return i2 | i1 << 1 | i22 << 2;
        }
        return 0;
    }
}

