/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.SideChainPart;

public interface SideChainPartBlock {
    public SideChainPart p(IBlockData var1);

    public IBlockData a(IBlockData var1, SideChainPart var2);

    public EnumDirection r(IBlockData var1);

    public boolean s(IBlockData var1);

    public int d();

    default public List<BlockPosition> a(GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        if (!this.s(blockState)) {
            return List.of();
        }
        c neighbors = this.a(level, pos, this.r(blockState));
        LinkedList<BlockPosition> list = new LinkedList<BlockPosition>();
        list.add(pos);
        this.a(neighbors::a, SideChainPart.d, list::addFirst);
        this.a(neighbors::b, SideChainPart.b, list::addLast);
        return list;
    }

    private void a(IntFunction<b> neighborGetter, SideChainPart chainPart, Consumer<BlockPosition> output) {
        for (int i2 = 1; i2 < this.d(); ++i2) {
            b neighbor = neighborGetter.apply(i2);
            if (neighbor.a(chainPart)) {
                output.accept(neighbor.c());
            }
            if (neighbor.b()) break;
        }
    }

    default public void a_(GeneratorAccess level, BlockPosition pos, IBlockData state) {
        c neighbors = this.a(level, pos, this.r(state));
        neighbors.a().f();
        neighbors.b().g();
    }

    default public void a(GeneratorAccess level, BlockPosition pos, IBlockData state, IBlockData oldState) {
        if (this.s(state) && !this.a(state, oldState)) {
            c neighbors = this.a(level, pos, this.r(state));
            SideChainPart sideChainPart = SideChainPart.a;
            int i2 = neighbors.a().a() ? this.a(level, neighbors.a().c()).size() : 0;
            int i1 = neighbors.b().a() ? this.a(level, neighbors.b().c()).size() : 0;
            int i22 = 1;
            if (this.a(i2, i22)) {
                sideChainPart = sideChainPart.e();
                neighbors.a().d();
                i22 += i2;
            }
            if (this.a(i1, i22)) {
                sideChainPart = sideChainPart.d();
                neighbors.b().e();
            }
            this.a(level, pos, sideChainPart);
        }
    }

    private boolean a(int segmentLength, int currentChainLength) {
        return segmentLength > 0 && currentChainLength + segmentLength <= this.d();
    }

    private boolean a(IBlockData state, IBlockData oldState) {
        boolean isConnected = this.p(state).a();
        boolean flag = this.s(oldState) && this.p(oldState).a();
        return isConnected || flag;
    }

    private c a(GeneratorAccess level, BlockPosition center, EnumDirection facing) {
        return new c(this, level, facing, center, new HashMap<BlockPosition, b>());
    }

    default public void a(GeneratorAccess level, BlockPosition pos, SideChainPart chainPart) {
        IBlockData blockState = level.a_(pos);
        if (this.p(blockState) != chainPart) {
            level.a(pos, this.a(blockState, chainPart), 3);
        }
    }

    public record c(SideChainPartBlock a, GeneratorAccess b, EnumDirection c, BlockPosition d, Map<BlockPosition, b> e) {
        private final SideChainPartBlock a;
        private final GeneratorAccess b;
        private final EnumDirection c;
        private final BlockPosition d;
        private final Map<BlockPosition, b> e;

        private boolean a(IBlockData state) {
            return this.a.s(state) && this.a.r(state) == this.c;
        }

        private b a(BlockPosition pos) {
            IBlockData blockState = this.b.a_(pos);
            SideChainPart sideChainPart = this.a(blockState) ? this.a.p(blockState) : null;
            return (b)((Object)(sideChainPart == null ? new a(pos) : new d(this.b, this.a, pos, sideChainPart)));
        }

        private b a(EnumDirection direction, Integer distance) {
            return this.e.computeIfAbsent(this.d.a(direction, (int)distance), this::a);
        }

        public b a(int distance) {
            return this.a(this.c.h(), distance);
        }

        public b b(int distance) {
            return this.a(this.c.i(), distance);
        }

        public b a() {
            return this.a(1);
        }

        public b b() {
            return this.b(1);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "block;level;facing;center;cache", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "block;level;facing;center;cache", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "block;level;facing;center;cache", "a", "b", "c", "d", "e"}, this, o2);
        }

        public SideChainPartBlock c() {
            return this.a;
        }

        public GeneratorAccess d() {
            return this.b;
        }

        public EnumDirection e() {
            return this.c;
        }

        public BlockPosition f() {
            return this.d;
        }

        public Map<BlockPosition, b> g() {
            return this.e;
        }
    }

    public static sealed interface b
    permits a, d {
        public BlockPosition c();

        public boolean a();

        public boolean b();

        public boolean a(SideChainPart var1);

        default public void d() {
        }

        default public void e() {
        }

        default public void f() {
        }

        default public void g() {
        }
    }

    public record d(GeneratorAccess a, SideChainPartBlock b, BlockPosition c, SideChainPart d) implements b
    {
        private final GeneratorAccess a;
        private final SideChainPartBlock b;
        private final SideChainPart d;

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean b() {
            return this.d.b();
        }

        @Override
        public boolean a(SideChainPart chainPart) {
            return this.d.a(chainPart);
        }

        @Override
        public void d() {
            this.b.a(this.a, this.c, this.d.d());
        }

        @Override
        public void e() {
            this.b.a(this.a, this.c, this.d.e());
        }

        @Override
        public void f() {
            this.b.a(this.a, this.c, this.d.f());
        }

        @Override
        public void g() {
            this.b.a(this.a, this.c, this.d.g());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "level;block;pos;part", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "level;block;pos;part", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "level;block;pos;part", "a", "b", "c", "d"}, this, o2);
        }

        public GeneratorAccess h() {
            return this.a;
        }

        public SideChainPartBlock i() {
            return this.b;
        }

        public SideChainPart j() {
            return this.d;
        }
    }

    public record a(BlockPosition a) implements b
    {
        private final BlockPosition a;

        @Override
        public boolean a() {
            return false;
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public boolean a(SideChainPart chainPart) {
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos", "a"}, this, o2);
        }

        @Override
        public BlockPosition c() {
            return this.a;
        }
    }
}

