/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jspecify.annotations.Nullable;

public class TestBlock
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<TestBlock> a = TestBlock.b(TestBlock::new);
    public static final BlockStateEnum<TestBlockMode> b = BlockProperties.bH;

    public TestBlock(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    public @Nullable TileEntity a(BlockPosition pos, IBlockData state) {
        return new TestBlockEntity(pos, state);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        TestBlockMode testBlockMode;
        BlockItemStateProperties blockItemStateProperties = context.n().a(DataComponents.ax);
        IBlockData blockState = this.m();
        if (blockItemStateProperties != null && (testBlockMode = blockItemStateProperties.a(b)) != null) {
            blockState = (IBlockData)blockState.b(b, testBlockMode);
        }
        return blockState;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TestBlockEntity) {
            TestBlockEntity testBlockEntity = (TestBlockEntity)tileEntity;
            if (!player.hi()) {
                return EnumInteractionResult.e;
            }
            if (level.B_()) {
                player.a(testBlockEntity);
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        TestBlockEntity serverTestBlockEntity = TestBlock.a(level, pos);
        if (serverTestBlockEntity != null) {
            serverTestBlockEntity.f();
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        TestBlockEntity serverTestBlockEntity = TestBlock.a(level, pos);
        if (serverTestBlockEntity != null && serverTestBlockEntity.d() != TestBlockMode.a) {
            boolean hasNeighborSignal = level.I(pos);
            boolean isPowered = serverTestBlockEntity.c();
            if (hasNeighborSignal && !isPowered) {
                serverTestBlockEntity.a(true);
                serverTestBlockEntity.h();
            } else if (!hasNeighborSignal && isPowered) {
                serverTestBlockEntity.a(false);
            }
        }
    }

    private static @Nullable TestBlockEntity a(World level, BlockPosition pos) {
        TestBlockEntity testBlockEntity;
        WorldServer serverLevel;
        TileEntity tileEntity;
        return level instanceof WorldServer && (tileEntity = (serverLevel = (WorldServer)level).c_(pos)) instanceof TestBlockEntity ? (testBlockEntity = (TestBlockEntity)tileEntity) : null;
    }

    @Override
    public int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        if (state.c(b) != TestBlockMode.a) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TestBlockEntity) {
            TestBlockEntity testBlockEntity = (TestBlockEntity)tileEntity;
            return testBlockEntity.c() ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        ItemStack itemStack = super.a(level, pos, state, includeData);
        return TestBlock.a(itemStack, state.c(b));
    }

    public static ItemStack a(ItemStack stack, TestBlockMode mode) {
        stack.b(DataComponents.ax, stack.a(DataComponents.ax, BlockItemStateProperties.a).a(b, mode));
        return stack;
    }

    protected MapCodec<TestBlock> a() {
        return a;
    }
}

