/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;

public class CreakingHeartBlockEntity
extends TileEntity {
    private static final int b = 32;
    public static final int a = 32;
    private static final int c = 34;
    private static final int d = 16;
    private static final int e = 8;
    private static final int f = 5;
    private static final int g = 20;
    private static final int h = 5;
    private static final int i = 100;
    private static final int j = 10;
    private static final int k = 10;
    private static final int l = 50;
    private static final int m = 2;
    private static final int q = 64;
    private static final int r = 30;
    private static final Optional<Creaking> s = Optional.empty();
    private @Nullable Either<Creaking, UUID> t;
    private long u;
    private int v;
    private int w;
    private @Nullable Vec3D x;
    private int y;

    public CreakingHeartBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.k, pos, blockState);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, CreakingHeartBlockEntity creakingHeart) {
        ++creakingHeart.u;
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            int i2 = creakingHeart.f();
            if (creakingHeart.y != i2) {
                creakingHeart.y = i2;
                level.b(pos, Blocks.cQ);
            }
            if (creakingHeart.w > 0) {
                if (creakingHeart.w > 50) {
                    creakingHeart.a(serverLevel, 1, true);
                    creakingHeart.a(serverLevel, 1, false);
                }
                if (creakingHeart.w % 10 == 0 && creakingHeart.x != null) {
                    creakingHeart.l().ifPresent(creaking1 -> {
                        creakingHeart.x = creaking1.dj().f();
                    });
                    Vec3D vec3 = Vec3D.b(pos);
                    float f2 = 0.2f + 0.8f * (float)(100 - creakingHeart.w) / 100.0f;
                    Vec3D vec31 = vec3.d(creakingHeart.x).c((double)f2).e(creakingHeart.x);
                    BlockPosition blockPos = BlockPosition.a(vec31);
                    float f1 = (float)creakingHeart.w / 2.0f / 100.0f + 0.5f;
                    serverLevel.a(null, blockPos, SoundEffects.hB, SoundCategory.e, f1, 1.0f);
                }
                --creakingHeart.w;
            }
            if (creakingHeart.v-- < 0) {
                creakingHeart.v = creakingHeart.n == null ? 20 : creakingHeart.n.y.a(5) + 20;
                IBlockData blockState = CreakingHeartBlockEntity.a(level, state, pos, creakingHeart);
                if (blockState != state) {
                    level.a(pos, blockState, 3);
                    if (blockState.c(CreakingHeartBlock.c) == CreakingHeartState.a) {
                        return;
                    }
                }
                if (creakingHeart.t == null) {
                    EntityHuman nearestPlayer;
                    if (blockState.c(CreakingHeartBlock.c) == CreakingHeartState.c && serverLevel.O() && (nearestPlayer = level.a((double)pos.u(), (double)pos.v(), (double)pos.w(), 32.0, false)) != null && (creaking = CreakingHeartBlockEntity.a(serverLevel, creakingHeart)) != null) {
                        creakingHeart.a(creaking);
                        creaking.b(SoundEffects.hv);
                        level.a(null, creakingHeart.aD_(), SoundEffects.hF, SoundCategory.e, 1.0f, 1.0f);
                    }
                } else {
                    Optional<Creaking> creakingProtector = creakingHeart.l();
                    if (creakingProtector.isPresent()) {
                        creaking = creakingProtector.get();
                        if (level.c().a(EnvironmentAttributes.L, pos) == false && !creaking.gA() || creakingHeart.h() > 34.0 || creaking.gR()) {
                            creakingHeart.a((DamageSource)null);
                        }
                    }
                }
            }
        }
    }

    private static IBlockData a(World level, IBlockData state, BlockPosition pos, CreakingHeartBlockEntity creakingHeart) {
        if (!CreakingHeartBlock.b(state, (IWorldReader)level, pos) && creakingHeart.t == null) {
            return (IBlockData)state.b(CreakingHeartBlock.c, CreakingHeartState.a);
        }
        CreakingHeartState creakingHeartState = level.c().a(EnvironmentAttributes.L, pos) != false ? CreakingHeartState.c : CreakingHeartState.b;
        return (IBlockData)state.b(CreakingHeartBlock.c, creakingHeartState);
    }

    private double h() {
        return this.l().map(creaking -> Math.sqrt(creaking.g(Vec3D.c(this.aD_())))).orElse(0.0);
    }

    private void k() {
        this.t = null;
        this.e();
    }

    public void a(Creaking creaking) {
        this.t = Either.left(creaking);
        this.e();
    }

    public void a(UUID creakingUuid) {
        this.t = Either.right(creakingUuid);
        this.u = 0L;
        this.e();
    }

    private Optional<Creaking> l() {
        World world;
        if (this.t == null) {
            return s;
        }
        if (this.t.left().isPresent()) {
            Creaking creaking = this.t.left().get();
            if (!creaking.eh()) {
                return Optional.of(creaking);
            }
            this.a(creaking.cY());
        }
        if ((world = this.n) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.t.right().isPresent()) {
                UUID uuid = this.t.right().get();
                Entity entity = serverLevel.d(uuid);
                if (entity instanceof Creaking) {
                    Creaking creaking1 = (Creaking)entity;
                    this.a(creaking1);
                    return Optional.of(creaking1);
                }
                if (this.u >= 30L) {
                    this.k();
                }
                return s;
            }
        }
        return s;
    }

    private static @Nullable Creaking a(WorldServer level, CreakingHeartBlockEntity creakingHeart) {
        BlockPosition blockPos = creakingHeart.aD_();
        Optional<Creaking> optional = SpawnUtil.a(EntityTypes.H, EntitySpawnReason.c, level, blockPos, 5, 16, 8, SpawnUtil.a.c, true);
        if (optional.isEmpty()) {
            return null;
        }
        Creaking creaking = optional.get();
        level.a((Entity)creaking, GameEvent.t, creaking.dI());
        level.a((Entity)creaking, (byte)60);
        creaking.h(blockPos);
        return creaking;
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    public void c() {
        Object var2_1 = this.l().orElse(null);
        if (var2_1 instanceof Creaking) {
            Creaking creaking = var2_1;
            World world = this.n;
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (this.w <= 0) {
                    this.a(serverLevel, 20, false);
                    if (this.o().c(CreakingHeartBlock.c) == CreakingHeartState.c) {
                        int randomInt = this.n.G_().a(2, 3);
                        for (int i2 = 0; i2 < randomInt; ++i2) {
                            this.a(serverLevel).ifPresent(pos -> {
                                this.n.a(null, (BlockPosition)pos, SoundEffects.yj, SoundCategory.e, 1.0f, 1.0f);
                                this.n.a((Holder<GameEvent>)GameEvent.i, (BlockPosition)pos, GameEvent.a.a(this.o()));
                            });
                        }
                    }
                    this.w = 100;
                    this.x = creaking.dj().f();
                }
            }
        }
    }

    private Optional<BlockPosition> a(WorldServer level) {
        MutableObject mutable = new MutableObject(null);
        BlockPosition.a(this.o, 2, 64, (pos, output) -> {
            for (EnumDirection direction : SystemUtils.b(EnumDirection.values(), level.y)) {
                BlockPosition blockPos = pos.a(direction);
                if (!level.a_(blockPos).a(TagsBlock.t)) continue;
                output.accept(blockPos);
            }
        }, arg_0 -> CreakingHeartBlockEntity.a(level, (Mutable)mutable, arg_0));
        return Optional.ofNullable((BlockPosition)mutable.get());
    }

    private void a(WorldServer level, int count, boolean reverseDirection) {
        Object var5_4 = this.l().orElse(null);
        if (var5_4 instanceof Creaking) {
            Creaking creaking = var5_4;
            int i2 = reverseDirection ? 16545810 : 0x5F5F5F;
            RandomSource randomSource = level.y;
            for (double d2 = 0.0; d2 < (double)count; d2 += 1.0) {
                AxisAlignedBB boundingBox = creaking.dj();
                Vec3D vec3 = boundingBox.h().b(randomSource.j() * boundingBox.b(), randomSource.j() * boundingBox.c(), randomSource.j() * boundingBox.d());
                Vec3D vec31 = Vec3D.a(this.aD_()).b(randomSource.j(), randomSource.j(), randomSource.j());
                if (reverseDirection) {
                    Vec3D vec32 = vec3;
                    vec3 = vec31;
                    vec31 = vec32;
                }
                TrailParticleOption trailParticleOption = new TrailParticleOption(vec31, i2, randomSource.a(40) + 10);
                level.a(trailParticleOption, true, true, vec3.g, vec3.h, vec3.i, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void a(BlockPosition pos, IBlockData state) {
        this.a((DamageSource)null);
    }

    public void a(@Nullable DamageSource damageSource) {
        Object var3_2 = this.l().orElse(null);
        if (var3_2 instanceof Creaking) {
            Creaking creaking = var3_2;
            if (damageSource == null) {
                creaking.gQ();
            } else {
                creaking.j(damageSource);
                creaking.gT();
                creaking.x(0.0f);
            }
            this.k();
        }
    }

    public boolean b(Creaking creaking) {
        return this.l().map(creaking1 -> creaking1 == creaking).orElse(false);
    }

    public int d() {
        return this.y;
    }

    public int f() {
        if (this.t != null && !this.l().isEmpty()) {
            double d2 = this.h();
            double d1 = Math.clamp(d2, 0.0, 32.0) / 32.0;
            return 15 - (int)Math.floor(d1 * 15.0);
        }
        return 0;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        input.a("creaking", UUIDUtil.a).ifPresentOrElse(this::a, this::k);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        if (this.t != null) {
            output.a("creaking", UUIDUtil.a, this.t.map(Entity::cY, uuid -> uuid));
        }
    }

    private static /* synthetic */ BlockPosition.b a(WorldServer level, Mutable mutable, BlockPosition pos) {
        if (!level.a_(pos).a(TagsBlock.t)) {
            return BlockPosition.b.a;
        }
        for (EnumDirection direction : SystemUtils.b(EnumDirection.values(), level.y)) {
            BlockPosition blockPos = pos.a(direction);
            IBlockData blockState = level.a_(blockPos);
            EnumDirection opposite = direction.g();
            if (blockState.l()) {
                blockState = Blocks.fP.m();
            } else if (blockState.a(Blocks.J) && blockState.y().b()) {
                blockState = (IBlockData)Blocks.fP.m().b(MultifaceBlock.c, true);
            }
            if (!blockState.a(Blocks.fP) || MultifaceBlock.a(blockState, opposite)) continue;
            level.a(blockPos, (IBlockData)blockState.b(MultifaceBlock.b(opposite), true), 3);
            mutable.setValue((Object)blockPos);
            return BlockPosition.b.c;
        }
        return BlockPosition.b.a;
    }
}

