/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class SculkShriekerBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final int a = 10;
    private static final int b = 20;
    private static final int c = 5;
    private static final int d = 6;
    private static final int e = 40;
    private static final int f = 90;
    private static final Int2ObjectMap<SoundEffect> j = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T map) -> {
        map.put(1, (Object)SoundEffects.Fj);
        map.put(2, (Object)SoundEffects.Fk);
        map.put(3, (Object)SoundEffects.Fl);
        map.put(4, (Object)SoundEffects.Fi);
    });
    private static final int k = 0;
    public int l = 0;
    private final VibrationSystem.d m = new a();
    private VibrationSystem.a q = new VibrationSystem.a();
    private final VibrationSystem.b r = new VibrationSystem.b(this);

    public SculkShriekerBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.M, pos, blockState);
    }

    @Override
    public VibrationSystem.a gS() {
        return this.q;
    }

    @Override
    public VibrationSystem.d gT() {
        return this.m;
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.l = input.a("warning_level", 0);
        this.q = input.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("warning_level", this.l);
        output.a("listener", VibrationSystem.a.a, this.q);
    }

    public static @Nullable EntityPlayer a(@Nullable Entity entity) {
        EntityPlayer player = SculkShriekerBlockEntity.tryGetPlayer0(entity);
        return player != null && player.A() == entity.ao() ? player : null;
    }

    private static @Nullable EntityPlayer tryGetPlayer0(@Nullable Entity entity) {
        EntityPlayer serverPlayer1;
        EntityItem itemEntity;
        Entity entity2;
        IProjectile projectile;
        Entity entity3;
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            return serverPlayer;
        }
        if (entity != null && (entity3 = entity.dl()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity3;
            return serverPlayer;
        }
        if (entity instanceof IProjectile && (entity3 = (projectile = (IProjectile)entity).p()) instanceof EntityPlayer) {
            EntityPlayer serverPlayer12 = (EntityPlayer)entity3;
            return serverPlayer12;
        }
        return entity instanceof EntityItem && (entity2 = (itemEntity = (EntityItem)entity).p()) instanceof EntityPlayer ? (serverPlayer1 = (EntityPlayer)entity2) : null;
    }

    public void a(WorldServer level, @Nullable EntityPlayer player) {
        IBlockData blockState;
        if (player != null && !(blockState = this.o()).c(SculkShriekerBlock.b).booleanValue()) {
            this.l = 0;
            if (!this.b(level) || this.b(level, player)) {
                this.a(level, (Entity)player);
            }
        }
    }

    private boolean b(WorldServer level, EntityPlayer player) {
        OptionalInt optionalInt = WardenSpawnTracker.a(level, this.aD_(), player);
        optionalInt.ifPresent(i2 -> {
            this.l = i2;
        });
        return optionalInt.isPresent();
    }

    private void a(WorldServer level, @Nullable Entity sourceEntity) {
        BlockPosition blockPos = this.aD_();
        IBlockData blockState = this.o();
        level.a(blockPos, (IBlockData)blockState.b(SculkShriekerBlock.b, true), 2);
        level.a(blockPos, blockState.b(), 90);
        level.c(3007, blockPos, 0);
        level.a(GameEvent.N, blockPos, GameEvent.a.a(sourceEntity));
    }

    private boolean b(WorldServer level) {
        return this.o().c(SculkShriekerBlock.d) != false && level.av() != EnumDifficulty.a && level.U().a(GameRules.aa) != false;
    }

    @Override
    public void a(BlockPosition pos, IBlockData state) {
        World world;
        if (state.c(SculkShriekerBlock.b).booleanValue() && (world = this.n) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel);
        }
    }

    public void a(WorldServer level) {
        if (this.b(level) && this.l > 0) {
            if (!this.c(level)) {
                this.b((World)level);
            }
            Warden.a(level, Vec3D.b(this.aD_()), null, 40);
        }
    }

    private void b(World level) {
        SoundEffect soundEvent = (SoundEffect)j.get(this.l);
        if (soundEvent != null) {
            BlockPosition blockPos = this.aD_();
            int i2 = blockPos.u() + MathHelper.b(level.y, -10, 10);
            int i1 = blockPos.v() + MathHelper.b(level.y, -10, 10);
            int i22 = blockPos.w() + MathHelper.b(level.y, -10, 10);
            level.a(null, (double)i2, (double)i1, (double)i22, soundEvent, SoundCategory.f, 5.0f, 1.0f);
        }
    }

    private boolean c(WorldServer level) {
        return this.l >= 4 && SpawnUtil.trySpawnMob(EntityTypes.bO, EntitySpawnReason.k, level, this.aD_(), 20, 5, 6, SpawnUtil.a.b, false, CreatureSpawnEvent.SpawnReason.NATURAL, null).isPresent();
    }

    public VibrationSystem.b a() {
        return this.r;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 8;
        private final PositionSource c;

        public a() {
            this.c = new BlockPositionSource(SculkShriekerBlockEntity.this.o);
        }

        @Override
        public int a() {
            return 8;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.c;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            return SculkShriekerBlockEntity.this.o().c(SculkShriekerBlock.b) == false && SculkShriekerBlockEntity.a(context.a()) != null;
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            SculkShriekerBlockEntity.this.a(level, SculkShriekerBlockEntity.a(playerEntity != null ? playerEntity : entity));
        }

        @Override
        public void e() {
            SculkShriekerBlockEntity.this.e();
        }

        @Override
        public boolean f() {
            return true;
        }
    }
}

