/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R7.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class TileEntity
implements DebugValueSource {
    static boolean ignoreBlockEntityUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public final CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<TileEntityTypes<?>> d;
    private static final Logger e;
    private final TileEntityTypes<?> f;
    protected @Nullable World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData g;
    private DataComponentMap h = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        this.f = type;
        this.o = pos.j();
        this.a(blockState);
        this.g = blockState;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void a(IBlockData state) {
        if (!this.b(state)) {
            throw new IllegalStateException("Invalid block entity " + this.r() + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(state));
        }
    }

    public boolean b(IBlockData state) {
        return this.f.a(state);
    }

    public static BlockPosition a(ChunkCoordIntPair chunkPos, NBTTagCompound tag) {
        int intOr = tag.b("x", 0);
        int intOr1 = tag.b("y", 0);
        int intOr2 = tag.b("z", 0);
        if (chunkPos != null) {
            int sectionPosCoord = SectionPosition.a(intOr);
            int sectionPosCoord1 = SectionPosition.a(intOr2);
            if (sectionPosCoord != chunkPos.h || sectionPosCoord1 != chunkPos.i) {
                e.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)tag, (Object)chunkPos);
                intOr = chunkPos.a(SectionPosition.b(intOr));
                intOr2 = chunkPos.b(SectionPosition.b(intOr2));
            }
        }
        return new BlockPosition(intOr, intOr1, intOr2);
    }

    public @Nullable World j() {
        return this.n;
    }

    public void a(World level) {
        this.n = level;
    }

    public boolean n() {
        return this.n != null;
    }

    protected void a(ValueInput input) {
        this.persistentDataContainer.clear();
        input.a("PublicBukkitValues", NBTTagCompound.a).ifPresent(this.persistentDataContainer::putAll);
    }

    public final void b(ValueInput input) {
        this.a(input);
        this.h = input.a("components", DataComponentMap.b).orElse(DataComponentMap.a);
    }

    public final void c(ValueInput input) {
        this.a(input);
    }

    protected void a(ValueOutput output) {
    }

    public final NBTTagCompound b(HolderLookup.a registries) {
        NBTTagCompound var4;
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.v(), e);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, registries);
            this.c(tagValueOutput);
            var4 = tagValueOutput.b();
        }
        return var4;
    }

    public void c(ValueOutput output) {
        this.e(output);
        this.h(output);
    }

    public void d(ValueOutput output) {
        this.e(output);
        this.g(output);
    }

    public final NBTTagCompound c(HolderLookup.a registries) {
        NBTTagCompound var4;
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.v(), e);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, registries);
            this.e(tagValueOutput);
            var4 = tagValueOutput.b();
        }
        return var4;
    }

    public void e(ValueOutput output) {
        this.a(output);
        output.a("components", DataComponentMap.b, this.h);
        if (!this.persistentDataContainer.isEmpty()) {
            output.a("PublicBukkitValues", NBTTagCompound.a, this.persistentDataContainer.toTagCompound());
        }
    }

    public final NBTTagCompound d(HolderLookup.a registries) {
        NBTTagCompound var4;
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(this.v(), e);){
            TagValueOutput tagValueOutput = TagValueOutput.a(scopedCollector, registries);
            this.f(tagValueOutput);
            var4 = tagValueOutput.b();
        }
        return var4;
    }

    public void f(ValueOutput output) {
        this.a(output);
        if (!this.persistentDataContainer.isEmpty()) {
            output.a("PublicBukkitValues", NBTTagCompound.a, this.persistentDataContainer.toTagCompound());
        }
    }

    public void g(ValueOutput output) {
        TileEntity.a(output, this.s());
    }

    public static void a(ValueOutput output, TileEntityTypes<?> entityType) {
        output.a("id", d, entityType);
    }

    private void h(ValueOutput output) {
        this.g(output);
        output.a("x", this.o.u());
        output.a("y", this.o.v());
        output.a("z", this.o.w());
    }

    public static @Nullable TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound tag, HolderLookup.a registries) {
        Object blockEntity;
        TileEntityTypes blockEntityType = tag.a("id", d).orElse(null);
        if (blockEntityType == null) {
            e.error("Skipping block entity with invalid type: {}", (Object)tag.a("id"));
            return null;
        }
        try {
            blockEntity = blockEntityType.a(pos, state);
        }
        catch (Throwable var12) {
            e.error("Failed to create block entity {} for block {} at position {} ", new Object[]{blockEntityType, pos, state, var12});
            return null;
        }
        try {
            Object var7;
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(((TileEntity)blockEntity).v(), e);){
                ((TileEntity)blockEntity).b(TagValueInput.a((ProblemReporter)scopedCollector, registries, tag));
                var7 = blockEntity;
            }
            return var7;
        }
        catch (Throwable var11) {
            e.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{blockEntityType, pos, state, var11});
            return null;
        }
    }

    public void e() {
        if (this.n != null) {
            if (ignoreBlockEntityUpdates) {
                return;
            }
            TileEntity.a(this.n, this.o, this.g);
        }
    }

    protected static void a(World level, BlockPosition pos, IBlockData state) {
        level.u(pos);
        if (!state.l()) {
            level.b(pos, state.b());
        }
    }

    public BlockPosition aD_() {
        return this.o;
    }

    public IBlockData o() {
        return this.g;
    }

    public @Nullable Packet<PacketListenerPlayOut> ax_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a registries) {
        return new NBTTagCompound();
    }

    public boolean p() {
        return this.p;
    }

    public void ay_() {
        this.p = true;
    }

    public void q() {
        this.p = false;
    }

    public void a(BlockPosition pos, IBlockData state) {
        TileEntity tileEntity = this;
        if (tileEntity instanceof IInventory) {
            IInventory container = (IInventory)((Object)tileEntity);
            if (this.n != null) {
                InventoryUtils.a(this.n, pos, container);
            }
        }
    }

    public boolean a_(int id, int type) {
        return false;
    }

    public void a(CrashReportSystemDetails category) {
        category.a("Name", this::r);
        category.a("Cached block", this.o()::toString);
        if (this.n == null) {
            category.a("Block location", () -> String.valueOf(this.o) + " (world missing)");
        } else {
            category.a("Actual block", this.n.a_(this.o)::toString);
            CrashReportSystemDetails.a(category, this.n, this.o);
        }
    }

    public String r() {
        return String.valueOf(BuiltInRegistries.k.b(this.s())) + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> s() {
        return this.f;
    }

    @Deprecated
    public void c(IBlockData blockState) {
        this.a(blockState);
        this.g = blockState;
    }

    protected void a(DataComponentGetter componentGetter) {
    }

    public final void a(ItemStack stack) {
        this.a(stack.c(), stack.d());
    }

    public final void a(DataComponentMap components, DataComponentPatch patch) {
        this.applyComponentsSet(components, patch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap components, DataComponentPatch patch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.ah);
        set.add(DataComponents.ax);
        final PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.a(components, patch);
        this.a(new DataComponentGetter(){

            @Override
            public <T> @Nullable T a(DataComponentType<? extends T> component) {
                set.add(component);
                return dataComponentMap.a(component);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> component, T defaultValue) {
                set.add(component);
                return dataComponentMap.a(component, defaultValue);
            }
        });
        DataComponentPatch dataComponentPatch = patch.a(set::contains);
        this.h = dataComponentPatch.e().a();
        set.remove(DataComponents.ah);
        return set;
    }

    protected void a(DataComponentMap.a components) {
    }

    @Deprecated
    public void b(ValueOutput output) {
    }

    public final DataComponentMap t() {
        DataComponentMap.a builder = DataComponentMap.a();
        builder.a(this.h);
        this.a(builder);
        return builder.a();
    }

    public DataComponentMap u() {
        return this.h;
    }

    public void a(DataComponentMap components) {
        this.h = components;
    }

    public static @Nullable IChatBaseComponent a(ValueInput input, String customName) {
        return input.a(customName, ComponentSerialization.a).orElse(null);
    }

    public ProblemReporter.f v() {
        return new a(this);
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
    }

    public @Nullable InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public @Nullable InventoryHolder getOwner(boolean useSnapshot) {
        InventoryHolder inventoryHolder;
        if (this.n == null) {
            return null;
        }
        CraftBlock block = CraftBlock.at(this.n, this.o);
        BlockState state = block.getState(useSnapshot);
        return state instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)state) : null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        d = BuiltInRegistries.k.q();
        e = LogUtils.getLogger();
    }

    record a(TileEntity a) implements ProblemReporter.f
    {
        @Override
        public String get() {
            return this.a.r() + "@" + String.valueOf(this.a.aD_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockEntity", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockEntity", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockEntity", "a"}, this, o2);
        }
    }
}

