/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class TileEntityConduit
extends TileEntity {
    private static final int b = 2;
    private static final int c = 13;
    private static final float d = -0.0375f;
    private static final int e = 16;
    public static final int f = 42;
    private static final int g = 8;
    private static final Block[] h = new Block[]{Blocks.iR, Blocks.iS, Blocks.ja, Blocks.iT};
    public int a;
    private float i;
    private boolean j;
    private boolean k;
    public final List<BlockPosition> l = Lists.newArrayList();
    public @Nullable EntityReference<EntityLiving> m;
    private long q;

    public TileEntityConduit(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.A, pos, blockState);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.m = EntityReference.a(input, "Target");
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        EntityReference.a(this.m, output, "Target");
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity) {
        ++blockEntity.a;
        long gameTime = level.au();
        List<BlockPosition> list = blockEntity.l;
        if (gameTime % 40L == 0L) {
            blockEntity.j = TileEntityConduit.a(level, pos, list);
            TileEntityConduit.a(blockEntity, list);
        }
        EntityLiving livingEntity = EntityReference.b(blockEntity.m, level);
        TileEntityConduit.a(level, pos, list, livingEntity, blockEntity.a);
        if (blockEntity.c()) {
            blockEntity.i += 1.0f;
        }
    }

    public static void b(World level, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity) {
        ++blockEntity.a;
        long gameTime = level.au();
        List<BlockPosition> list = blockEntity.l;
        if (gameTime % 40L == 0L) {
            boolean flag = TileEntityConduit.a(level, pos, list);
            if (flag != blockEntity.j) {
                SoundEffect soundEvent = flag ? SoundEffects.fX : SoundEffects.gb;
                level.a(null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
            }
            blockEntity.j = flag;
            TileEntityConduit.a(blockEntity, list);
            if (flag) {
                TileEntityConduit.b(level, pos, list);
                TileEntityConduit.a((WorldServer)level, pos, state, blockEntity, list.size() >= 42);
            }
        }
        if (blockEntity.c()) {
            if (gameTime % 80L == 0L) {
                level.a(null, pos, SoundEffects.fY, SoundCategory.e, 1.0f, 1.0f);
            }
            if (gameTime > blockEntity.q) {
                blockEntity.q = gameTime + 60L + (long)level.G_().a(40);
                level.a(null, pos, SoundEffects.fZ, SoundCategory.e, 1.0f, 1.0f);
            }
        }
    }

    private static void a(TileEntityConduit blockEntity, List<BlockPosition> positions) {
        blockEntity.a(positions.size() >= 42);
    }

    private static boolean a(World level, BlockPosition pos, List<BlockPosition> positions) {
        int i1;
        int i2;
        positions.clear();
        for (i2 = -1; i2 <= 1; ++i2) {
            for (i1 = -1; i1 <= 1; ++i1) {
                for (int i22 = -1; i22 <= 1; ++i22) {
                    BlockPosition blockPos = pos.b(i2, i1, i22);
                    if (level.F(blockPos)) continue;
                    return false;
                }
            }
        }
        for (i2 = -2; i2 <= 2; ++i2) {
            for (i1 = -2; i1 <= 2; ++i1) {
                for (int i2x = -2; i2x <= 2; ++i2x) {
                    int abs = Math.abs(i2);
                    int abs1 = Math.abs(i1);
                    int abs2 = Math.abs(i2x);
                    if (abs <= 1 && abs1 <= 1 && abs2 <= 1 || (i2 != 0 || abs1 != 2 && abs2 != 2) && (i1 != 0 || abs != 2 && abs2 != 2) && (i2x != 0 || abs != 2 && abs1 != 2)) continue;
                    BlockPosition blockPos1 = pos.b(i2, i1, i2x);
                    IBlockData blockState = level.a_(blockPos1);
                    for (Block block : h) {
                        if (!blockState.a(block)) continue;
                        positions.add(blockPos1);
                    }
                }
            }
        }
        return positions.size() >= 16;
    }

    private static void b(World level, BlockPosition pos, List<BlockPosition> positions) {
        TileEntityConduit.applyEffects(level, pos, TileEntityConduit.getRange(positions));
    }

    public static int getRange(List<BlockPosition> positions) {
        int size = positions.size();
        int i2 = size / 7 * 16;
        return i2;
    }

    private static void applyEffects(World level, BlockPosition pos, int i2) {
        int z2;
        int y2;
        int x2 = pos.u();
        AxisAlignedBB aabb = new AxisAlignedBB(x2, y2 = pos.v(), z2 = pos.w(), x2 + 1, y2 + 1, z2 + 1).g(i2).b(0.0, level.L_(), 0.0);
        List<EntityHuman> entitiesOfClass = level.a(EntityHuman.class, aabb);
        if (!entitiesOfClass.isEmpty()) {
            for (EntityHuman player : entitiesOfClass) {
                if (!pos.a(player.dK(), (double)i2) || !player.bA()) continue;
                player.addEffect(new MobEffect(MobEffects.C, 260, 0, true, true), EntityPotionEffectEvent.Cause.CONDUIT);
            }
        }
    }

    private static void a(WorldServer level, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity, boolean canDestroy) {
        TileEntityConduit.updateAndAttackTarget(level, pos, state, blockEntity, canDestroy, true);
    }

    public static void updateAndAttackTarget(WorldServer level, BlockPosition pos, IBlockData state, TileEntityConduit blockEntity, boolean canDestroy, boolean damageTarget) {
        EntityReference<EntityLiving> entityReference = TileEntityConduit.a(blockEntity.m, level, pos, canDestroy);
        EntityLiving livingEntity = EntityReference.b(entityReference, level);
        if (damageTarget && livingEntity != null && livingEntity.a(level, level.as().q().eventBlockDamager(level, pos), 4.0f)) {
            level.a(null, livingEntity.dP(), livingEntity.dR(), livingEntity.dV(), SoundEffects.ga, SoundCategory.e, 1.0f, 1.0f);
        }
        if (!Objects.equals(entityReference, blockEntity.m)) {
            blockEntity.m = entityReference;
            level.a(pos, state, state, 2);
        }
    }

    public static @Nullable EntityReference<EntityLiving> a(@Nullable EntityReference<EntityLiving> destroyTarget, WorldServer level, BlockPosition pos, boolean canDestroy) {
        if (!canDestroy) {
            return null;
        }
        if (destroyTarget == null) {
            return TileEntityConduit.a(level, pos);
        }
        EntityLiving livingEntity = EntityReference.b(destroyTarget, level);
        return livingEntity != null && livingEntity.cb() && pos.a(livingEntity.dK(), 8.0) ? destroyTarget : null;
    }

    private static @Nullable EntityReference<EntityLiving> a(WorldServer level, BlockPosition pos) {
        List<EntityLiving> entitiesOfClass = level.a(EntityLiving.class, TileEntityConduit.a(pos), livingEntity -> livingEntity instanceof IMonster && livingEntity.bA());
        return entitiesOfClass.isEmpty() ? null : EntityReference.a(SystemUtils.a(entitiesOfClass, level.y));
    }

    public static AxisAlignedBB a(BlockPosition pos) {
        return new AxisAlignedBB(pos).g(8.0);
    }

    private static void a(World level, BlockPosition pos, List<BlockPosition> positions, @Nullable Entity entity, int tickCount) {
        float f2;
        RandomSource randomSource = level.y;
        double d2 = MathHelper.a((double)((float)(tickCount + 35) * 0.1f)) / 2.0f + 0.5f;
        d2 = (d2 * d2 + d2) * (double)0.3f;
        Vec3D vec3 = new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 1.5 + d2, (double)pos.w() + 0.5);
        for (BlockPosition blockPos : positions) {
            if (randomSource.a(50) != 0) continue;
            BlockPosition blockPos1 = blockPos.b(pos);
            f2 = -0.5f + randomSource.i() + (float)blockPos1.u();
            float f1 = -2.0f + randomSource.i() + (float)blockPos1.v();
            float f22 = -0.5f + randomSource.i() + (float)blockPos1.w();
            level.a(Particles.av, vec3.g, vec3.h, vec3.i, (double)f2, (double)f1, f22);
        }
        if (entity != null) {
            Vec3D vec31 = new Vec3D(entity.dP(), entity.dT(), entity.dV());
            float f3 = (-0.5f + randomSource.i()) * (3.0f + entity.dF());
            float f4 = -1.0f + randomSource.i() * entity.dG();
            f2 = (-0.5f + randomSource.i()) * (3.0f + entity.dF());
            Vec3D vec32 = new Vec3D(f3, f4, f2);
            level.a(Particles.av, vec31.g, vec31.h, vec31.i, vec32.g, vec32.h, vec32.i);
        }
    }

    public boolean c() {
        return this.j;
    }

    public boolean d() {
        return this.k;
    }

    private void a(boolean isHunting) {
        this.k = isHunting;
    }

    public float a(float partialTick) {
        return (this.i + partialTick) * -0.0375f;
    }
}

