/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class TileEntityStructure
extends TileEntity
implements BoundingBoxRenderable {
    private static final int d = 5;
    public static final int a = 48;
    public static final int b = 48;
    public static final String c = "author";
    private static final String e = "";
    private static final String f = "";
    private static final BlockPosition g = new BlockPosition(0, 1, 0);
    private static final BaseBlockPosition h = BaseBlockPosition.i;
    private static final EnumBlockRotation i = EnumBlockRotation.a;
    private static final EnumBlockMirror j = EnumBlockMirror.a;
    private static final boolean k = true;
    private static final boolean l = false;
    private static final boolean m = false;
    private static final boolean q = false;
    private static final boolean r = true;
    private static final float s = 1.0f;
    private static final long t = 0L;
    private @Nullable MinecraftKey u;
    public String v = "";
    public String w = "";
    public BlockPosition x = g;
    public BaseBlockPosition y = h;
    public EnumBlockMirror z = EnumBlockMirror.a;
    public EnumBlockRotation A = EnumBlockRotation.a;
    public BlockPropertyStructureMode B;
    public boolean C = true;
    private boolean D = false;
    private boolean E = false;
    public boolean F = false;
    public boolean G = true;
    public float H = 1.0f;
    public long I = 0L;

    public TileEntityStructure(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.v, pos, blockState);
        this.B = blockState.c(BlockStructure.b);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("name", this.d());
        output.a(c, this.v);
        output.a("metadata", this.w);
        output.a("posX", this.x.u());
        output.a("posY", this.x.v());
        output.a("posZ", this.x.w());
        output.a("sizeX", this.y.u());
        output.a("sizeY", this.y.v());
        output.a("sizeZ", this.y.w());
        output.a("rotation", EnumBlockRotation.h, this.A);
        output.a("mirror", EnumBlockMirror.e, this.z);
        output.a("mode", BlockPropertyStructureMode.e, this.B);
        output.a("ignoreEntities", this.C);
        output.a("strict", this.D);
        output.a("powered", this.E);
        output.a("showair", this.F);
        output.a("showboundingbox", this.G);
        output.a("integrity", this.H);
        output.a("seed", this.I);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("name", ""));
        this.v = input.a(c, "");
        this.w = input.a("metadata", "");
        int i2 = MathHelper.a(input.a("posX", g.u()), -48, 48);
        int i1 = MathHelper.a(input.a("posY", g.v()), -48, 48);
        int i22 = MathHelper.a(input.a("posZ", g.w()), -48, 48);
        this.x = new BlockPosition(i2, i1, i22);
        int i3 = MathHelper.a(input.a("sizeX", h.u()), 0, 48);
        int i4 = MathHelper.a(input.a("sizeY", h.v()), 0, 48);
        int i5 = MathHelper.a(input.a("sizeZ", h.w()), 0, 48);
        this.y = new BaseBlockPosition(i3, i4, i5);
        this.A = input.a("rotation", EnumBlockRotation.h).orElse(i);
        this.z = input.a("mirror", EnumBlockMirror.e).orElse(j);
        this.B = input.a("mode", BlockPropertyStructureMode.e).orElse(BlockPropertyStructureMode.d);
        this.C = input.a("ignoreEntities", true);
        this.D = input.a("strict", false);
        this.E = input.a("powered", false);
        this.F = input.a("showair", false);
        this.G = input.a("showboundingbox", true);
        this.H = input.a("integrity", 1.0f);
        this.I = input.a("seed", 0L);
        this.J();
    }

    private void J() {
        BlockPosition blockPos;
        IBlockData blockState;
        if (this.n != null && (blockState = this.n.a_(blockPos = this.aD_())).a(Blocks.pY)) {
            this.n.a(blockPos, (IBlockData)blockState.b(BlockStructure.b, this.B), 2);
        }
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.d(registries);
    }

    public boolean a(EntityHuman player) {
        if (!player.hi()) {
            return false;
        }
        if (player.ao().B_()) {
            player.a(this);
        }
        return true;
    }

    public String d() {
        return this.u == null ? "" : this.u.toString();
    }

    public boolean f() {
        return this.u != null;
    }

    public void a(@Nullable String structureName) {
        this.a(UtilColor.b(structureName) ? null : MinecraftKey.c(structureName));
    }

    public void a(@Nullable MinecraftKey structureName) {
        this.u = structureName;
    }

    public void a(EntityLiving author) {
        this.v = author.aq();
    }

    public BlockPosition h() {
        return this.x;
    }

    public void a(BlockPosition structurePos) {
        this.x = structurePos;
    }

    public BaseBlockPosition k() {
        return this.y;
    }

    public void a(BaseBlockPosition structureSize) {
        this.y = structureSize;
    }

    public EnumBlockMirror l() {
        return this.z;
    }

    public void a(EnumBlockMirror mirror) {
        this.z = mirror;
    }

    public EnumBlockRotation m() {
        return this.A;
    }

    public void a(EnumBlockRotation rotation) {
        this.A = rotation;
    }

    public String w() {
        return this.w;
    }

    public void b(String metaData) {
        this.w = metaData;
    }

    public BlockPropertyStructureMode x() {
        return this.B;
    }

    public void a(BlockPropertyStructureMode mode) {
        this.B = mode;
        IBlockData blockState = this.n.a_(this.aD_());
        if (blockState.a(Blocks.pY)) {
            this.n.a(this.aD_(), (IBlockData)blockState.b(BlockStructure.b, mode), 2);
        }
    }

    public boolean y() {
        return this.C;
    }

    public boolean z() {
        return this.D;
    }

    public void a(boolean ignoreEntities) {
        this.C = ignoreEntities;
    }

    public void b(boolean strict) {
        this.D = strict;
    }

    public float A() {
        return this.H;
    }

    public void a(float integrity) {
        this.H = integrity;
    }

    public long B() {
        return this.I;
    }

    public void a(long seed) {
        this.I = seed;
    }

    public boolean C() {
        if (this.B != BlockPropertyStructureMode.a) {
            return false;
        }
        BlockPosition blockPos = this.aD_();
        int i2 = 80;
        BlockPosition blockPos1 = new BlockPosition(blockPos.u() - 80, this.n.K_(), blockPos.w() - 80);
        BlockPosition blockPos2 = new BlockPosition(blockPos.u() + 80, this.n.aw(), blockPos.w() + 80);
        Stream<BlockPosition> relatedCorners = this.a(blockPos1, blockPos2);
        return TileEntityStructure.a(blockPos, relatedCorners).filter(boundingBox -> {
            int i1 = boundingBox.k() - boundingBox.h();
            int i2 = boundingBox.l() - boundingBox.i();
            int i3 = boundingBox.m() - boundingBox.j();
            if (i1 > 1 && i2 > 1 && i3 > 1) {
                this.x = new BlockPosition(boundingBox.h() - blockPos.u() + 1, boundingBox.i() - blockPos.v() + 1, boundingBox.j() - blockPos.w() + 1);
                this.y = new BaseBlockPosition(i1 - 1, i2 - 1, i3 - 1);
                this.e();
                IBlockData blockState = this.n.a_(blockPos);
                this.n.a(blockPos, blockState, blockState, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPosition> a(BlockPosition minPos, BlockPosition maxPos) {
        return BlockPosition.d(minPos, maxPos).filter(pos -> this.n.a_((BlockPosition)pos).a(Blocks.pY)).map(this.n::c_).filter(blockEntity -> blockEntity instanceof TileEntityStructure).map(blockEntity -> (TileEntityStructure)blockEntity).filter(blockEntity -> blockEntity.B == BlockPropertyStructureMode.c && Objects.equals(this.u, blockEntity.u)).map(TileEntity::aD_);
    }

    private static Optional<StructureBoundingBox> a(BlockPosition pos, Stream<BlockPosition> relatedCorners) {
        Iterator iterator = relatedCorners.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        BlockPosition blockPos = (BlockPosition)iterator.next();
        StructureBoundingBox boundingBox = new StructureBoundingBox(blockPos);
        if (iterator.hasNext()) {
            iterator.forEachRemaining(boundingBox::a);
        } else {
            boundingBox.a(pos);
        }
        return Optional.of(boundingBox);
    }

    public boolean D() {
        return this.B == BlockPropertyStructureMode.a && this.c(true);
    }

    public boolean c(boolean writeToDisk) {
        World world;
        if (this.u != null && (world = this.n) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            BlockPosition var4 = this.aD_().a(this.x);
            return TileEntityStructure.a(serverLevel, this.u, var4, this.y, this.C, this.v, writeToDisk, List.of());
        }
        return false;
    }

    public static boolean a(WorldServer level, MinecraftKey structureName, BlockPosition pos, BaseBlockPosition size, boolean ignoreEntities, String author, boolean writeToDisk, List<Block> ignoredBlocks) {
        DefinedStructure structureTemplate;
        StructureTemplateManager structureManager = level.u();
        try {
            structureTemplate = structureManager.a(structureName);
        }
        catch (ResourceKeyInvalidException var12) {
            return false;
        }
        structureTemplate.a(level, pos, size, !ignoreEntities, Stream.concat(ignoredBlocks.stream(), Stream.of(Blocks.lJ)).toList());
        structureTemplate.a(author);
        if (writeToDisk) {
            try {
                return structureManager.c(structureName);
            }
            catch (ResourceKeyInvalidException var11) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource b(long seed) {
        return seed == 0L ? RandomSource.a(SystemUtils.c()) : RandomSource.a(seed);
    }

    public boolean a(WorldServer level) {
        if (this.B == BlockPropertyStructureMode.b && this.u != null) {
            DefinedStructure structureTemplate = level.u().b(this.u).orElse(null);
            if (structureTemplate == null) {
                return false;
            }
            if (structureTemplate.a().equals(this.y)) {
                this.a(level, structureTemplate);
                return true;
            }
            this.a(structureTemplate);
            return false;
        }
        return false;
    }

    public boolean b(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate == null) {
            return false;
        }
        this.a(structureTemplate);
        return true;
    }

    private void a(DefinedStructure structureTemplate) {
        this.v = !UtilColor.b(structureTemplate.b()) ? structureTemplate.b() : "";
        this.y = structureTemplate.a();
        this.e();
    }

    public void c(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate != null) {
            this.a(level, structureTemplate);
        }
    }

    private @Nullable DefinedStructure d(WorldServer level) {
        return this.u == null ? null : (DefinedStructure)level.u().b(this.u).orElse(null);
    }

    private void a(WorldServer level, DefinedStructure structureTemplate) {
        this.a(structureTemplate);
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(this.z).a(this.A).a(this.C).b(this.D);
        if (this.H < 1.0f) {
            structurePlaceSettings.b().a(new DefinedStructureProcessorRotation(MathHelper.a(this.H, 0.0f, 1.0f))).a(TileEntityStructure.b(this.I));
        }
        BlockPosition blockPos = this.aD_().a(this.x);
        if (SharedConstants.J) {
            BlockPosition.c(blockPos, blockPos.a(this.y)).forEach(blockPos1 -> level.a((BlockPosition)blockPos1, Blocks.lJ.m(), 2));
        }
        structureTemplate.a(level, blockPos, blockPos, structurePlaceSettings, TileEntityStructure.b(this.I), 2 | (this.D ? 816 : 0));
    }

    public void E() {
        if (this.u != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.u();
            structureManager.d(this.u);
        }
    }

    public boolean F() {
        if (this.B == BlockPropertyStructureMode.b && !this.n.B_() && this.u != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.u();
            try {
                return structureManager.b(this.u).isPresent();
            }
            catch (ResourceKeyInvalidException var4) {
                return false;
            }
        }
        return false;
    }

    public boolean G() {
        return this.E;
    }

    public void d(boolean powered) {
        this.E = powered;
    }

    public boolean H() {
        return this.F;
    }

    public void e(boolean showAir) {
        this.F = showAir;
    }

    public boolean I() {
        return this.G;
    }

    public void f(boolean showBoundingBox) {
        this.G = showBoundingBox;
    }

    @Override
    public BoundingBoxRenderable.a b() {
        if (this.B != BlockPropertyStructureMode.a && this.B != BlockPropertyStructureMode.b) {
            return BoundingBoxRenderable.a.a;
        }
        if (this.B == BlockPropertyStructureMode.a && this.F) {
            return BoundingBoxRenderable.a.c;
        }
        return this.B != BlockPropertyStructureMode.a && !this.G ? BoundingBoxRenderable.a.a : BoundingBoxRenderable.a.b;
    }

    @Override
    public BoundingBoxRenderable.b c() {
        int i4;
        int i3;
        int i2;
        int x1;
        BlockPosition structurePos = this.h();
        BaseBlockPosition structureSize = this.k();
        int x2 = structurePos.u();
        int z2 = structurePos.w();
        int y2 = structurePos.v();
        int i5 = y2 + structureSize.v();
        return BoundingBoxRenderable.b.a(i2, y2, i3, i4, i5, switch (this.A) {
            case EnumBlockRotation.b -> {
                i2 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? x2 : x2 + 1;
                i3 = x1 < 0 ? z2 + 1 : z2;
                i4 = i2 - (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
                yield i3 + x1;
            }
            case EnumBlockRotation.c -> {
                i2 = x1 < 0 ? x2 : x2 + 1;
                i3 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? z2 : z2 + 1;
                i4 = i2 - x1;
                yield i3 - (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
            }
            case EnumBlockRotation.d -> {
                i2 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? x2 + 1 : x2;
                i3 = x1 < 0 ? z2 : z2 + 1;
                i4 = i2 + (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
                yield i3 - x1;
            }
            default -> {
                i2 = x1 < 0 ? x2 + 1 : x2;
                i3 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? z2 + 1 : z2;
                i4 = i2 + x1;
                yield i3 + (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
            }
        });
    }

    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType a = new UpdateType();
        public static final /* enum */ UpdateType b = new UpdateType();
        public static final /* enum */ UpdateType c = new UpdateType();
        public static final /* enum */ UpdateType d = new UpdateType();
        private static final /* synthetic */ UpdateType[] e;

        public static UpdateType[] values() {
            return (UpdateType[])e.clone();
        }

        public static UpdateType valueOf(String name) {
            return Enum.valueOf(UpdateType.class, name);
        }

        private static /* synthetic */ UpdateType[] a() {
            return new UpdateType[]{a, b, c, d};
        }

        static {
            e = UpdateType.a();
        }
    }
}

