/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TileEntityTypes<T extends TileEntity> {
    private static final Logger X = LogUtils.getLogger();
    public static final TileEntityTypes<TileEntityFurnaceFurnace> a = TileEntityTypes.a("furnace", TileEntityFurnaceFurnace::new, Blocks.da);
    public static final TileEntityTypes<TileEntityChest> b = TileEntityTypes.a("chest", TileEntityChest::new, Blocks.cS, Blocks.ts, Blocks.tt, Blocks.tu, Blocks.tv, Blocks.tw, Blocks.tx, Blocks.ty, Blocks.tz);
    public static final TileEntityTypes<TileEntityChestTrapped> c = TileEntityTypes.a("trapped_chest", TileEntityChestTrapped::new, Blocks.hM);
    public static final TileEntityTypes<TileEntityEnderChest> d = TileEntityTypes.a("ender_chest", TileEntityEnderChest::new, Blocks.gv);
    public static final TileEntityTypes<TileEntityJukeBox> e = TileEntityTypes.a("jukebox", TileEntityJukeBox::new, Blocks.ew);
    public static final TileEntityTypes<TileEntityDispenser> f = TileEntityTypes.a("dispenser", TileEntityDispenser::new, Blocks.bb);
    public static final TileEntityTypes<TileEntityDropper> g = TileEntityTypes.a("dropper", TileEntityDropper::new, Blocks.hZ);
    public static final TileEntityTypes<TileEntitySign> h = TileEntityTypes.a("sign", TileEntitySign::new, Blocks.db, Blocks.dc, Blocks.dd, Blocks.de, Blocks.df, Blocks.dg, Blocks.dh, Blocks.di, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.ds, Blocks.dt, Blocks.du, Blocks.dv, Blocks.dw, Blocks.pU, Blocks.pW, Blocks.pV, Blocks.pX, Blocks.dj, Blocks.dx, Blocks.dk, Blocks.dy);
    public static final TileEntityTypes<HangingSignBlockEntity> i = TileEntityTypes.a("hanging_sign", HangingSignBlockEntity::new, Blocks.dz, Blocks.dA, Blocks.dB, Blocks.dC, Blocks.dD, Blocks.dE, Blocks.dF, Blocks.dG, Blocks.dH, Blocks.dI, Blocks.dJ, Blocks.dK, Blocks.dL, Blocks.dM, Blocks.dN, Blocks.dO, Blocks.dP, Blocks.dQ, Blocks.dR, Blocks.dS, Blocks.dU, Blocks.dV, Blocks.dT, Blocks.dW);
    public static final TileEntityTypes<TileEntityMobSpawner> j = TileEntityTypes.a("mob_spawner", TileEntityMobSpawner::new, Blocks.cP);
    public static final TileEntityTypes<CreakingHeartBlockEntity> k = TileEntityTypes.a("creaking_heart", CreakingHeartBlockEntity::new, Blocks.cQ);
    public static final TileEntityTypes<TileEntityPiston> l = TileEntityTypes.a("piston", TileEntityPiston::new, Blocks.ca);
    public static final TileEntityTypes<TileEntityBrewingStand> m = TileEntityTypes.a("brewing_stand", TileEntityBrewingStand::new, Blocks.gh);
    public static final TileEntityTypes<TileEntityEnchantTable> n = TileEntityTypes.a("enchanting_table", TileEntityEnchantTable::new, Blocks.gg);
    public static final TileEntityTypes<TileEntityEnderPortal> o = TileEntityTypes.a("end_portal", TileEntityEnderPortal::new, Blocks.gm);
    public static final TileEntityTypes<TileEntityBeacon> p = TileEntityTypes.a("beacon", TileEntityBeacon::new, Blocks.gD);
    public static final TileEntityTypes<TileEntitySkull> q = TileEntityTypes.a("skull", TileEntitySkull::new, Blocks.hv, Blocks.hw, Blocks.hD, Blocks.hE, Blocks.hF, Blocks.hG, Blocks.hz, Blocks.hA, Blocks.hx, Blocks.hy, Blocks.hB, Blocks.hC, Blocks.hH, Blocks.hI);
    public static final TileEntityTypes<TileEntityLightDetector> r = TileEntityTypes.a("daylight_detector", TileEntityLightDetector::new, Blocks.hQ);
    public static final TileEntityTypes<TileEntityHopper> s = TileEntityTypes.a("hopper", TileEntityHopper::new, Blocks.hT);
    public static final TileEntityTypes<TileEntityComparator> t = TileEntityTypes.a("comparator", TileEntityComparator::new, Blocks.hP);
    public static final TileEntityTypes<TileEntityBanner> u = TileEntityTypes.a("banner", TileEntityBanner::new, Blocks.jB, Blocks.jC, Blocks.jD, Blocks.jE, Blocks.jF, Blocks.jG, Blocks.jH, Blocks.jI, Blocks.jJ, Blocks.jK, Blocks.jL, Blocks.jM, Blocks.jN, Blocks.jO, Blocks.jP, Blocks.jQ, Blocks.jR, Blocks.jS, Blocks.jT, Blocks.jU, Blocks.jV, Blocks.jW, Blocks.jX, Blocks.jY, Blocks.jZ, Blocks.ka, Blocks.kb, Blocks.kc, Blocks.kd, Blocks.ke, Blocks.kf, Blocks.kg);
    public static final TileEntityTypes<TileEntityStructure> v = TileEntityTypes.a("structure_block", TileEntityStructure::new, Blocks.pY);
    public static final TileEntityTypes<TileEntityEndGateway> w = TileEntityTypes.a("end_gateway", TileEntityEndGateway::new, Blocks.lB);
    public static final TileEntityTypes<TileEntityCommand> x = TileEntityTypes.a("command_block", TileEntityCommand::new, Blocks.gC, Blocks.lD, Blocks.lC);
    public static final TileEntityTypes<TileEntityShulkerBox> y = TileEntityTypes.a("shulker_box", TileEntityShulkerBox::new, Blocks.lL, Blocks.mb, Blocks.lX, Blocks.lY, Blocks.lV, Blocks.lT, Blocks.lZ, Blocks.lP, Blocks.lU, Blocks.lR, Blocks.lO, Blocks.lN, Blocks.lS, Blocks.lW, Blocks.ma, Blocks.lM, Blocks.lQ);
    public static final TileEntityTypes<TileEntityBed> z = TileEntityTypes.a("bed", TileEntityBed::new, Blocks.bu, Blocks.bv, Blocks.br, Blocks.bs, Blocks.bp, Blocks.bn, Blocks.bt, Blocks.bj, Blocks.bo, Blocks.bl, Blocks.bi, Blocks.bh, Blocks.bm, Blocks.bq, Blocks.bg, Blocks.bk);
    public static final TileEntityTypes<TileEntityConduit> A = TileEntityTypes.a("conduit", TileEntityConduit::new, Blocks.nU);
    public static final TileEntityTypes<TileEntityBarrel> B = TileEntityTypes.a("barrel", TileEntityBarrel::new, Blocks.oR);
    public static final TileEntityTypes<TileEntitySmoker> C = TileEntityTypes.a("smoker", TileEntitySmoker::new, Blocks.oS);
    public static final TileEntityTypes<TileEntityBlastFurnace> D = TileEntityTypes.a("blast_furnace", TileEntityBlastFurnace::new, Blocks.oT);
    public static final TileEntityTypes<TileEntityLectern> E = TileEntityTypes.a("lectern", TileEntityLectern::new, Blocks.oX);
    public static final TileEntityTypes<TileEntityBell> F = TileEntityTypes.a("bell", TileEntityBell::new, Blocks.pa);
    public static final TileEntityTypes<TileEntityJigsaw> G = TileEntityTypes.a("jigsaw", TileEntityJigsaw::new, Blocks.pZ);
    public static final TileEntityTypes<TileEntityCampfire> H = TileEntityTypes.a("campfire", TileEntityCampfire::new, Blocks.pe, Blocks.pf);
    public static final TileEntityTypes<TileEntityBeehive> I = TileEntityTypes.a("beehive", TileEntityBeehive::new, Blocks.qe, Blocks.qf);
    public static final TileEntityTypes<SculkSensorBlockEntity> J = TileEntityTypes.a("sculk_sensor", SculkSensorBlockEntity::new, Blocks.rQ);
    public static final TileEntityTypes<CalibratedSculkSensorBlockEntity> K = TileEntityTypes.a("calibrated_sculk_sensor", CalibratedSculkSensorBlockEntity::new, Blocks.rR);
    public static final TileEntityTypes<SculkCatalystBlockEntity> L = TileEntityTypes.a("sculk_catalyst", SculkCatalystBlockEntity::new, Blocks.rU);
    public static final TileEntityTypes<SculkShriekerBlockEntity> M = TileEntityTypes.a("sculk_shrieker", SculkShriekerBlockEntity::new, Blocks.rV);
    public static final TileEntityTypes<ChiseledBookShelfBlockEntity> N = TileEntityTypes.a("chiseled_bookshelf", ChiseledBookShelfBlockEntity::new, Blocks.cw);
    public static final TileEntityTypes<ShelfBlockEntity> O = TileEntityTypes.a("shelf", ShelfBlockEntity::new, Blocks.cx, Blocks.cy, Blocks.cz, Blocks.cA, Blocks.cB, Blocks.cC, Blocks.cD, Blocks.cE, Blocks.cF, Blocks.cG, Blocks.cH, Blocks.cI);
    public static final TileEntityTypes<BrushableBlockEntity> P = TileEntityTypes.a("brushable_block", BrushableBlockEntity::new, Blocks.M, Blocks.P);
    public static final TileEntityTypes<DecoratedPotBlockEntity> Q = TileEntityTypes.a("decorated_pot", DecoratedPotBlockEntity::new, Blocks.uO);
    public static final TileEntityTypes<CrafterBlockEntity> R = TileEntityTypes.a("crafter", CrafterBlockEntity::new, Blocks.uP);
    public static final TileEntityTypes<TrialSpawnerBlockEntity> S = TileEntityTypes.a("trial_spawner", TrialSpawnerBlockEntity::new, Blocks.uQ);
    public static final TileEntityTypes<VaultBlockEntity> T = TileEntityTypes.a("vault", VaultBlockEntity::new, Blocks.uR);
    public static final TileEntityTypes<TestBlockEntity> U = TileEntityTypes.a("test_block", TestBlockEntity::new, Blocks.qa);
    public static final TileEntityTypes<TestInstanceBlockEntity> V = TileEntityTypes.a("test_instance_block", TestInstanceBlockEntity::new, Blocks.qb);
    public static final TileEntityTypes<CopperGolemStatueBlockEntity> W = TileEntityTypes.a("copper_golem_statue", CopperGolemStatueBlockEntity::new, Blocks.tA, Blocks.tB, Blocks.tC, Blocks.tD, Blocks.tE, Blocks.tF, Blocks.tG, Blocks.tH);
    private static final Set<TileEntityTypes<?>> Y = Set.of(x, E, h, i, j, S);
    private final a<? extends T> Z;
    public final Set<Block> aa;
    private final Holder.c<TileEntityTypes<?>> ab = BuiltInRegistries.k.f(this);

    public static @Nullable MinecraftKey a(TileEntityTypes<?> type) {
        return BuiltInRegistries.k.b(type);
    }

    private static <T extends TileEntity> TileEntityTypes<T> a(String name, a<? extends T> factory, Block ... validBlocks) {
        if (validBlocks.length == 0) {
            X.warn("Block entity type {} requires at least one valid block to be defined!", (Object)name);
        }
        SystemUtils.a(DataConverterTypes.w, name);
        return IRegistry.a(BuiltInRegistries.k, name, new TileEntityTypes<T>(factory, Set.of(validBlocks)));
    }

    private TileEntityTypes(a<? extends T> factory, Set<Block> validBlocks) {
        this.Z = factory;
        this.aa = validBlocks;
    }

    public T a(BlockPosition pos, IBlockData state) {
        return this.Z.create(pos, state);
    }

    public boolean a(IBlockData state) {
        return this.aa.contains(state.b());
    }

    @Deprecated
    public Holder.c<TileEntityTypes<?>> a() {
        return this.ab;
    }

    public @Nullable T a(IBlockAccess level, BlockPosition pos) {
        TileEntity blockEntity = level.c_(pos);
        return (T)(blockEntity != null && blockEntity.s() == this ? blockEntity : null);
    }

    public boolean b() {
        return Y.contains(this);
    }

    @FunctionalInterface
    static interface a<T extends TileEntity> {
        public T create(BlockPosition var1, IBlockData var2);
    }
}

