/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = 40;
    private static final int c = 36000;
    private static final int d = 14;
    private static final int e = 47;
    private static final int f = MathHelper.i(47);
    private static final float g = 0.02f;
    private final TrialSpawnerData h = new TrialSpawnerData();
    public b i;
    public final c j;
    private PlayerDetector k;
    private final PlayerDetector.a l;
    private boolean m;
    public boolean n;

    public TrialSpawner(b config, c stateAccessor, PlayerDetector playerDetector, PlayerDetector.a entitySelector) {
        this.i = config;
        this.j = stateAccessor;
        this.k = playerDetector;
        this.l = entitySelector;
    }

    public TrialSpawnerConfig a() {
        return this.n ? this.i.b().a() : this.i.c.a();
    }

    public TrialSpawnerConfig b() {
        return this.i.c.a();
    }

    public TrialSpawnerConfig c() {
        return this.i.d.a();
    }

    public void a(ValueInput input) {
        input.a(TrialSpawnerData.a.a).ifPresent(this.h::a);
        this.i = input.a(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.a).orElse(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.b);
    }

    public void a(ValueOutput output) {
        output.a(TrialSpawnerData.a.a, this.h.a());
        output.a(net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$b.a, this.i);
    }

    public void a(WorldServer level, BlockPosition pos) {
        level.a(pos, (IBlockData)level.a_(pos).b(TrialSpawnerBlock.c, true), 3);
        level.c(3020, pos, 1);
        this.n = true;
        this.h.a(this, level);
    }

    public void b(WorldServer level, BlockPosition pos) {
        level.a(pos, (IBlockData)level.a_(pos).b(TrialSpawnerBlock.c, false), 3);
        this.n = false;
    }

    public boolean d() {
        return this.n;
    }

    public int e() {
        return this.i.e;
    }

    public int f() {
        return this.i.f;
    }

    public TrialSpawnerState g() {
        return this.j.d();
    }

    public TrialSpawnerData h() {
        return this.h;
    }

    public void a(World level, TrialSpawnerState state) {
        this.j.a(level, state);
    }

    public void i() {
        this.j.f();
    }

    public PlayerDetector j() {
        return this.k;
    }

    public PlayerDetector.a k() {
        return this.l;
    }

    public boolean a(WorldServer level) {
        return level.U().a(GameRules.U) != false && (this.m || level.av() != EnumDifficulty.a && level.U().a(GameRules.V) != false);
    }

    public Optional<UUID> c(WorldServer level, BlockPosition pos) {
        Optional<UUID> var24;
        RandomSource random = level.G_();
        MobSpawnerData nextSpawnData = this.h.b(this, level.G_());
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(() -> "spawner@" + String.valueOf(pos), b);){
            Object mob;
            MobSpawnerData.a customSpawnRules;
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)level.J_(), nextSpawnData.d());
            Optional<EntityTypes<?>> optional = EntityTypes.a(valueInput);
            if (optional.isEmpty()) {
                Optional<UUID> optional2 = Optional.empty();
                return optional2;
            }
            Vec3D vec3 = valueInput.a("Pos", Vec3D.a).orElseGet(() -> {
                TrialSpawnerConfig trialSpawnerConfig = this.a();
                return new Vec3D((double)pos.u() + (random.j() - random.j()) * (double)trialSpawnerConfig.c() + 0.5, pos.v() + random.a(3) - 1, (double)pos.w() + (random.j() - random.j()) * (double)trialSpawnerConfig.c() + 0.5);
            });
            if (!level.b(optional.get().a(vec3.g, vec3.h, vec3.i))) {
                Optional<UUID> optional3 = Optional.empty();
                return optional3;
            }
            if (!TrialSpawner.a((World)level, pos.b(), vec3)) {
                Optional<UUID> optional4 = Optional.empty();
                return optional4;
            }
            BlockPosition blockPos = BlockPosition.a(vec3);
            if (!EntityPositionTypes.a(optional.get(), level, EntitySpawnReason.q, blockPos, level.G_())) {
                Optional<UUID> optional5 = Optional.empty();
                return optional5;
            }
            if (nextSpawnData.b().isPresent() && !(customSpawnRules = nextSpawnData.b().get()).a(blockPos, level)) {
                Optional<UUID> optional6 = Optional.empty();
                return optional6;
            }
            Entity entity = EntityTypes.a(valueInput, (World)level, EntitySpawnReason.q, (Entity entity1) -> {
                entity1.b(vec3.g, vec3.h, vec3.i, random.i() * 360.0f, 0.0f);
                return entity1;
            });
            if (entity == null) {
                Optional<UUID> optional7 = Optional.empty();
                return optional7;
            }
            if (entity instanceof EntityInsentient) {
                boolean flag;
                mob = (EntityInsentient)entity;
                if (!((EntityInsentient)mob).a((IWorldReader)level)) {
                    Optional<UUID> optional8 = Optional.empty();
                    return optional8;
                }
                boolean bl = flag = nextSpawnData.a().i() == 1 && nextSpawnData.a().i("id").isPresent();
                if (flag) {
                    ((EntityInsentient)mob).a((WorldAccess)level, level.c(((Entity)mob).dK()), EntitySpawnReason.q, null);
                }
                ((EntityInsentient)mob).gz();
                nextSpawnData.c().ifPresent(arg_0 -> mob.a(arg_0));
            }
            entity.spawnedViaMobSpawner = true;
            entity.spawnReason = CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER;
            if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, pos).isCancelled()) {
                mob = Optional.empty();
                return mob;
            }
            if (!level.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
                mob = Optional.empty();
                return mob;
            }
            a flameParticle = this.n ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
            level.c(3011, pos, flameParticle.a());
            level.c(3012, blockPos, flameParticle.a());
            level.a(entity, GameEvent.t, blockPos);
            var24 = Optional.of(entity.cY());
        }
        return var24;
    }

    public void a(WorldServer level, BlockPosition pos, ResourceKey<LootTable> lootTable) {
        LootTable lootTable1;
        LootTable sourceLootTable = lootTable1 = level.s().be().a(lootTable);
        LootParams lootParams = new LootParams.a(level).a(LootContextParameterSets.b);
        ObjectArrayList randomItems = lootTable1.a(lootParams);
        if (!randomItems.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(level, pos, null, randomItems, sourceLootTable);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            randomItems = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemStack : randomItems) {
                DispenseBehaviorItem.a(level, itemStack, 2, EnumDirection.b, Vec3D.c(pos).a(EnumDirection.b, 1.2));
            }
            level.c(3014, pos, 0);
        }
    }

    public void a(World level, BlockPosition pos, boolean isOminous) {
        RandomSource random;
        TrialSpawnerState state = this.g();
        state.a(level, pos, isOminous);
        if (state.d()) {
            double d2 = Math.max(0L, this.h.d - level.au());
            this.h.i = this.h.h;
            this.h.h = (this.h.h + state.b() / (d2 + 200.0)) % 360.0;
        }
        if (state.e() && (random = level.G_()).i() <= 0.02f) {
            SoundEffect soundEvent = isOminous ? SoundEffects.od : SoundEffects.oc;
            level.a(pos, soundEvent, SoundCategory.e, random.i() * 0.25f + 0.75f, random.i() + 0.5f, false);
        }
    }

    public void a(WorldServer level, BlockPosition pos, boolean isOminous) {
        TrialSpawnerState trialSpawnerState;
        this.n = isOminous;
        TrialSpawnerState state = this.g();
        if (this.h.b.removeIf(mob -> TrialSpawner.a(level, pos, mob))) {
            this.h.d = level.au() + (long)this.a().h();
        }
        if ((trialSpawnerState = state.a(pos, this, level)) != state) {
            this.a((World)level, trialSpawnerState);
        }
    }

    private static boolean a(WorldServer level, BlockPosition pos, UUID uuid) {
        Entity entity = level.d(uuid);
        return entity == null || !entity.cb() || !entity.ao().aq().equals(level.aq()) || entity.dK().j(pos) > (double)f;
    }

    private static boolean a(World level, Vec3D spawnerPos, Vec3D mobPos) {
        MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(mobPos, spawnerPos, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return blockHitResult.b().equals(BlockPosition.a(spawnerPos)) || blockHitResult.d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World level, BlockPosition pos, RandomSource random, ParticleType particleType) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d22 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            level.a(Particles.ai, d2, d1, d22, 0.0, 0.0, 0.0);
            level.a(particleType, d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World level, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d22 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            level.a(Particles.bi, d2, d1, d22, d3, d4, d5);
            level.a(Particles.O, d2, d1, d22, d3, d4, d5);
        }
    }

    public static void a(World level, BlockPosition pos, RandomSource random, int type, ParticleParam particle) {
        for (int i2 = 0; i2 < 30 + Math.min(type, 10) * 5; ++i2) {
            double d2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d22 = (double)pos.u() + 0.5 + d2;
            double d3 = (double)pos.v() + 0.1 + (double)random.i() * 0.8;
            double d4 = (double)pos.w() + 0.5 + d1;
            level.a(particle, d22, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World level, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.4 + random.j() * 0.2;
            double d1 = (double)pos.v() + 0.4 + random.j() * 0.2;
            double d22 = (double)pos.w() + 0.4 + random.j() * 0.2;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            level.a(Particles.aN, d2, d1, d22, d3, d4, d5 * 0.25);
            level.a(Particles.ai, d2, d1, d22, d3, d4, d5);
        }
    }

    public void a(EntityTypes<?> entityType, World level) {
        this.h.b();
        this.i = this.i.a(entityType);
        this.a(level, TrialSpawnerState.a);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector playerDetector) {
        this.k = playerDetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void l() {
        this.m = true;
    }

    public static final class b
    extends Record {
        private final Holder<TrialSpawnerConfig> c;
        private final Holder<TrialSpawnerConfig> d;
        private final int e;
        private final int f;
        public static final MapCodec<b> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.c.optionalFieldOf("normal_config", Holder.a(TrialSpawnerConfig.a)).forGetter(b::a), (App)TrialSpawnerConfig.c.optionalFieldOf("ominous_config", Holder.a(TrialSpawnerConfig.a)).forGetter(b::b), (App)ExtraCodecs.q.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(b::c), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(b::d)).apply((Applicative)instance, b::new));
        public static final b b = new b(Holder.a(TrialSpawnerConfig.a), Holder.a(TrialSpawnerConfig.a), 36000, 14);

        public b(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous, int targetCooldownLength, int requiredPlayerRange) {
            this.c = normal;
            this.d = ominous;
            this.e = targetCooldownLength;
            this.f = requiredPlayerRange;
        }

        public b a(EntityTypes<?> entity) {
            return new b(Holder.a(this.c.a().a(entity)), Holder.a(this.d.a().a(entity)), this.e, this.f);
        }

        public b overrideTargetCooldownLength(int targetCooldownLength) {
            return new b(this.c, this.d, targetCooldownLength, this.f);
        }

        public b overrideRequiredPlayerRange(int requiredPlayerRange) {
            return new b(this.c, this.d, this.e, requiredPlayerRange);
        }

        public b overrideConfigs(Holder<TrialSpawnerConfig> normal, Holder<TrialSpawnerConfig> ominous) {
            return new b(normal, ominous, this.e, this.f);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "c", "d", "e", "f"}, this, o2);
        }

        public Holder<TrialSpawnerConfig> a() {
            return this.c;
        }

        public Holder<TrialSpawnerConfig> b() {
            return this.d;
        }

        public int c() {
            return this.e;
        }

        public int d() {
            return this.f;
        }
    }

    public static interface c {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(Particles.G);
        public static final /* enum */ a b = new a(Particles.O);
        public final ParticleType c;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(ParticleType particleType) {
            this.c = particleType;
        }

        public static a a(int id) {
            a[] flameParticles = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            return id <= flameParticles.length && id >= 0 ? flameParticles[id] : a;
        }

        public int a() {
            return this.ordinal();
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b};
        }

        static {
            d = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b();
        }
    }
}

