/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.bukkit.TreeType;
import org.jspecify.annotations.Nullable;

public final class WorldGenTreeProvider {
    private static final Map<String, WorldGenTreeProvider> l = new Object2ObjectArrayMap();
    public static final Codec<WorldGenTreeProvider> a = Codec.stringResolver(treeGrower -> treeGrower.m, l::get);
    public static final WorldGenTreeProvider b = new WorldGenTreeProvider("oak", 0.1f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.g), Optional.of(TreeFeatures.q), Optional.of(TreeFeatures.F), Optional.of(TreeFeatures.M));
    public static final WorldGenTreeProvider c = new WorldGenTreeProvider("spruce", 0.5f, Optional.of(TreeFeatures.t), Optional.of(TreeFeatures.u), Optional.of(TreeFeatures.n), Optional.empty(), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider d = new WorldGenTreeProvider("mangrove", 0.85f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.A), Optional.of(TreeFeatures.B), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider e = new WorldGenTreeProvider("azalea", Optional.empty(), Optional.of(TreeFeatures.z), Optional.empty());
    public static final WorldGenTreeProvider f = new WorldGenTreeProvider("birch", Optional.empty(), Optional.of(TreeFeatures.l), Optional.of(TreeFeatures.J));
    public static final WorldGenTreeProvider g = new WorldGenTreeProvider("jungle", Optional.of(TreeFeatures.s), Optional.of(TreeFeatures.r), Optional.empty());
    public static final WorldGenTreeProvider h = new WorldGenTreeProvider("acacia", Optional.empty(), Optional.of(TreeFeatures.m), Optional.empty());
    public static final WorldGenTreeProvider i = new WorldGenTreeProvider("cherry", Optional.empty(), Optional.of(TreeFeatures.C), Optional.of(TreeFeatures.O));
    public static final WorldGenTreeProvider j = new WorldGenTreeProvider("dark_oak", Optional.of(TreeFeatures.h), Optional.empty(), Optional.empty());
    public static final WorldGenTreeProvider k = new WorldGenTreeProvider("pale_oak", Optional.of(TreeFeatures.j), Optional.empty(), Optional.empty());
    private final String m;
    private final float n;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> o;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> p;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> q;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> r;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> s;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> t;

    public WorldGenTreeProvider(String name, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> megaTree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> tree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> flowers) {
        this(name, 0.0f, megaTree, Optional.empty(), tree, Optional.empty(), flowers, Optional.empty());
    }

    public WorldGenTreeProvider(String name, float secondaryChance, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> megaTree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryMegaTree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> tree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryTree, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> flowers, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> secondaryFlowers) {
        this.m = name;
        this.n = secondaryChance;
        this.o = megaTree;
        this.p = secondaryMegaTree;
        this.q = tree;
        this.r = secondaryTree;
        this.s = flowers;
        this.t = secondaryFlowers;
        l.put(name, this);
    }

    private @Nullable ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource random, boolean flowers) {
        if (random.i() < this.n) {
            if (flowers && this.t.isPresent()) {
                return this.t.get();
            }
            if (this.r.isPresent()) {
                return this.r.get();
            }
        }
        return flowers && this.s.isPresent() ? this.s.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.q.orElse(null);
    }

    private @Nullable ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource random) {
        return this.p.isPresent() && random.i() < this.n ? this.p.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.o.orElse(null);
    }

    public boolean a(WorldServer level, ChunkGenerator chunkGenerator, BlockPosition pos, IBlockData state, RandomSource random) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> configuredFeature1;
        Holder holder;
        ResourceKey<WorldGenFeatureConfigured<?, ?>> configuredMegaFeature = this.a(random);
        if (configuredMegaFeature != null && (holder = (Holder)level.J_().f(Registries.aY).a(configuredMegaFeature).orElse(null)) != null) {
            this.setTreeType(holder);
            for (int i2 = 0; i2 >= -1; --i2) {
                for (int i1 = 0; i1 >= -1; --i1) {
                    if (!WorldGenTreeProvider.a(state, level, pos, i2, i1)) continue;
                    WorldGenFeatureConfigured configuredFeature = (WorldGenFeatureConfigured)holder.a();
                    IBlockData blockState = Blocks.a.m();
                    level.a(pos.b(i2, 0, i1), blockState, 260);
                    level.a(pos.b(i2 + 1, 0, i1), blockState, 260);
                    level.a(pos.b(i2, 0, i1 + 1), blockState, 260);
                    level.a(pos.b(i2 + 1, 0, i1 + 1), blockState, 260);
                    if (configuredFeature.a(level, chunkGenerator, random, pos.b(i2, 0, i1))) {
                        return true;
                    }
                    level.a(pos.b(i2, 0, i1), state, 260);
                    level.a(pos.b(i2 + 1, 0, i1), state, 260);
                    level.a(pos.b(i2, 0, i1 + 1), state, 260);
                    level.a(pos.b(i2 + 1, 0, i1 + 1), state, 260);
                    return false;
                }
            }
        }
        if ((configuredFeature1 = this.a(random, this.a(level, pos))) == null) {
            return false;
        }
        Holder holder1 = level.J_().f(Registries.aY).a(configuredFeature1).orElse(null);
        if (holder1 == null) {
            return false;
        }
        this.setTreeType(holder1);
        WorldGenFeatureConfigured configuredFeature2 = (WorldGenFeatureConfigured)holder1.a();
        IBlockData blockState1 = level.b_(pos).g();
        level.a(pos, blockState1, 260);
        if (configuredFeature2.a(level, chunkGenerator, random, pos)) {
            if (level.a_(pos) == blockState1) {
                level.a(pos, state, blockState1, 2);
            }
            return true;
        }
        level.a(pos, state, 260);
        return false;
    }

    private static boolean a(IBlockData state, IBlockAccess level, BlockPosition pos, int xOffset, int yOffset) {
        Block block = state.b();
        return level.a_(pos.b(xOffset, 0, yOffset)).a(block) && level.a_(pos.b(xOffset + 1, 0, yOffset)).a(block) && level.a_(pos.b(xOffset, 0, yOffset + 1)).a(block) && level.a_(pos.b(xOffset + 1, 0, yOffset + 1)).a(block);
    }

    private boolean a(GeneratorAccess level, BlockPosition pos) {
        for (BlockPosition blockPos : BlockPosition.MutableBlockPosition.c(pos.e().d(2).f(2), pos.d().e(2).g(2))) {
            if (!level.a_(blockPos).a(TagsBlock.Q)) continue;
            return true;
        }
        return false;
    }

    private void setTreeType(Holder<WorldGenFeatureConfigured<?, ?>> feature) {
        if (feature.a(TreeFeatures.g) || feature.a(TreeFeatures.F)) {
            BlockSapling.treeType = TreeType.TREE;
        } else if (feature.a(TreeFeatures.f)) {
            BlockSapling.treeType = TreeType.RED_MUSHROOM;
        } else if (feature.a(TreeFeatures.e)) {
            BlockSapling.treeType = TreeType.BROWN_MUSHROOM;
        } else if (feature.a(TreeFeatures.p)) {
            BlockSapling.treeType = TreeType.COCOA_TREE;
        } else if (feature.a(TreeFeatures.r)) {
            BlockSapling.treeType = TreeType.SMALL_JUNGLE;
        } else if (feature.a(TreeFeatures.o)) {
            BlockSapling.treeType = TreeType.TALL_REDWOOD;
        } else if (feature.a(TreeFeatures.n)) {
            BlockSapling.treeType = TreeType.REDWOOD;
        } else if (feature.a(TreeFeatures.m)) {
            BlockSapling.treeType = TreeType.ACACIA;
        } else if (feature.a(TreeFeatures.l) || feature.a(TreeFeatures.J)) {
            BlockSapling.treeType = TreeType.BIRCH;
        } else if (feature.a(TreeFeatures.v)) {
            BlockSapling.treeType = TreeType.TALL_BIRCH;
        } else if (feature.a(TreeFeatures.x)) {
            BlockSapling.treeType = TreeType.SWAMP;
        } else if (feature.a(TreeFeatures.q) || feature.a(TreeFeatures.M)) {
            BlockSapling.treeType = TreeType.BIG_TREE;
        } else if (feature.a(TreeFeatures.y)) {
            BlockSapling.treeType = TreeType.JUNGLE_BUSH;
        } else if (feature.a(TreeFeatures.h)) {
            BlockSapling.treeType = TreeType.DARK_OAK;
        } else if (feature.a(TreeFeatures.t)) {
            BlockSapling.treeType = TreeType.MEGA_REDWOOD;
        } else if (feature.a(TreeFeatures.u)) {
            BlockSapling.treeType = TreeType.MEGA_PINE;
        } else if (feature.a(TreeFeatures.s)) {
            BlockSapling.treeType = TreeType.JUNGLE;
        } else if (feature.a(TreeFeatures.z)) {
            BlockSapling.treeType = TreeType.AZALEA;
        } else if (feature.a(TreeFeatures.A)) {
            BlockSapling.treeType = TreeType.MANGROVE;
        } else if (feature.a(TreeFeatures.B)) {
            BlockSapling.treeType = TreeType.TALL_MANGROVE;
        } else if (feature.a(TreeFeatures.C) || feature.a(TreeFeatures.O)) {
            BlockSapling.treeType = TreeType.CHERRY;
        } else if (feature.a(TreeFeatures.i) || feature.a(TreeFeatures.j)) {
            BlockSapling.treeType = TreeType.PALE_OAK;
        } else if (feature.a(TreeFeatures.k)) {
            BlockSapling.treeType = TreeType.PALE_OAK_CREAKING;
        } else {
            throw new IllegalArgumentException("Unknown tree generator " + String.valueOf(feature));
        }
    }
}

