/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.jspecify.annotations.Nullable;

public class BlockStateList<O, S extends IBlockDataHolder<O, S>> {
    static final Pattern a = Pattern.compile("^[a-z0-9_]+$");
    private final O b;
    private final ImmutableSortedMap<String, IBlockState<?>> c;
    private final ImmutableList<S> d;

    protected BlockStateList(Function<O, S> stateValueFunction, O owner, b<O, S> valueFunction, Map<String, IBlockState<?>> propertiesByName) {
        this.b = owner;
        this.c = ImmutableSortedMap.copyOf(propertiesByName);
        Supplier<IBlockDataHolder> supplier = () -> (IBlockDataHolder)stateValueFunction.apply(owner);
        MapCodec<IBlockDataHolder> mapCodec = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(supplier));
        for (Map.Entry entry : this.c.entrySet()) {
            mapCodec = BlockStateList.a(mapCodec, supplier, (String)entry.getKey(), (IBlockState)entry.getValue());
        }
        MapCodec<IBlockDataHolder> mapCodec1 = mapCodec;
        LinkedHashMap map = Maps.newLinkedHashMap();
        ArrayList list = Lists.newArrayList();
        Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
        for (IBlockState property : this.c.values()) {
            stream = stream.flatMap(list1 -> property.a().stream().map(value -> {
                ArrayList list2 = Lists.newArrayList((Iterable)list1);
                list2.add(Pair.of((Object)property, (Object)value));
                return list2;
            }));
        }
        stream.forEach(list1 -> {
            Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(list1.size());
            for (Pair pair : list1) {
                map1.put((Object)((IBlockState)pair.getFirst()), (Object)((Comparable)pair.getSecond()));
            }
            IBlockDataHolder stateHolder1 = (IBlockDataHolder)valueFunction.create(owner, map1, mapCodec1);
            map.put(map1, stateHolder1);
            list.add(stateHolder1);
        });
        for (IBlockDataHolder stateHolder : list) {
            stateHolder.a(map);
        }
        this.d = ImmutableList.copyOf((Collection)list);
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> MapCodec<S> a(MapCodec<S> propertyCodec, Supplier<S> holderSupplier, String value, IBlockState<T> property) {
        return Codec.mapPair(propertyCodec, (MapCodec)property.e().fieldOf(value).orElseGet(elseValue -> {}, () -> property.a((IBlockDataHolder)holderSupplier.get()))).xmap(holder -> (IBlockDataHolder)((IBlockDataHolder)holder.getFirst()).b(property, ((IBlockState.a)holder.getSecond()).b()), holder -> Pair.of((Object)holder, property.a((IBlockDataHolder<?, ?>)holder)));
    }

    public ImmutableList<S> a() {
        return this.d;
    }

    public S b() {
        return (S)((IBlockDataHolder)this.d.get(0));
    }

    public O c() {
        return this.b;
    }

    public Collection<IBlockState<?>> d() {
        return this.c.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.b).add("properties", this.c.values().stream().map(IBlockState::f).collect(Collectors.toList())).toString();
    }

    public @Nullable IBlockState<?> a(String propertyName) {
        return (IBlockState)this.c.get((Object)propertyName);
    }

    public static interface b<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class a<O, S extends IBlockDataHolder<O, S>> {
        private final O a;
        private final Map<String, IBlockState<?>> b = Maps.newHashMap();

        public a(O owner) {
            this.a = owner;
        }

        public a<O, S> a(IBlockState<?> ... properties) {
            for (IBlockState<?> property : properties) {
                this.a((IBlockState<T>)property);
                this.b.put(property.f(), property);
            }
            return this;
        }

        private <T extends Comparable<T>> void a(IBlockState<T> property) {
            String name = property.f();
            if (!a.matcher(name).matches()) {
                throw new IllegalArgumentException(String.valueOf(this.a) + " has invalidly named property: " + name);
            }
            List<T> possibleValues = property.a();
            if (possibleValues.size() <= 1) {
                throw new IllegalArgumentException(String.valueOf(this.a) + " attempted use property " + name + " with <= 1 possible values");
            }
            for (Comparable comparable : possibleValues) {
                String name1 = property.b(comparable);
                if (a.matcher(name1).matches()) continue;
                throw new IllegalArgumentException(String.valueOf(this.a) + " has property: " + name + " with invalidly named value: " + name1);
            }
            if (this.b.containsKey(name)) {
                throw new IllegalArgumentException(String.valueOf(this.a) + " has duplicate property: " + name);
            }
        }

        public BlockStateList<O, S> a(Function<O, S> stateValueFunction, b<O, S> stateFunction) {
            return new BlockStateList<O, S>(stateValueFunction, this.a, stateFunction, this.b);
        }
    }
}

