/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class ShapeDetectorBuilder {
    private final List<String[]> a = Lists.newArrayList();
    private final Map<Character, Predicate<@Nullable ShapeDetectorBlock>> b = Maps.newHashMap();
    private int c;
    private int d;
    private final CharSet e = new CharOpenHashSet();

    private ShapeDetectorBuilder() {
        this.b.put(Character.valueOf(' '), blockInWorld -> true);
    }

    public ShapeDetectorBuilder a(String ... aisle) {
        if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
            if (this.a.isEmpty()) {
                this.c = aisle.length;
                this.d = aisle[0].length();
            }
            if (aisle.length != this.c) {
                throw new IllegalArgumentException("Expected aisle with height of " + this.c + ", but was given one with a height of " + aisle.length + ")");
            }
            for (String string : aisle) {
                if (string.length() != this.d) {
                    throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.d + ", found one with " + string.length() + ")");
                }
                for (char c2 : string.toCharArray()) {
                    if (this.b.containsKey(Character.valueOf(c2))) continue;
                    this.e.add(c2);
                }
            }
            this.a.add(aisle);
            return this;
        }
        throw new IllegalArgumentException("Empty pattern for aisle");
    }

    public static ShapeDetectorBuilder a() {
        return new ShapeDetectorBuilder();
    }

    public ShapeDetectorBuilder a(char symbol, Predicate<@Nullable ShapeDetectorBlock> blockMatcher) {
        this.b.put(Character.valueOf(symbol), blockMatcher);
        this.e.remove(symbol);
        return this;
    }

    public ShapeDetector b() {
        return new ShapeDetector(this.c());
    }

    private Predicate<ShapeDetectorBlock>[][][] c() {
        if (!this.e.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + String.valueOf(this.e) + " are missing");
        }
        Predicate[][][] predicates = (Predicate[][][])Array.newInstance(Predicate.class, this.a.size(), this.c, this.d);
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            for (int i1 = 0; i1 < this.c; ++i1) {
                for (int i22 = 0; i22 < this.d; ++i22) {
                    predicates[i2][i1][i22] = this.b.get(Character.valueOf(this.a.get(i2)[i1].charAt(i22)));
                }
            }
        }
        return predicates;
    }
}

