/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.Nullable;

public class WorldBorder
extends PersistentBase {
    public static final double a = 5.9999968E7;
    public static final double b = 2.9999984E7;
    public static final Codec<WorldBorder> c = net.minecraft.world.level.border.WorldBorder$c.b.xmap(WorldBorder::new, c::new);
    public static final SavedDataType<WorldBorder> d = new SavedDataType<WorldBorder>("world_border", WorldBorder::new, c, DataFixTypes.r);
    private final c e;
    private boolean f;
    private final List<IWorldBorderListener> g = Lists.newArrayList();
    double h = 0.2;
    double i = 5.0;
    int j = 15;
    int k = 5;
    double l;
    double m;
    int n = 29999984;
    a o = new d(5.9999968E7);
    public @Nullable WorldServer world;
    private int lastTick = -1;
    private final BlockPosition.MutableBlockPosition mutPos = new BlockPosition.MutableBlockPosition();

    public WorldBorder() {
        this(net.minecraft.world.level.border.WorldBorder$c.a);
    }

    public WorldBorder(c settings) {
        this.e = settings;
    }

    public boolean a(BlockPosition pos) {
        return this.a(pos.u(), pos.w());
    }

    public boolean a(Vec3D pos) {
        return this.a(pos.g, pos.i);
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        return this.a(chunkPos.e(), chunkPos.f()) && this.a(chunkPos.g(), chunkPos.h());
    }

    public boolean isBlockInBounds(int x2, int z2) {
        this.mutPos.d(x2, 64, z2);
        return this.a(this.mutPos);
    }

    public boolean isChunkInBounds(int chunkX, int chunkZ) {
        this.mutPos.d((chunkX << 4) + 15, 64, (chunkZ << 4) + 15);
        return this.a(this.mutPos);
    }

    public boolean a(AxisAlignedBB box) {
        return this.a(box.a, box.c, box.d - (double)1.0E-5f, box.f - (double)1.0E-5f);
    }

    private boolean a(double x1, double z1, double x2, double z2) {
        return this.a(x1, z1) && this.a(x2, z2);
    }

    public boolean a(double x2, double z2) {
        return this.a(x2, z2, 0.0);
    }

    public boolean a(double x2, double z2, double offset) {
        return x2 >= this.d() - offset && x2 < this.f() + offset && z2 >= this.e() - offset && z2 < this.g() + offset;
    }

    public BlockPosition b(BlockPosition pos) {
        return this.b(pos.u(), pos.v(), pos.w());
    }

    public BlockPosition b(Vec3D pos) {
        return this.b(pos.a(), pos.b(), pos.c());
    }

    public BlockPosition b(double x2, double y2, double z2) {
        return BlockPosition.a(this.c(x2, y2, z2));
    }

    public Vec3D c(Vec3D vec3) {
        return this.c(vec3.g, vec3.h, vec3.i);
    }

    public Vec3D c(double x2, double y2, double z2) {
        return new Vec3D(MathHelper.a(x2, this.d(), this.f() - (double)1.0E-5f), y2, MathHelper.a(z2, this.e(), this.g() - (double)1.0E-5f));
    }

    public double a(Entity entity) {
        return this.b(entity.dP(), entity.dV());
    }

    public VoxelShape b() {
        return this.o.i();
    }

    public double b(double x2, double z2) {
        double d2 = z2 - this.e();
        double d1 = this.g() - z2;
        double d22 = x2 - this.d();
        double d3 = this.f() - x2;
        double min = Math.min(d22, d3);
        min = Math.min(min, d2);
        return Math.min(min, d1);
    }

    public boolean a(Entity entity, AxisAlignedBB bounds) {
        double max = Math.max(MathHelper.a(bounds.b(), bounds.d()), 1.0);
        return this.a(entity) < max * 2.0 && this.a(entity.dP(), entity.dV(), max);
    }

    public BorderStatus c() {
        return this.o.e();
    }

    public double d() {
        return this.a(0.0f);
    }

    public double a(float partialTick) {
        return this.o.a(partialTick);
    }

    public double e() {
        return this.b(0.0f);
    }

    public double b(float partialTick) {
        return this.o.c(partialTick);
    }

    public double f() {
        return this.c(0.0f);
    }

    public double c(float partialTick) {
        return this.o.b(partialTick);
    }

    public double g() {
        return this.d(0.0f);
    }

    public double d(float partialTick) {
        return this.o.d(partialTick);
    }

    public double h() {
        return this.l;
    }

    public double i() {
        return this.m;
    }

    public void c(double x2, double z2) {
        if (this.world != null) {
            WorldBorderCenterChangeEvent event = new WorldBorderCenterChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), new Location((World)this.world.getWorld(), this.h(), 0.0, this.i()), new Location((World)this.world.getWorld(), x2, 0.0, z2));
            if (!event.callEvent()) {
                return;
            }
            x2 = event.getNewCenter().getX();
            z2 = event.getNewCenter().getZ();
        }
        this.l = x2;
        this.m = z2;
        this.o.g();
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.a(this, x2, z2);
        }
    }

    public double j() {
        return this.o.a();
    }

    public long k() {
        return this.o.c();
    }

    public double l() {
        return this.o.d();
    }

    public void a(double size) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE, this.j(), size, 0L);
            if (!event.callEvent()) {
                return;
            }
            if (event.getType() == WorldBorderBoundsChangeEvent.Type.STARTED_MOVE && event.getDurationTicks() > 0L) {
                this.a(event.getOldSize(), event.getNewSize(), event.getDurationTicks(), this.world.au());
                return;
            }
            size = event.getNewSize();
        }
        this.o = new d(size);
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.a(this, size);
        }
    }

    public void a(double oldSize, double newSize, long time, long startTime) {
        if (this.world != null) {
            WorldBorderBoundsChangeEvent.Type type = oldSize == newSize ? WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE : WorldBorderBoundsChangeEvent.Type.STARTED_MOVE;
            WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), type, oldSize, newSize, time);
            if (!event.callEvent()) {
                return;
            }
            newSize = event.getNewSize();
            time = event.getDurationTicks();
        }
        this.o = oldSize == newSize ? new d(newSize) : new b(oldSize, newSize, time, startTime);
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.a(this, oldSize, newSize, time, startTime);
        }
    }

    protected List<IWorldBorderListener> m() {
        return Lists.newArrayList(this.g);
    }

    public void a(IWorldBorderListener listener) {
        if (this.g.contains(listener)) {
            return;
        }
        this.g.add(listener);
    }

    public void b(IWorldBorderListener listener) {
        this.g.remove(listener);
    }

    public void a(int size) {
        this.n = size;
        this.o.f();
    }

    public int n() {
        return this.n;
    }

    public double o() {
        return this.i;
    }

    public void b(double safeZone) {
        this.i = safeZone;
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.c(this, safeZone);
        }
    }

    public double p() {
        return this.h;
    }

    public void c(double damagePerBlock) {
        this.h = damagePerBlock;
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.b(this, damagePerBlock);
        }
    }

    public double q() {
        return this.o.b();
    }

    public int r() {
        return this.j;
    }

    public void b(int warningTime) {
        this.j = warningTime;
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.a(this, warningTime);
        }
    }

    public int s() {
        return this.k;
    }

    public void c(int warningBlocks) {
        this.k = warningBlocks;
        this.u();
        for (IWorldBorderListener borderChangeListener : this.m()) {
            borderChangeListener.b(this, warningBlocks);
        }
    }

    public void t() {
        if (this.lastTick == MinecraftServer.currentTick) {
            return;
        }
        this.lastTick = MinecraftServer.currentTick;
        this.o = this.o.h();
    }

    public void a(long lerpBegin) {
        if (!this.f) {
            this.c(this.e.a(), this.e.b());
            this.c(this.e.c());
            this.b(this.e.d());
            this.c(this.e.e());
            this.b(this.e.f());
            if (this.e.h() > 0L) {
                this.a(this.e.g(), this.e.i(), this.e.h(), lerpBegin);
            } else {
                this.a(this.e.g());
            }
            this.f = true;
        }
    }

    public void applySettings(c settings) {
        this.c(settings.a(), settings.b());
        this.c(settings.c());
        this.b(settings.d());
        this.c(settings.e());
        this.b(settings.f());
        if (settings.h() > 0L) {
            long startTime = this.world != null ? this.world.au() : 0L;
            this.a(settings.g(), settings.i(), settings.h(), startTime);
        } else {
            this.a(settings.g());
        }
    }

    public static final class c
    extends Record {
        private final double c;
        private final double d;
        private final double e;
        private final double f;
        private final int g;
        private final int h;
        private final double i;
        private final long j;
        private final double k;
        public static final c a = new c(0.0, 0.0, 0.2, 5.0, 5, 300, 5.9999968E7, 0L, 0.0);
        public static final Codec<c> b = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_x").forGetter(c::a), (App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_z").forGetter(c::b), (App)Codec.DOUBLE.fieldOf("damage_per_block").forGetter(c::c), (App)Codec.DOUBLE.fieldOf("safe_zone").forGetter(c::d), (App)Codec.INT.fieldOf("warning_blocks").forGetter(c::e), (App)Codec.INT.fieldOf("warning_time").forGetter(c::f), (App)Codec.DOUBLE.fieldOf("size").forGetter(c::g), (App)Codec.LONG.fieldOf("lerp_time").forGetter(c::h), (App)Codec.DOUBLE.fieldOf("lerp_target").forGetter(c::i)).apply((Applicative)instance, c::new));

        public c(WorldBorder border) {
            this(border.l, border.m, border.h, border.i, border.k, border.j, border.o.a(), border.o.c(), border.o.d());
        }

        public c(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long lerpTime, double lerpTarget) {
            this.c = centerX;
            this.d = centerZ;
            this.e = damagePerBlock;
            this.f = safeZone;
            this.g = warningBlocks;
            this.h = warningTime;
            this.i = size;
            this.j = lerpTime;
            this.k = lerpTarget;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "centerX;centerZ;damagePerBlock;safeZone;warningBlocks;warningTime;size;lerpTime;lerpTarget", "c", "d", "e", "f", "g", "h", "i", "j", "k"}, this, o2);
        }

        public double a() {
            return this.c;
        }

        public double b() {
            return this.d;
        }

        public double c() {
            return this.e;
        }

        public double d() {
            return this.f;
        }

        public int e() {
            return this.g;
        }

        public int f() {
            return this.h;
        }

        public double g() {
            return this.i;
        }

        public long h() {
            return this.j;
        }

        public double i() {
            return this.k;
        }
    }

    class d
    implements a {
        private final double b;
        private double c;
        private double d;
        private double e;
        private double f;
        private VoxelShape g;

        public d(double size) {
            this.b = size;
            this.j();
        }

        @Override
        public double a(float partialTick) {
            return this.c;
        }

        @Override
        public double b(float partialTick) {
            return this.e;
        }

        @Override
        public double c(float partialTick) {
            return this.d;
        }

        @Override
        public double d(float partialTick) {
            return this.f;
        }

        @Override
        public double a() {
            return this.b;
        }

        @Override
        public BorderStatus e() {
            return BorderStatus.c;
        }

        @Override
        public double b() {
            return 0.0;
        }

        @Override
        public long c() {
            return 0L;
        }

        @Override
        public double d() {
            return this.b;
        }

        private void j() {
            this.c = MathHelper.a(WorldBorder.this.h() - this.b / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
            this.d = MathHelper.a(WorldBorder.this.i() - this.b / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
            this.e = MathHelper.a(WorldBorder.this.h() + this.b / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
            this.f = MathHelper.a(WorldBorder.this.i() + this.b / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
            this.g = VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a(0.0f)), Double.NEGATIVE_INFINITY, Math.floor(this.c(0.0f)), Math.ceil(this.b(0.0f)), Double.POSITIVE_INFINITY, Math.ceil(this.d(0.0f))), OperatorBoolean.e);
        }

        @Override
        public void f() {
            this.j();
        }

        @Override
        public void g() {
            this.j();
        }

        @Override
        public a h() {
            return this;
        }

        @Override
        public VoxelShape i() {
            return this.g;
        }
    }

    static interface a {
        public double a(float var1);

        public double b(float var1);

        public double c(float var1);

        public double d(float var1);

        public double a();

        public double b();

        public long c();

        public double d();

        public BorderStatus e();

        public void f();

        public void g();

        public a h();

        public VoxelShape i();
    }

    class b
    implements a {
        private final double b;
        private final double c;
        private final long d;
        private final long e;
        private final double f;
        private long g;
        private double h;
        private double i;

        b(double from, double to, long lerpDuration, long lerpBegin) {
            double d2;
            this.b = from;
            this.c = to;
            this.f = lerpDuration;
            this.g = lerpDuration;
            this.e = lerpBegin;
            this.d = this.e + lerpDuration;
            this.h = d2 = this.k();
            this.i = d2;
        }

        @Override
        public double a(float partialTick) {
            return MathHelper.a(WorldBorder.this.h() - MathHelper.d((double)partialTick, this.j(), this.a()) / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
        }

        @Override
        public double c(float partialTick) {
            return MathHelper.a(WorldBorder.this.i() - MathHelper.d((double)partialTick, this.j(), this.a()) / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
        }

        @Override
        public double b(float partialTick) {
            return MathHelper.a(WorldBorder.this.h() + MathHelper.d((double)partialTick, this.j(), this.a()) / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
        }

        @Override
        public double d(float partialTick) {
            return MathHelper.a(WorldBorder.this.i() + MathHelper.d((double)partialTick, this.j(), this.a()) / 2.0, (double)(-WorldBorder.this.n), (double)WorldBorder.this.n);
        }

        @Override
        public double a() {
            return this.h;
        }

        public double j() {
            return this.i;
        }

        private double k() {
            double d2 = (this.f - (double)this.g) / this.f;
            return d2 < 1.0 ? MathHelper.d(d2, this.b, this.c) : this.c;
        }

        @Override
        public double b() {
            return Math.abs(this.b - this.c) / (double)(this.d - this.e);
        }

        @Override
        public long c() {
            return this.g;
        }

        @Override
        public double d() {
            return this.c;
        }

        @Override
        public BorderStatus e() {
            return this.c < this.b ? BorderStatus.b : BorderStatus.a;
        }

        @Override
        public void g() {
        }

        @Override
        public void f() {
        }

        @Override
        public a h() {
            --this.g;
            this.i = this.h;
            this.h = this.k();
            if (this.g <= 0L) {
                if (WorldBorder.this.world != null) {
                    new WorldBorderBoundsChangeFinishEvent((World)WorldBorder.this.world.getWorld(), WorldBorder.this.world.getWorld().getWorldBorder(), this.b, this.c, this.f).callEvent();
                }
                WorldBorder.this.u();
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                return worldBorder.new d(this.c);
            }
            return this;
        }

        @Override
        public VoxelShape i() {
            return VoxelShapes.a(VoxelShapes.c, VoxelShapes.a(Math.floor(this.a(0.0f)), Double.NEGATIVE_INFINITY, Math.floor(this.c(0.0f)), Math.ceil(this.b(0.0f)), Double.POSITIVE_INFINITY, Math.ceil(this.d(0.0f))), OperatorBoolean.e);
        }
    }
}

