/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public class ChunkGeneratorStructureState {
    private static final Logger a = LogUtils.getLogger();
    private final RandomState b;
    private final WorldChunkManager c;
    private final long d;
    private final long e;
    private final Map<Structure, List<StructurePlacement>> f = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> g = new Object2ObjectArrayMap();
    private boolean h;
    private final List<Holder<StructureSet>> i;
    public final SpigotWorldConfig conf;

    public static ChunkGeneratorStructureState createForFlat(RandomState randomState, long levelSeed, WorldChunkManager biomeSource, Stream<Holder<StructureSet>> structureSets, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = structureSets.filter(structureSet -> ChunkGeneratorStructureState.a((StructureSet)structureSet.a(), biomeSource)).toList();
        return new ChunkGeneratorStructureState(randomState, biomeSource, levelSeed, 0L, ChunkGeneratorStructureState.injectSpigot(list, conf), conf);
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState randomState, long seed, WorldChunkManager biomeSource, HolderLookup<StructureSet> structureSetLookup, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = structureSetLookup.c().filter(structureSet -> ChunkGeneratorStructureState.a((StructureSet)structureSet.a(), biomeSource)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(randomState, biomeSource, seed, seed, ChunkGeneratorStructureState.injectSpigot(list, conf), conf);
    }

    private static List<Holder<StructureSet>> injectSpigot(List<Holder<StructureSet>> list, SpigotWorldConfig conf) {
        return list.stream().map(holder -> {
            StructureSet structureset = holder.a();
            StructurePlacement patt0$temp = structureset.b();
            if (!(patt0$temp instanceof RandomSpreadStructurePlacement)) return holder;
            RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt0$temp;
            if (!holder.e().orElseThrow().a().b().equals("minecraft")) return holder;
            String name = holder.e().orElseThrow().a().a();
            int seed = randomConfig.f;
            switch (name) {
                case "desert_pyramids": {
                    seed = conf.desertSeed;
                    break;
                }
                case "end_cities": {
                    seed = conf.endCitySeed;
                    break;
                }
                case "nether_complexes": {
                    seed = conf.netherSeed;
                    break;
                }
                case "igloos": {
                    seed = conf.iglooSeed;
                    break;
                }
                case "jungle_temples": {
                    seed = conf.jungleSeed;
                    break;
                }
                case "woodland_mansions": {
                    seed = conf.mansionSeed;
                    break;
                }
                case "ocean_monuments": {
                    seed = conf.monumentSeed;
                    break;
                }
                case "nether_fossils": {
                    seed = conf.fossilSeed;
                    break;
                }
                case "ocean_ruins": {
                    seed = conf.oceanSeed;
                    break;
                }
                case "pillager_outposts": {
                    seed = conf.outpostSeed;
                    break;
                }
                case "ruined_portals": {
                    seed = conf.portalSeed;
                    break;
                }
                case "shipwrecks": {
                    seed = conf.shipwreckSeed;
                    break;
                }
                case "swamp_huts": {
                    seed = conf.swampSeed;
                    break;
                }
                case "villages": {
                    seed = conf.villageSeed;
                    break;
                }
                case "ancient_cities": {
                    seed = conf.ancientCitySeed;
                    break;
                }
                case "trail_ruins": {
                    seed = conf.trailRuinsSeed;
                    break;
                }
                case "trial_chambers": {
                    seed = conf.trialChambersSeed;
                }
            }
            structureset = new StructureSet(structureset.a(), (StructurePlacement)new KeyedRandomSpreadStructurePlacement(holder.e().orElseThrow(), ((StructurePlacement)randomConfig).c, ((StructurePlacement)randomConfig).d, ((StructurePlacement)randomConfig).e, seed, randomConfig.g, randomConfig.a(), randomConfig.b(), randomConfig.c()));
            return Holder.a(structureset);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean a(StructureSet structureSet, WorldChunkManager biomeSource) {
        Stream stream = structureSet.a().stream().flatMap(structureEntry -> {
            Structure structure = structureEntry.a().a();
            return structure.a().a();
        });
        return stream.anyMatch(biomeSource.c()::contains);
    }

    private ChunkGeneratorStructureState(RandomState randomState, WorldChunkManager biomeSource, long levelSeed, long concentricRingsSeed, List<Holder<StructureSet>> possibleStructureSets, SpigotWorldConfig conf) {
        this.b = randomState;
        this.d = levelSeed;
        this.c = biomeSource;
        this.e = concentricRingsSeed;
        this.i = possibleStructureSets;
        this.conf = conf;
    }

    public List<Holder<StructureSet>> a() {
        return this.i;
    }

    private void e() {
        Set<Holder<BiomeBase>> set = this.c.c();
        this.a().forEach(structureSetHolder -> {
            StructurePlacement patt0$temp;
            StructureSet structureSet = (StructureSet)structureSetHolder.a();
            boolean flag = false;
            for (StructureSet.a structureSelectionEntry : structureSet.a()) {
                Structure structure = structureSelectionEntry.a().a();
                if (!structure.a().a().anyMatch(set::contains)) continue;
                this.f.computeIfAbsent(structure, key -> new ArrayList()).add(structureSet.b());
                flag = true;
            }
            if (flag && (patt0$temp = structureSet.b()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)patt0$temp;
                this.g.put(concentricRingsStructurePlacement, this.a((Holder<StructureSet>)structureSetHolder, concentricRingsStructurePlacement));
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> a(Holder<StructureSet> structureSet, ConcentricRingsStructurePlacement placement) {
        if (placement.c() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.d);
        int distance = placement.a();
        int count = placement.c();
        ArrayList<CompletableFuture<ChunkCoordIntPair>> list = new ArrayList<CompletableFuture<ChunkCoordIntPair>>(count);
        int spread = placement.b();
        HolderSet<BiomeBase> holderSet = placement.d();
        RandomSource randomSource = RandomSource.a();
        if (this.conf.strongholdSeed != null && structureSet.a(BuiltinStructureSets.r)) {
            randomSource.b(this.conf.strongholdSeed);
        } else {
            randomSource.b(this.e);
        }
        double d2 = randomSource.j() * Math.PI * 2.0;
        int i2 = 0;
        int i1 = 0;
        for (int i22 = 0; i22 < count; ++i22) {
            double d1 = (double)(4 * distance + distance * i1 * 6) + (randomSource.j() - 0.5) * ((double)distance * 2.5);
            int i3 = (int)Math.round(Math.cos(d2) * d1);
            int i4 = (int)Math.round(Math.sin(d2) * d1);
            RandomSource randomSource1 = randomSource.d();
            list.add(CompletableFuture.supplyAsync(() -> {
                Pair<BlockPosition, Holder<BiomeBase>> pair = this.c.a(SectionPosition.a(i3, 8), 0, SectionPosition.a(i4, 8), 112, holderSet::a, randomSource1, this.b.b());
                if (pair != null) {
                    BlockPosition blockPos = (BlockPosition)pair.getFirst();
                    return new ChunkCoordIntPair(SectionPosition.a(blockPos.u()), SectionPosition.a(blockPos.w()));
                }
                return new ChunkCoordIntPair(i3, i4);
            }, SystemUtils.h().a("structureRings")));
            d2 += Math.PI * 2 / (double)spread;
            if (++i2 != spread) continue;
            i2 = 0;
            spread += 2 * spread / (++i1 + 1);
            spread = Math.min(spread, count - i22);
            d2 += randomSource.j() * Math.PI * 2.0;
        }
        return SystemUtils.c(list).thenApply(completed -> {
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            a.debug("Calculation for {} took {}s", (Object)structureSet, (Object)d2);
            return completed;
        });
    }

    public void b() {
        if (!this.h) {
            this.e();
            this.h = true;
        }
    }

    public @Nullable List<ChunkCoordIntPair> a(ConcentricRingsStructurePlacement placement) {
        this.b();
        CompletableFuture<List<ChunkCoordIntPair>> completableFuture = this.g.get(placement);
        return completableFuture != null ? completableFuture.join() : null;
    }

    public List<StructurePlacement> a(Holder<Structure> structure) {
        this.b();
        return this.f.getOrDefault(structure.a(), List.of());
    }

    public RandomState c() {
        return this.b;
    }

    public boolean a(Holder<StructureSet> structureSet, int x2, int z2, int range) {
        StructurePlacement structurePlacement = structureSet.a().b();
        for (int i2 = x2 - range; i2 <= x2 + range; ++i2) {
            for (int i1 = z2 - range; i1 <= z2 + range; ++i1) {
                ResourceKey<StructureSet> resourceKey;
                if (structurePlacement instanceof KeyedRandomSpreadStructurePlacement) {
                    KeyedRandomSpreadStructurePlacement keyed = (KeyedRandomSpreadStructurePlacement)structurePlacement;
                    resourceKey = keyed.key;
                } else {
                    resourceKey = null;
                }
                if (!structurePlacement.isStructureChunk(this, i2, i1, resourceKey)) continue;
                return true;
            }
        }
        return false;
    }

    public long d() {
        return this.d;
    }

    public static final class KeyedRandomSpreadStructurePlacement
    extends RandomSpreadStructurePlacement {
        public final ResourceKey<StructureSet> key;

        public KeyedRandomSpreadStructurePlacement(ResourceKey<StructureSet> key, BaseBlockPosition locateOffset, StructurePlacement.c frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.a> exclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
            super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
            this.key = key;
        }
    }
}

