/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.DataBits;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.DataPaletteHash;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;
import org.jetbrains.annotations.Nullable;

public class DataPaletteBlock<T>
implements DataPaletteExpandable<T>,
PalettedContainerRO<T> {
    private static final int a = 0;
    public volatile b<T> b;
    private final Strategy<T> c;
    private final T @Nullable [] presetValues;

    public void b() {
    }

    public void c() {
    }

    @Deprecated
    @DoNotUse
    public static <T> Codec<DataPaletteBlock<T>> a(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue) {
        return DataPaletteBlock.codecRW(valueCodec, strategy, defaultValue, null);
    }

    public static <T> Codec<DataPaletteBlock<T>> codecRW(Codec<T> valueCodec, Strategy strategy, T defaultValue, T @Nullable [] presetValues) {
        PalettedContainerRO.b unpacker = (strategy1, packedData) -> DataPaletteBlock.unpack(strategy1, packedData, defaultValue, presetValues);
        return DataPaletteBlock.a(valueCodec, strategy, defaultValue, unpacker);
    }

    public static <T> Codec<PalettedContainerRO<T>> b(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue) {
        PalettedContainerRO.b unpacker = (strategy1, packedData) -> DataPaletteBlock.unpack(strategy1, packedData, defaultValue, null).map(container -> container);
        return DataPaletteBlock.a(valueCodec, strategy, defaultValue, unpacker);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> a(Codec<T> valueCodec, Strategy<T> strategy, T defaultValue, PalettedContainerRO.b<T, C> unpacker) {
        return RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.mapResult(ExtraCodecs.a(defaultValue)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.a::a), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.a::b)).apply((Applicative)instance, PalettedContainerRO.a::new)).comapFlatMap(packedData -> unpacker.read(strategy, (PalettedContainerRO.a)packedData), container -> container.a(strategy));
    }

    private void updateData(b<T> data) {
        if (data != null) {
            ((FastPaletteData)data).moonrise$setPalette(data.c.moonrise$getRawPalette(data));
        }
    }

    private T readPaletteSlow(b<T> data, int paletteIdx) {
        return data.c.a(paletteIdx);
    }

    private T readPalette(b<T> data, int paletteIdx) {
        T[] palette = ((FastPaletteData)data).moonrise$getPalette();
        if (palette == null) {
            return this.readPaletteSlow(data, paletteIdx);
        }
        Object ret = palette[paletteIdx];
        if (ret == null) {
            throw new IllegalArgumentException("Palette index out of bounds");
        }
        return ret;
    }

    private DataPaletteBlock(Strategy<T> strategy, Configuration configuration, DataBits storage, DataPalette<T> palette, List<T> values, T defaultValue, T @Nullable [] presetValues) {
        Configuration.b simpleFactory;
        this.presetValues = presetValues;
        this.c = strategy;
        this.b = new b<T>(configuration, storage, palette);
        if (presetValues != null && (configuration instanceof Configuration.b && (simpleFactory = (Configuration.b)configuration).d() == Strategy.b ? this.b.c.a(0) != defaultValue : !(configuration instanceof Configuration.a))) {
            int maxSize = 1 << configuration.b();
            for (T presetValue : presetValues) {
                if (this.b.c.a() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(values);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = MathHelper.f(allValues.size());
                    if (newBits <= configuration.b()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.b.c.a(presetValue, this);
            }
        }
        this.updateData(this.b);
    }

    private DataPaletteBlock(DataPaletteBlock<T> other, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.c = other.c;
        this.b = other.b.a();
        this.updateData(this.b);
    }

    @Deprecated
    @DoNotUse
    public DataPaletteBlock(T defaultValue, Strategy<T> strategy) {
        this(defaultValue, strategy, null);
    }

    public DataPaletteBlock(T defaultValue, Strategy<T> strategy, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.c = strategy;
        this.b = this.a(null, 0);
        this.b.c.a(defaultValue, this);
        this.updateData(this.b);
    }

    private b<T> a(@org.jspecify.annotations.Nullable b<T> data, int bits) {
        Configuration configurationForBitCount = this.c.a(bits);
        if (data != null && configurationForBitCount.equals(data.b())) {
            return data;
        }
        DataBits bitStorage = configurationForBitCount.b() == 0 ? new ZeroBitStorage(this.c.a()) : new SimpleBitStorage(configurationForBitCount.b(), this.c.a());
        DataPalette<T> palette = configurationForBitCount.a(this.c, List.of());
        return new b<T>(configurationForBitCount, bitStorage, palette);
    }

    @Override
    public synchronized int onResize(int bits, T addedValue) {
        Configuration.b simpleFactory;
        Configuration configuration;
        b<T> data = this.b;
        if (this.presetValues != null && addedValue != null && (configuration = data.b()) instanceof Configuration.b && (simpleFactory = (Configuration.b)configuration).d() == Strategy.b) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(addedValue) ? 1 : 0;
            int n2 = presetValues.contains(data.c.a(0)) ? 1 : 0;
            int size = 1 << this.c.a(bits).b();
            bits = MathHelper.f(size + presetValues.size() - (duplicates += n2));
        }
        b data1 = this.a(data, bits);
        data1.a(data.c, data.b);
        this.b = data1;
        this.updateData(this.b);
        this.addPresetValues();
        return addedValue == null ? -1 : data1.c.a(addedValue, DataPaletteExpandable.a());
    }

    private void addPresetValues() {
        if (this.presetValues != null && !(this.b.b() instanceof Configuration.a)) {
            for (T presetValue : this.presetValues) {
                this.b.c.a(presetValue, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T a(int x2, int y2, int z2, T state) {
        T var5;
        this.b();
        try {
            var5 = this.a(this.c.a(x2, y2, z2), state);
        }
        finally {
            this.c();
        }
        return var5;
    }

    public T b(int x2, int y2, int z2, T state) {
        return this.a(this.c.a(x2, y2, z2), state);
    }

    private T a(int index, T state) {
        int paletteIdx = this.b.c.a(state, this);
        b<T> data = this.b;
        int prev = data.b.a(index, paletteIdx);
        return this.readPalette(data, prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void c(int x2, int y2, int z2, T state) {
        this.b();
        try {
            this.b(this.c.a(x2, y2, z2), state);
        }
        finally {
            this.c();
        }
    }

    private void b(int index, T state) {
        int i2 = this.b.c.a(state, this);
        this.b.b.b(index, i2);
    }

    @Override
    public T a(int x2, int y2, int z2) {
        return this.a(this.c.a(x2, y2, z2));
    }

    public T a(int index) {
        b<T> data = this.b;
        return this.readPalette(data, data.b.a(index));
    }

    @Override
    public void a(Consumer<T> consumer) {
        DataPalette palette = this.b.d();
        IntArraySet set = new IntArraySet();
        this.b.b.a(arg_0 -> ((IntSet)set).add(arg_0));
        set.forEach(id -> consumer.accept(palette.a(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void a(PacketDataSerializer buffer) {
        this.b();
        try {
            byte _byte = buffer.readByte();
            b<T> data = this.a(this.b, _byte);
            data.c.a(buffer, this.c.b());
            buffer.c(data.b.a());
            this.b = data;
            this.addPresetValues();
            this.updateData(this.b);
        }
        finally {
            this.c();
        }
    }

    @Override
    @Deprecated
    @DoNotUse
    public void b(PacketDataSerializer buffer) {
        this.write(buffer, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(PacketDataSerializer buffer, @org.jspecify.annotations.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
        this.b();
        try {
            this.b.write(buffer, this.c.b(), chunkPacketInfo, chunkSectionIndex);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.c();
        }
    }

    @VisibleForTesting
    public static <T> DataResult<DataPaletteBlock<T>> unpack(Strategy<T> strategy, PalettedContainerRO.a<T> packedData, T defaultValue, T @Nullable [] presetValues) {
        DataBits bitStorage;
        DataPalette<T> palette;
        List<T> list = packedData.a();
        int entryCount = strategy.a();
        Configuration configurationForPaletteSize = strategy.b(list.size());
        int i2 = configurationForPaletteSize.c();
        if (packedData.c() != -1 && i2 != packedData.c()) {
            return DataResult.error(() -> "Invalid bit count, calculated " + i2 + ", but container declared " + packedData.c());
        }
        if (configurationForPaletteSize.b() == 0) {
            palette = configurationForPaletteSize.a(strategy, list);
            bitStorage = new ZeroBitStorage(entryCount);
        } else {
            Optional<LongStream> optional = packedData.b();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] longs = optional.get().toArray();
            try {
                if (!configurationForPaletteSize.a() && configurationForPaletteSize.b() == i2) {
                    palette = configurationForPaletteSize.a(strategy, list);
                    bitStorage = new SimpleBitStorage(configurationForPaletteSize.b(), entryCount, longs);
                } else {
                    DataPaletteHash<T> palette1 = new DataPaletteHash<T>(i2, list);
                    SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i2, entryCount, longs);
                    DataPalette<T> palette2 = configurationForPaletteSize.a(strategy, list);
                    int[] ints = DataPaletteBlock.a(simpleBitStorage, palette1, palette2);
                    palette = palette2;
                    bitStorage = new SimpleBitStorage(configurationForPaletteSize.b(), entryCount, ints);
                }
            }
            catch (SimpleBitStorage.a var14) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var14.getMessage());
            }
        }
        return DataResult.success(new DataPaletteBlock<T>(strategy, configurationForPaletteSize, bitStorage, palette, list, defaultValue, presetValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PalettedContainerRO.a<T> a(Strategy<T> strategy) {
        PalettedContainerRO.a var14;
        this.b();
        try {
            Optional<LongStream> optional;
            DataBits bitStorage = this.b.b;
            DataPalette palette = this.b.c;
            DataPaletteHash hashMapPalette = new DataPaletteHash(bitStorage.c());
            int entryCount = strategy.a();
            int[] ints = DataPaletteBlock.a(bitStorage, palette, hashMapPalette);
            Configuration configurationForPaletteSize = strategy.b(hashMapPalette.a());
            int i2 = configurationForPaletteSize.c();
            if (i2 != 0) {
                SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i2, entryCount, ints);
                optional = Optional.of(Arrays.stream(simpleBitStorage.a()));
            } else {
                optional = Optional.empty();
            }
            var14 = new PalettedContainerRO.a(hashMapPalette.c(), optional, i2);
        }
        finally {
            this.c();
        }
        return var14;
    }

    private static <T> int[] a(DataBits bitStorage, DataPalette<T> oldPalette, DataPalette<T> newPalette) {
        int[] ints = new int[bitStorage.b()];
        bitStorage.a(ints);
        DataPaletteExpandable paletteResize = DataPaletteExpandable.a();
        int i2 = -1;
        int i1 = -1;
        for (int i22 = 0; i22 < ints.length; ++i22) {
            int i3 = ints[i22];
            if (i3 != i2) {
                i2 = i3;
                i1 = newPalette.a(oldPalette.a(i3), paletteResize);
            }
            ints[i22] = i1;
        }
        return ints;
    }

    @Override
    public int d() {
        return this.b.a(this.c.b());
    }

    @Override
    public int e() {
        return this.b.c().c();
    }

    @Override
    public boolean a(Predicate<T> predicate) {
        return this.b.c.a(predicate);
    }

    @Override
    public DataPaletteBlock<T> f() {
        return new DataPaletteBlock<T>(this, this.presetValues);
    }

    @Override
    public DataPaletteBlock<T> g() {
        return new DataPaletteBlock(this.b.c.a(0), this.c, this.presetValues);
    }

    @Override
    public void a(a<T> countConsumer) {
        if (this.b.c.a() == 1) {
            countConsumer.accept(this.b.c.a(0), this.b.b.b());
        } else {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            this.b.b.a((int id) -> map.addTo(id, 1));
            map.int2IntEntrySet().forEach(idEntry -> countConsumer.accept(this.b.c.a(idEntry.getIntKey()), idEntry.getIntValue()));
        }
    }

    public static final class b<T>
    implements FastPaletteData<T> {
        private final Configuration a;
        private final DataBits b;
        private final DataPalette<T> c;
        private T[] moonrise$palette;

        public b(Configuration configuration, DataBits storage, DataPalette<T> palette) {
            this.a = configuration;
            this.b = storage;
            this.c = palette;
        }

        public Configuration b() {
            return this.a;
        }

        public DataBits c() {
            return this.b;
        }

        public DataPalette<T> d() {
            return this.c;
        }

        @Override
        public final T[] moonrise$getPalette() {
            return this.moonrise$palette;
        }

        @Override
        public final void moonrise$setPalette(T[] palette) {
            this.moonrise$palette = palette;
        }

        public void a(DataPalette<T> palette, DataBits bitStorage) {
            DataPaletteExpandable paletteResize = DataPaletteExpandable.a();
            for (int i2 = 0; i2 < bitStorage.b(); ++i2) {
                T object = palette.a(bitStorage.a(i2));
                this.b.b(i2, this.c.a(object, paletteResize));
            }
        }

        public int a(Registry<T> map) {
            return 1 + this.c.a(map) + this.b.a().length * 8;
        }

        public void write(PacketDataSerializer buffer, Registry<T> map, @org.jspecify.annotations.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
            buffer.l(this.b.c());
            this.c.b(buffer, map);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setBits(chunkSectionIndex, this.a.b());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.c);
                chunkPacketInfo.setIndex(chunkSectionIndex, buffer.writerIndex());
            }
            buffer.b(this.b.a());
        }

        public b<T> a() {
            return new b<T>(this.a, this.b.d(), this.c.b());
        }
    }

    @FunctionalInterface
    public static interface a<T> {
        public void accept(T var1, int var2);
    }
}

