/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.WorldConfiguration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class ChunkStatusTasks {
    private static final Logger a = LogUtils.getLogger();

    private static boolean a(IChunkAccess chunk) {
        return chunk.n().a(ChunkStatus.l) && chunk.x();
    }

    static CompletableFuture<IChunkAccess> a(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> b(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        if (serverLevel.I.x().d()) {
            worldGenContext.b().a(serverLevel.J_(), serverLevel.p().h(), serverLevel.b(), chunk, worldGenContext.c(), serverLevel.aq());
        }
        serverLevel.a(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> c(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        worldGenContext.a().a(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> d(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        worldGenContext.b().a((GeneratorAccessSeed)worldGenRegion, serverLevel.b().a(worldGenRegion), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> e(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        return worldGenContext.b().a(serverLevel.p().i(), Blender.a(worldGenRegion), serverLevel.b().a(worldGenRegion), chunk);
    }

    static CompletableFuture<IChunkAccess> f(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        return worldGenContext.b().a(Blender.a(worldGenRegion), serverLevel.p().i(), serverLevel.b().a(worldGenRegion), chunk).thenApply(chunkAccess -> {
            ProtoChunk protoChunk;
            BelowZeroRetrogen belowZeroRetrogen;
            if (chunkAccess instanceof ProtoChunk && (belowZeroRetrogen = (protoChunk = (ProtoChunk)chunkAccess).z()) != null) {
                BelowZeroRetrogen.a(protoChunk);
                if (belowZeroRetrogen.b()) {
                    belowZeroRetrogen.b(protoChunk);
                }
            }
            return chunkAccess;
        });
    }

    static CompletableFuture<IChunkAccess> g(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        worldGenContext.b().a(worldGenRegion, serverLevel.b().a(worldGenRegion), serverLevel.p().i(), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> h(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            Blender.a((GeneratorAccessSeed)worldGenRegion, protoChunk);
        }
        worldGenContext.b().a(worldGenRegion, serverLevel.J(), serverLevel.p().i(), serverLevel.H_(), serverLevel.b().a(worldGenRegion), chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> i(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        WorldServer serverLevel = worldGenContext.a();
        HeightMap.a(chunk, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
        RegionLimitedWorldAccess worldGenRegion = new RegionLimitedWorldAccess(serverLevel, cache, step, chunk);
        if (!SharedConstants.aD) {
            worldGenContext.b().a((GeneratorAccessSeed)worldGenRegion, chunk, serverLevel.b().a(worldGenRegion));
        }
        Blender.a(worldGenRegion, chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> j(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        LightEngineThreaded threadedLevelLightEngine = worldGenContext.d();
        chunk.C();
        ((ProtoChunk)chunk).a(threadedLevelLightEngine);
        boolean isLighted = ChunkStatusTasks.a(chunk);
        return threadedLevelLightEngine.a(chunk, isLighted);
    }

    static CompletableFuture<IChunkAccess> k(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        boolean isLighted = ChunkStatusTasks.a(chunk);
        return worldGenContext.d().b(chunk, isLighted);
    }

    static CompletableFuture<IChunkAccess> l(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        if (!chunk.A()) {
            worldGenContext.b().a(new RegionLimitedWorldAccess(worldGenContext.a(), cache, step, chunk));
        }
        return CompletableFuture.completedFuture(chunk);
    }

    static CompletableFuture<IChunkAccess> m(WorldGenContext worldGenContext, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache, IChunkAccess chunk) {
        ChunkCoordIntPair pos = chunk.f();
        GenerationChunkHolder generationChunkHolder = cache.a(pos.h, pos.i);
        return CompletableFuture.supplyAsync(() -> {
            Chunk wrapped;
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            WorldServer serverLevel = worldGenContext.a();
            if (protoChunk instanceof ProtoChunkExtension) {
                ProtoChunkExtension imposterProtoChunk = (ProtoChunkExtension)protoChunk;
                wrapped = imposterProtoChunk.H();
            } else {
                wrapped = new Chunk(serverLevel, protoChunk, chunk1 -> {
                    try (ProblemReporter.j scopedCollector = new ProblemReporter.j(chunk.E(), a);){
                        ChunkStatusTasks.postLoadProtoChunk(serverLevel, TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)serverLevel.J_(), protoChunk.J()), protoChunk.f());
                    }
                });
                generationChunkHolder.a(new ProtoChunkExtension(wrapped, false));
            }
            wrapped.b(generationChunkHolder::s);
            wrapped.H();
            wrapped.b(true);
            wrapped.L();
            wrapped.b(serverLevel);
            wrapped.a(worldGenContext.f());
            return wrapped;
        }, worldGenContext.e());
    }

    public static void postLoadProtoChunk(WorldServer level, ValueInput.b input, ChunkCoordIntPair pos) {
        if (!input.a()) {
            level.addWorldGenChunkEntities(EntityTypes.a(input, (World)level, EntitySpawnReason.r).filter(entity -> !ChunkStatusTasks.checkDupeUUID(level, entity)), pos);
        }
    }

    public static boolean checkDupeUUID(WorldServer level, Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        Entity other = level.d(entity.cY());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.eh() && Objects.equals(other.ca(), entity.ca()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            entity.discard(null);
            return true;
        }
        if (!other.eh()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a(UUID.randomUUID());
                    break;
                }
                case DELETE: {
                    entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    return true;
                }
            }
        }
        return false;
    }
}

