/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "Entities";
    private static final String c = "Position";
    public final WorldServer d;
    private final SimpleRegionStorage e;
    private final LongSet f = new LongOpenHashSet();
    public final ConsecutiveExecutor g;

    public EntityStorage(SimpleRegionStorage simpleRegionStorage, WorldServer level, Executor executor) {
        this.e = simpleRegionStorage;
        this.d = level;
        this.g = new ConsecutiveExecutor(executor, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> a(ChunkCoordIntPair pos) {
        if (this.f.contains(pos.b())) {
            return CompletableFuture.completedFuture(EntityStorage.b(pos));
        }
        CompletableFuture<Optional<NBTTagCompound>> completableFuture = this.e.d(pos);
        this.b(completableFuture, pos);
        return completableFuture.thenApplyAsync(entitiesTag -> {
            ChunkEntities<Entity> var8;
            if (entitiesTag.isEmpty()) {
                this.f.add(pos.b());
                return EntityStorage.b(pos);
            }
            try {
                ChunkCoordIntPair chunkPos = ((NBTTagCompound)entitiesTag.get()).a(c, ChunkCoordIntPair.a).orElseThrow();
                if (!Objects.equals(pos, chunkPos)) {
                    a.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{pos, pos, chunkPos});
                    this.d.s().a(chunkPos, pos, this.e.n());
                }
            }
            catch (Exception var11) {
                a.warn("Failed to parse chunk {} position info", (Object)pos, (Object)var11);
                this.d.s().a(var11, this.e.n(), pos);
            }
            NBTTagCompound compoundTag = this.e.a((NBTTagCompound)entitiesTag.get(), -1);
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(IChunkAccess.a(pos), a);){
                ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)this.d.J_(), compoundTag);
                ValueInput.b valueInputList = valueInput.d(b);
                List<Entity> list = EntityTypes.a(valueInputList, (World)this.d, EntitySpawnReason.r).toList();
                var8 = new ChunkEntities<Entity>(pos, list);
            }
            return var8;
        }, this.g::a_);
    }

    private static ChunkEntities<Entity> b(ChunkCoordIntPair pos) {
        return new ChunkEntities<Entity>(pos, List.of());
    }

    @Override
    public void a(ChunkEntities<Entity> entities) {
        ChunkCoordIntPair pos = entities.a();
        if (entities.c()) {
            if (this.f.add(pos.b())) {
                this.a(this.e.a(pos, IOWorker.a), pos);
            }
        } else {
            try (ProblemReporter.j scopedCollector = new ProblemReporter.j(IChunkAccess.a(pos), a);){
                NBTTagList listTag = new NBTTagList();
                HashMap savedEntityCounts = new HashMap();
                entities.b().forEach(entity -> {
                    TagValueOutput tagValueOutput;
                    EntityTypes<?> entityType = entity.ay();
                    int saveLimit = this.d.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
                    if (saveLimit > -1) {
                        if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                            return;
                        }
                        savedEntityCounts.merge(entityType, 1, Integer::sum);
                    }
                    if (entity.c(tagValueOutput = TagValueOutput.a(scopedCollector.a(entity.es()), entity.eo()))) {
                        NBTTagCompound compoundTag1 = tagValueOutput.b();
                        listTag.add(compoundTag1);
                    }
                });
                NBTTagCompound compoundTag = GameProfileSerializer.e(new NBTTagCompound());
                compoundTag.a(b, listTag);
                compoundTag.a(c, ChunkCoordIntPair.a, pos);
                this.a(this.e.a(pos, compoundTag), pos);
                this.f.remove(pos.b());
            }
        }
    }

    private void a(CompletableFuture<?> future, ChunkCoordIntPair pos) {
        future.exceptionally(throwable -> {
            a.error("Failed to store entity chunk {}", (Object)pos, throwable);
            this.d.s().b((Throwable)throwable, this.e.n(), pos);
            return null;
        });
    }

    private void b(CompletableFuture<?> future, ChunkCoordIntPair pos) {
        future.exceptionally(throwable -> {
            a.error("Failed to load entity chunk {}", (Object)pos, throwable);
            this.d.s().a((Throwable)throwable, this.e.n(), pos);
            return null;
        });
    }

    @Override
    public void a(boolean synchronize) {
        this.e.b(synchronize).join();
        this.g.a();
    }

    @Override
    public void close() throws IOException {
        this.e.close();
    }
}

