/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    public static final Supplier<NBTTagCompound> a = () -> null;
    private static final Logger b = LogUtils.getLogger();
    private final AtomicBoolean c = new AtomicBoolean();
    private final PriorityConsecutiveExecutor d;
    public final RegionFileCache e;
    private final SequencedMap<ChunkCoordIntPair, a> f = new LinkedHashMap<ChunkCoordIntPair, a>();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> g = new Long2ObjectLinkedOpenHashMap();
    private static final int h = 1024;

    protected IOWorker(RegionStorageInfo info, Path folder, boolean sync) {
        this.e = new RegionFileCache(info, folder, sync);
        this.d = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)SystemUtils.i(), "IOWorker-" + info.c());
    }

    public boolean a(ChunkCoordIntPair chunkPos, int radius) {
        ChunkCoordIntPair chunkPos1 = new ChunkCoordIntPair(chunkPos.h - radius, chunkPos.i - radius);
        ChunkCoordIntPair chunkPos2 = new ChunkCoordIntPair(chunkPos.h + radius, chunkPos.i + radius);
        for (int regionX = chunkPos1.i(); regionX <= chunkPos2.i(); ++regionX) {
            for (int regionZ = chunkPos1.j(); regionZ <= chunkPos2.j(); ++regionZ) {
                BitSet bitSet = this.a(regionX, regionZ).join();
                if (bitSet.isEmpty()) continue;
                ChunkCoordIntPair chunkPos3 = ChunkCoordIntPair.a(regionX, regionZ);
                int max = Math.max(chunkPos1.h - chunkPos3.h, 0);
                int max1 = Math.max(chunkPos1.i - chunkPos3.i, 0);
                int min = Math.min(chunkPos2.h - chunkPos3.h, 31);
                int min1 = Math.min(chunkPos2.i - chunkPos3.i, 31);
                for (int i2 = max; i2 <= min; ++i2) {
                    for (int i1 = max1; i1 <= min1; ++i1) {
                        int i22 = i1 * 32 + i2;
                        if (!bitSet.get(i22)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> a(int chunkX, int chunkZ) {
        long packedChunkPos = ChunkCoordIntPair.d(chunkX, chunkZ);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.g;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> completableFuture = (CompletableFuture<BitSet>)this.g.getAndMoveToFirst(packedChunkPos);
            if (completableFuture == null) {
                completableFuture = this.b(chunkX, chunkZ);
                this.g.putAndMoveToFirst(packedChunkPos, completableFuture);
                if (this.g.size() > 1024) {
                    this.g.removeLast();
                }
            }
            return completableFuture;
        }
    }

    private CompletableFuture<BitSet> b(int chunkX, int chunkZ) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkCoordIntPair chunkPos = ChunkCoordIntPair.a(chunkX, chunkZ);
            ChunkCoordIntPair chunkPos1 = ChunkCoordIntPair.b(chunkX, chunkZ);
            BitSet bitSet = new BitSet();
            ChunkCoordIntPair.a(chunkPos, chunkPos1).forEach(currentChunk -> {
                NBTTagCompound compoundTag;
                CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector(NBTTagCompound.b, "blending_data"));
                try {
                    this.a((ChunkCoordIntPair)currentChunk, collectFields).join();
                }
                catch (Exception var7) {
                    b.warn("Failed to scan chunk {}", currentChunk, (Object)var7);
                    return;
                }
                NBTBase patt0$temp = collectFields.d();
                if (patt0$temp instanceof NBTTagCompound && this.a(compoundTag = (NBTTagCompound)patt0$temp)) {
                    int i2 = currentChunk.l() * 32 + currentChunk.k();
                    bitSet.set(i2);
                }
            });
            return bitSet;
        }, SystemUtils.h());
    }

    private boolean a(NBTTagCompound chunkData) {
        return chunkData.b("DataVersion", 0) < 4295 || chunkData.m("blending_data").isPresent();
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, NBTTagCompound chunkData) {
        return this.a(chunkPos, () -> chunkData);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, Supplier<NBTTagCompound> dataSupplier) {
        return this.a(() -> {
            NBTTagCompound compoundTag = (NBTTagCompound)dataSupplier.get();
            a pendingStore = this.f.computeIfAbsent(chunkPos, chunkPos1 -> new a(compoundTag));
            pendingStore.a = compoundTag;
            return pendingStore.b;
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<NBTTagCompound>> a(ChunkCoordIntPair chunkPos) {
        return this.a(() -> {
            a pendingStore = (a)this.f.get(chunkPos);
            if (pendingStore != null) {
                return Optional.ofNullable(pendingStore.a());
            }
            try {
                NBTTagCompound compoundTag = this.e.a(chunkPos);
                return Optional.ofNullable(compoundTag);
            }
            catch (Exception var4) {
                b.warn("Failed to read chunk {}", (Object)chunkPos, (Object)var4);
                throw var4;
            }
        });
    }

    public CompletableFuture<Void> a(boolean flushStorage) {
        CompletionStage completableFuture = this.a(() -> CompletableFuture.allOf((CompletableFuture[])this.f.values().stream().map(pendingStore -> pendingStore.b).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        return flushStorage ? ((CompletableFuture)completableFuture).thenCompose(_void -> this.a(() -> {
            try {
                this.e.a();
                return null;
            }
            catch (Exception var2x) {
                b.warn("Failed to synchronize chunks", (Throwable)var2x);
                throw var2x;
            }
        })) : ((CompletableFuture)completableFuture).thenCompose(_void -> this.a(() -> null));
    }

    @Override
    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, StreamTagVisitor visitor) {
        return this.a(() -> {
            try {
                a pendingStore = (a)this.f.get(chunkPos);
                if (pendingStore != null) {
                    if (pendingStore.a != null) {
                        pendingStore.a.b(visitor);
                    }
                } else {
                    this.e.a(chunkPos, visitor);
                }
                return null;
            }
            catch (Exception var4) {
                b.warn("Failed to bulk scan chunk {}", (Object)chunkPos, (Object)var4);
                throw var4;
            }
        });
    }

    private <T> CompletableFuture<T> a(c<T> task) {
        return this.d.a(Priority.a.ordinal(), (CompletableFuture<Source> completableFuture) -> {
            if (!this.c.get()) {
                try {
                    completableFuture.complete(task.get());
                }
                catch (Exception var4) {
                    completableFuture.completeExceptionally(var4);
                }
            }
            this.c();
        });
    }

    private <T> CompletableFuture<T> a(Supplier<T> task) {
        return this.d.a(Priority.a.ordinal(), (CompletableFuture<Source> completableFuture) -> {
            if (!this.c.get()) {
                completableFuture.complete(task.get());
            }
            this.c();
        });
    }

    private void b() {
        Map.Entry<ChunkCoordIntPair, a> entry = this.f.pollFirstEntry();
        if (entry != null) {
            this.a(entry.getKey(), entry.getValue());
            this.c();
        }
    }

    private void c() {
        this.d.a_(new PairedQueue.c(Priority.b.ordinal(), this::b));
    }

    private void a(ChunkCoordIntPair chunkPos, a pendingStore) {
        try {
            this.e.a(chunkPos, pendingStore.a);
            pendingStore.b.complete(null);
        }
        catch (Exception var4) {
            b.error("Failed to store chunk {}", (Object)chunkPos, (Object)var4);
            pendingStore.b.completeExceptionally(var4);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.c.compareAndSet(false, true)) {
            this.d();
            this.d.close();
            try {
                this.e.close();
            }
            catch (Exception var2) {
                b.error("Failed to close storage", (Throwable)var2);
            }
        }
    }

    private void d() {
        this.d.a(Priority.c.ordinal(), (CompletableFuture<Source> completableFuture) -> completableFuture.complete(Unit.a)).join();
    }

    public RegionStorageInfo a() {
        return this.e.b();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority a = new Priority();
        public static final /* enum */ Priority b = new Priority();
        public static final /* enum */ Priority c = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String name) {
            return Enum.valueOf(Priority.class, name);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{a, b, c};
        }

        static {
            d = Priority.a();
        }
    }

    @FunctionalInterface
    static interface c<T> {
        public @Nullable T get() throws Exception;
    }

    static class a {
        @Nullable NBTTagCompound a;
        final CompletableFuture<Void> b = new CompletableFuture();

        public a(@Nullable NBTTagCompound data) {
            this.a = data;
        }

        @Nullable NBTTagCompound a() {
            NBTTagCompound compoundTag = this.a;
            return compoundTag == null ? null : compoundTag.l();
        }
    }
}

