/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemChunkBuffer;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemRegionFile;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.InflaterInputStream;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileBitSet;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class RegionFile
implements AutoCloseable,
ChunkSystemRegionFile {
    private static final Logger c = LogUtils.getLogger();
    public static final int MAX_CHUNK_SIZE = 524288000;
    private static final int d = 4096;
    @VisibleForTesting
    protected static final int a = 1024;
    private static final int e = 5;
    private static final int f = 0;
    private static final ByteBuffer g = ByteBuffer.allocateDirect(1);
    private static final String h = ".mcc";
    private static final int i = 128;
    private static final int j = 256;
    private static final int k = 0;
    final RegionStorageInfo l;
    private final Path m;
    private final FileChannel n;
    private final Path o;
    final RegionFileCompression p;
    private final ByteBuffer q = ByteBuffer.allocateDirect(8192);
    private final IntBuffer r;
    private final IntBuffer s;
    @VisibleForTesting
    protected final RegionFileBitSet b = new RegionFileBitSet();
    private static final NBTTagCompound OVERSIZED_COMPOUND = new NBTTagCompound();
    private final AtomicInteger recalculateCount = new AtomicInteger();
    final boolean canRecalcHeader;
    private final byte[] oversized = new byte[1024];
    private int oversizedCount;

    private static long roundToSectors(long bytes) {
        long sectors = bytes >>> 12;
        long remainingBytes = bytes & 0xFFFL;
        long sign = -remainingBytes;
        return sectors + (sign >>> 63);
    }

    private @Nullable NBTTagCompound attemptRead(long sector, int chunkDataLength, long fileLength) throws IOException {
        try {
            if (chunkDataLength < 0) {
                return null;
            }
            long offset = sector * 4096L + 4L;
            if (offset + (long)chunkDataLength > fileLength) {
                return null;
            }
            ByteBuffer chunkData = ByteBuffer.allocate(chunkDataLength);
            if (chunkDataLength != this.n.read(chunkData, offset)) {
                return null;
            }
            ((Buffer)chunkData).flip();
            byte compressionType = chunkData.get();
            if (compressionType < 0) {
                return OVERSIZED_COMPOUND;
            }
            RegionFileCompression compression = RegionFileCompression.a(compressionType);
            if (compression == null) {
                return null;
            }
            InputStream input = compression.a(new ByteArrayInputStream(chunkData.array(), chunkData.position(), chunkDataLength - chunkData.position()));
            return NBTCompressedStreamTools.a(new DataInputStream(input));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private int getLength(long sector) throws IOException {
        ByteBuffer length = ByteBuffer.allocate(4);
        if (4 != this.n.read(length, sector * 4096L)) {
            return -1;
        }
        return length.getInt(0);
    }

    private void backupRegionFile() {
        Path backup = this.m.getParent().resolve(String.valueOf(this.m.getFileName()) + "." + new Random().nextLong() + ".backup");
        this.backupRegionFile(backup);
    }

    private void backupRegionFile(Path to) {
        try {
            this.n.force(true);
            c.warn("Backing up regionfile \"" + String.valueOf(this.m.toAbsolutePath()) + "\" to " + String.valueOf(to.toAbsolutePath()));
            Files.copy(this.m, to, StandardCopyOption.COPY_ATTRIBUTES);
            c.warn("Backed up the regionfile to " + String.valueOf(to.toAbsolutePath()));
        }
        catch (IOException ex) {
            c.error("Failed to backup to " + String.valueOf(to.toAbsolutePath()), (Throwable)ex);
        }
    }

    private static boolean inSameRegionfile(ChunkCoordIntPair first, ChunkCoordIntPair second) {
        return (first.h & 0xFFFFFFE0) == (second.h & 0xFFFFFFE0) && (first.i & 0xFFFFFFE0) == (second.i & 0xFFFFFFE0);
    }

    public int getRecalculateCount() {
        return this.recalculateCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recalculateHeader() throws IOException {
        if (!this.canRecalcHeader) {
            return false;
        }
        ChunkCoordIntPair ourLowerLeftPosition = RegionFileCache.getRegionFileCoordinates(this.m);
        if (ourLowerLeftPosition == null) {
            c.error("Unable to get chunk location of regionfile " + String.valueOf(this.m.toAbsolutePath()) + ", cannot recover header");
            return false;
        }
        RegionFile regionFile = this;
        synchronized (regionFile) {
            int chunkZ;
            int chunkX;
            this.recalculateCount.getAndIncrement();
            c.warn("Corrupt regionfile header detected! Attempting to re-calculate header offsets for regionfile " + String.valueOf(this.m.toAbsolutePath()), new Throwable());
            this.backupRegionFile();
            NBTTagCompound[] compounds = new NBTTagCompound[1024];
            int[] rawLengths = new int[1024];
            int[] sectorOffsets = new int[1024];
            boolean[] hasAikarOversized = new boolean[1024];
            long fileLength = this.n.size();
            long totalSectors = RegionFile.roundToSectors(fileLength);
            long maxSector = Math.min(0x7FFFFFL, totalSectors);
            for (long i2 = 2L; i2 < maxSector; ++i2) {
                int chunkDataLength = this.getLength(i2);
                NBTTagCompound compound = this.attemptRead(i2, chunkDataLength, fileLength);
                if (compound == null || compound == OVERSIZED_COMPOUND) continue;
                ChunkCoordIntPair chunkPos = SerializableChunkData.getChunkCoordinate(compound);
                if (!RegionFile.inSameRegionfile(ourLowerLeftPosition, chunkPos)) {
                    c.error("Ignoring absolute chunk " + String.valueOf(chunkPos) + " in regionfile as it is not contained in the bounds of the regionfile '" + String.valueOf(this.m.toAbsolutePath()) + "'. It should be in regionfile (" + (chunkPos.h >> 5) + "," + (chunkPos.i >> 5) + ")");
                    continue;
                }
                int location = chunkPos.h & 0x1F | (chunkPos.i & 0x1F) << 5;
                NBTTagCompound nBTTagCompound = compounds[location];
                if (nBTTagCompound != null && SerializableChunkData.getLastWorldSaveTime(nBTTagCompound) > SerializableChunkData.getLastWorldSaveTime(compound)) continue;
                Path aikarOversizedFile = this.getOversizedFile(chunkPos.h, chunkPos.i);
                int isAikarOversized = 0;
                if (Files.exists(aikarOversizedFile, new LinkOption[0])) {
                    try {
                        NBTTagCompound aikarOversizedCompound = this.getOversizedData(chunkPos.h, chunkPos.i);
                        if (SerializableChunkData.getLastWorldSaveTime(compound) == SerializableChunkData.getLastWorldSaveTime(aikarOversizedCompound)) {
                            isAikarOversized = 1;
                        }
                    }
                    catch (Exception ex) {
                        c.error("Failed to read aikar oversized data for absolute chunk (" + chunkPos.h + "," + chunkPos.i + ") in regionfile " + String.valueOf(this.m.toAbsolutePath()) + ", oversized data for this chunk will be lost", (Throwable)ex);
                    }
                }
                hasAikarOversized[location] = isAikarOversized;
                compounds[location] = compound;
                rawLengths[location] = chunkDataLength + 4;
                sectorOffsets[location] = (int)i2;
                int chunkSectorLength = (int)RegionFile.roundToSectors(rawLengths[location]);
                i2 += (long)chunkSectorLength;
                --i2;
            }
            Path containingFolder = this.o;
            Path[] regionFiles = (Path[])Files.list(containingFolder).toArray(Path[]::new);
            boolean[] oversized = new boolean[1024];
            RegionFileCompression[] oversizedCompressionTypes = new RegionFileCompression[1024];
            if (regionFiles != null) {
                int lowerXBound = ourLowerLeftPosition.h;
                int lowerZBound = ourLowerLeftPosition.i;
                int upperXBound = lowerXBound + 32 - 1;
                int upperZBound = lowerZBound + 32 - 1;
                for (Path regionFile2 : regionFiles) {
                    byte[] chunkData;
                    ChunkCoordIntPair oversizedCoords = RegionFile.getOversizedChunkPair(regionFile2);
                    if (oversizedCoords == null || oversizedCoords.h < lowerXBound || oversizedCoords.h > upperXBound || oversizedCoords.i < lowerZBound || oversizedCoords.i > upperZBound) continue;
                    int location = oversizedCoords.h & 0x1F | (oversizedCoords.i & 0x1F) << 5;
                    try {
                        chunkData = Files.readAllBytes(regionFile2);
                    }
                    catch (Exception ex) {
                        c.error("Failed to read oversized chunk data in file " + String.valueOf(regionFile2.toAbsolutePath()) + ", data will be lost", (Throwable)ex);
                        continue;
                    }
                    NBTTagCompound compound = null;
                    RegionFileCompression compression = null;
                    for (RegionFileCompression compressionType : RegionFileCompression.h.values()) {
                        try {
                            DataInputStream in = new DataInputStream(compressionType.a(new ByteArrayInputStream(chunkData)));
                            compound = NBTCompressedStreamTools.a(in);
                            compression = compressionType;
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                    if (compound == null) {
                        c.error("Failed to read oversized chunk data in file " + String.valueOf(regionFile2.toAbsolutePath()) + ", it's corrupt. Its data will be lost");
                        continue;
                    }
                    if (!SerializableChunkData.getChunkCoordinate(compound).equals(oversizedCoords)) {
                        c.error("Can't use oversized chunk stored in " + String.valueOf(regionFile2.toAbsolutePath()) + ", got absolute chunkpos: " + String.valueOf(SerializableChunkData.getChunkCoordinate(compound)) + ", expected " + String.valueOf(oversizedCoords));
                        continue;
                    }
                    if (compounds[location] != null && SerializableChunkData.getLastWorldSaveTime(compound) <= SerializableChunkData.getLastWorldSaveTime(compounds[location])) continue;
                    oversized[location] = true;
                    oversizedCompressionTypes[location] = compression;
                }
            }
            int[] calculatedOffsets = new int[1024];
            RegionFileBitSet newSectorAllocations = new RegionFileBitSet();
            newSectorAllocations.a(0, 2);
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n2 = chunkX | chunkZ << 5;
                    if (oversized[n2]) continue;
                    int sectorOffset = sectorOffsets[n2];
                    int rawLength = rawLengths[n2];
                    int sectorLength = (int)RegionFile.roundToSectors(rawLength);
                    if (newSectorAllocations.tryAllocate(sectorOffset, sectorLength)) {
                        calculatedOffsets[n2] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    c.error("Failed to allocate space for local chunk (overlapping data??) at (" + chunkX + "," + chunkZ + ") in regionfile " + String.valueOf(this.m.toAbsolutePath()) + ", chunk will be regenerated");
                }
            }
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n3 = chunkX | chunkZ << 5;
                    if (!oversized[n3]) continue;
                    int sectorOffset = newSectorAllocations.a(1);
                    int sectorLength = 1;
                    try {
                        this.n.write(this.createExternalStub(oversizedCompressionTypes[n3]), sectorOffset * 4096);
                        calculatedOffsets[n3] = sectorOffset << 8 | (sectorLength > 255 ? 255 : sectorLength);
                        continue;
                    }
                    catch (IOException ex) {
                        newSectorAllocations.b(sectorOffset, sectorLength);
                        c.error("Failed to write new oversized chunk data holder, local chunk at (" + chunkX + "," + chunkZ + ") in regionfile " + String.valueOf(this.m.toAbsolutePath()) + " will be regenerated");
                    }
                }
            }
            this.oversizedCount = 0;
            for (chunkX = 0; chunkX < 32; ++chunkX) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int n4 = chunkX | chunkZ << 5;
                    int isAikarOversized = hasAikarOversized[n4] ? 1 : 0;
                    this.oversizedCount += isAikarOversized;
                    this.oversized[n4] = (byte)isAikarOversized;
                }
            }
            if (this.oversizedCount > 0) {
                try {
                    this.writeOversizedMeta();
                }
                catch (Exception ex) {
                    c.error("Failed to write aikar oversized chunk meta, all aikar style oversized chunk data will be lost for regionfile " + String.valueOf(this.m.toAbsolutePath()), (Throwable)ex);
                    Files.deleteIfExists(this.getOversizedMetaFile());
                }
            } else {
                Files.deleteIfExists(this.getOversizedMetaFile());
            }
            this.b.copyFrom(newSectorAllocations);
            c.info("Starting summary of changes for regionfile " + String.valueOf(this.m.toAbsolutePath()));
            for (int chunkX2 = 0; chunkX2 < 32; ++chunkX2) {
                for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                    int newOffset;
                    int n5 = chunkX2 | chunkZ << 5;
                    int oldOffset = this.r.get(n5);
                    if (oldOffset == (newOffset = calculatedOffsets[n5])) continue;
                    this.r.put(n5, newOffset);
                    if (oldOffset == 0) {
                        c.info("Found missing data for local chunk (" + chunkX2 + "," + chunkZ + ") in regionfile " + String.valueOf(this.m.toAbsolutePath()));
                        continue;
                    }
                    if (newOffset == 0) {
                        c.warn("Data for local chunk (" + chunkX2 + "," + chunkZ + ") could not be recovered in regionfile " + String.valueOf(this.m.toAbsolutePath()) + ", it will be regenerated");
                        continue;
                    }
                    c.info("Local chunk (" + chunkX2 + "," + chunkZ + ") changed to point to newer data or correct chunk in regionfile " + String.valueOf(this.m.toAbsolutePath()));
                }
            }
            c.info("End of change summary for regionfile " + String.valueOf(this.m.toAbsolutePath()));
            for (int i3 = 0; i3 < 1024; ++i3) {
                this.s.put(i3, calculatedOffsets[i3] != 0 ? RegionFile.c() : 0);
            }
            try {
                this.b();
                this.n.force(true);
                c.info("Successfully wrote new header to disk for regionfile " + String.valueOf(this.m.toAbsolutePath()));
            }
            catch (IOException ex) {
                c.error("Failed to write new header to disk for regionfile " + String.valueOf(this.m.toAbsolutePath()), (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(NBTTagCompound data, ChunkCoordIntPair pos) throws IOException {
        RegionFile regionFile = this;
        Objects.requireNonNull(regionFile);
        ChunkBuffer buffer = regionFile.new ChunkBuffer(pos);
        buffer.moonrise$setWriteOnClose(false);
        DataOutputStream out = new DataOutputStream(this.p.a(buffer));
        return new MoonriseRegionFileIO.RegionDataController.WriteData(data, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.WRITE, out, buffer::moonrise$write);
    }

    public RegionFile(RegionStorageInfo info, Path path, Path externalFileDir, boolean sync) throws IOException {
        this(info, path, externalFileDir, RegionFileCompression.getCompressionFormat(), sync);
    }

    public RegionFile(RegionStorageInfo info, Path path, Path externalFileDir, RegionFileCompression version, boolean sync) throws IOException {
        this.l = info;
        this.m = path;
        this.p = version;
        this.initOversizedState();
        if (!Files.isDirectory(externalFileDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + String.valueOf(externalFileDir.toAbsolutePath()));
        }
        this.o = externalFileDir;
        this.canRecalcHeader = RegionFileCache.isChunkDataFolder(this.o);
        this.r = this.q.asIntBuffer();
        this.r.limit(1024);
        this.q.position(4096);
        this.s = this.q.asIntBuffer();
        this.n = sync ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.b.a(0, 2);
        this.q.position(0);
        int i2 = this.n.read(this.q, 0L);
        if (i2 != -1) {
            if (i2 != 8192) {
                c.warn("Region file {} has truncated header: {}", (Object)path, (Object)i2);
            }
            long size = Files.size(path);
            boolean needsHeaderRecalc = false;
            boolean hasBackedUp = false;
            for (int i1 = 0; i1 < 1024; ++i1) {
                boolean failedToAllocate;
                int headerLocation = i1;
                int i22 = this.r.get(i1);
                if (i22 == 0) continue;
                int sectorNumber = RegionFile.b(i22);
                int numSectors = RegionFile.a(i22);
                if (numSectors == 255) {
                    ByteBuffer realLen = ByteBuffer.allocate(4);
                    this.n.read(realLen, sectorNumber * 4096);
                    numSectors = (realLen.getInt(0) + 4) / 4096 + 1;
                }
                if (sectorNumber < 2) {
                    c.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", new Object[]{path, i1, sectorNumber});
                } else if (numSectors == 0) {
                    c.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)i1);
                } else if ((long)sectorNumber * 4096L > size) {
                    c.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", new Object[]{path, i1, sectorNumber});
                }
                if (sectorNumber < 2 || numSectors <= 0 || (long)sectorNumber * 4096L > size) {
                    if (this.canRecalcHeader) {
                        c.error("Detected invalid header for regionfile " + String.valueOf(this.m.toAbsolutePath()) + "! Recalculating header...");
                        needsHeaderRecalc = true;
                        break;
                    }
                    c.error("Detected invalid header for regionfile " + String.valueOf(this.m.toAbsolutePath()) + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.s.put(headerLocation, 0);
                    this.r.put(headerLocation, 0);
                    continue;
                }
                boolean bl = failedToAllocate = !this.b.tryAllocate(sectorNumber, numSectors);
                if (failedToAllocate) {
                    c.error("Overlapping allocation by local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") in regionfile " + String.valueOf(this.m.toAbsolutePath()));
                }
                if (failedToAllocate & !this.canRecalcHeader) {
                    c.error("Detected invalid header for regionfile " + String.valueOf(this.m.toAbsolutePath()) + "! Cannot recalculate, removing local chunk (" + (headerLocation & 0x1F) + "," + (headerLocation >>> 5) + ") from header");
                    if (!hasBackedUp) {
                        hasBackedUp = true;
                        this.backupRegionFile();
                    }
                    this.s.put(headerLocation, 0);
                    this.r.put(headerLocation, 0);
                    continue;
                }
                needsHeaderRecalc |= failedToAllocate;
            }
            if (needsHeaderRecalc) {
                c.error("Recalculating regionfile " + String.valueOf(this.m.toAbsolutePath()) + ", header gave erroneous offsets & locations");
                this.recalculateHeader();
            }
        }
    }

    public Path a() {
        return this.m;
    }

    private Path f(ChunkCoordIntPair chunkPos) {
        String string = "c." + chunkPos.h + "." + chunkPos.i + h;
        return this.o.resolve(string);
    }

    private static @Nullable ChunkCoordIntPair getOversizedChunkPair(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("c.") || !fileName.endsWith(h)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x2 = Integer.parseInt(split[1]);
            int z2 = Integer.parseInt(split[2]);
            return new ChunkCoordIntPair(x2, z2);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public synchronized @Nullable DataInputStream a(ChunkCoordIntPair chunkPos) throws IOException {
        int offset = this.g(chunkPos);
        if (offset == 0) {
            return null;
        }
        int sectorNumber = RegionFile.b(offset);
        int numSectors = RegionFile.a(offset);
        if (numSectors == 255) {
            ByteBuffer realLen = ByteBuffer.allocate(4);
            this.n.read(realLen, sectorNumber * 4096);
            numSectors = (realLen.getInt(0) + 4) / 4096 + 1;
        }
        int i2 = numSectors * 4096;
        ByteBuffer byteBuffer = ByteBuffer.allocate(i2);
        this.n.read(byteBuffer, sectorNumber * 4096);
        byteBuffer.flip();
        if (byteBuffer.remaining() < 5) {
            c.error("Chunk {} header is truncated: expected {} but read {}", new Object[]{chunkPos, i2, byteBuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(chunkPos);
            }
            return null;
        }
        int _int = byteBuffer.getInt();
        byte b2 = byteBuffer.get();
        if (_int == 0) {
            c.warn("Chunk {} is allocated, but stream is missing", (Object)chunkPos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(chunkPos);
            }
            return null;
        }
        int i1 = _int - 1;
        if (RegionFile.a(b2)) {
            DataInputStream ret;
            if (i1 != 0) {
                c.warn("Chunk has both internal and external streams");
                if (this.canRecalcHeader && this.recalculateHeader()) {
                    return this.a(chunkPos);
                }
            }
            if ((ret = this.a(chunkPos, RegionFile.b(b2))) == null && this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(chunkPos);
            }
            return ret;
        }
        if (i1 > byteBuffer.remaining()) {
            c.error("Chunk {} stream is truncated: expected {} but read {}", new Object[]{chunkPos, i1, byteBuffer.remaining()});
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(chunkPos);
            }
            return null;
        }
        if (i1 < 0) {
            c.error("Declared size {} of chunk {} is negative", (Object)_int, (Object)chunkPos);
            if (this.canRecalcHeader && this.recalculateHeader()) {
                return this.a(chunkPos);
            }
            return null;
        }
        JvmProfiler.f.a(this.l, chunkPos, this.p, i1);
        DataInputStream ret = this.a(chunkPos, b2, RegionFile.a(byteBuffer, i1));
        if (ret == null && this.canRecalcHeader && this.recalculateHeader()) {
            return this.a(chunkPos);
        }
        return ret;
    }

    private static int c() {
        return (int)(SystemUtils.e() / 1000L);
    }

    private static boolean a(byte versionByte) {
        return (versionByte & 0x80) != 0;
    }

    private static byte b(byte versionByte) {
        return (byte)(versionByte & 0xFFFFFF7F);
    }

    private @Nullable DataInputStream a(ChunkCoordIntPair chunkPos, byte versionByte, InputStream inputStream) throws IOException {
        RegionFileCompression regionFileVersion = RegionFileCompression.a(versionByte);
        if (regionFileVersion == RegionFileCompression.e) {
            String utf = new DataInputStream(inputStream).readUTF();
            MinecraftKey identifier = MinecraftKey.c(utf);
            if (identifier != null) {
                c.error("Unrecognized custom compression {}", (Object)identifier);
                return null;
            }
            c.error("Invalid custom compression id {}", (Object)utf);
            return null;
        }
        if (regionFileVersion == null) {
            c.error("Chunk {} has invalid chunk stream version {}", (Object)chunkPos, (Object)versionByte);
            return null;
        }
        return new DataInputStream(regionFileVersion.a(inputStream));
    }

    private @Nullable DataInputStream a(ChunkCoordIntPair chunkPos, byte versionByte) throws IOException {
        DataInputStream is = this.createExternalChunkInputStream0(chunkPos, versionByte);
        if (is == null) {
            return is;
        }
        return new ExternalChunkStreamMarker(is);
    }

    private @Nullable DataInputStream createExternalChunkInputStream0(ChunkCoordIntPair chunkPos, byte versionByte) throws IOException {
        Path externalChunkPath = this.f(chunkPos);
        if (!Files.isRegularFile(externalChunkPath, new LinkOption[0])) {
            c.error("External chunk path {} is not file", (Object)externalChunkPath);
            return null;
        }
        return this.a(chunkPos, versionByte, Files.newInputStream(externalChunkPath, new OpenOption[0]));
    }

    private static ByteArrayInputStream a(ByteBuffer sourceBuffer, int length) {
        return new ByteArrayInputStream(sourceBuffer.array(), sourceBuffer.position(), length);
    }

    private int a(int sectorOffset, int sectorCount) {
        return sectorOffset << 8 | sectorCount;
    }

    private static int a(int packedSectorOffset) {
        return packedSectorOffset & 0xFF;
    }

    private static int b(int packedSectorOffset) {
        return packedSectorOffset >> 8 & 0xFFFFFF;
    }

    private static int c(int size) {
        return (size + 4096 - 1) / 4096;
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        int offset = this.g(chunkPos);
        if (offset == 0) {
            return false;
        }
        int sectorNumber = RegionFile.b(offset);
        int numSectors = RegionFile.a(offset);
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        try {
            this.n.read(byteBuffer, sectorNumber * 4096);
            byteBuffer.flip();
            if (byteBuffer.remaining() != 5) {
                return false;
            }
            int _int = byteBuffer.getInt();
            byte b2 = byteBuffer.get();
            if (RegionFile.a(b2)) {
                if (!RegionFileCompression.b(RegionFile.b(b2))) {
                    return false;
                }
                if (!Files.isRegularFile(this.f(chunkPos), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileCompression.b(b2)) {
                    return false;
                }
                if (_int == 0) {
                    return false;
                }
                int i2 = _int - 1;
                if (i2 < 0 || i2 > 4096 * numSectors) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException var9) {
            ServerInternalException.reportInternalException((Throwable)var9);
            return false;
        }
    }

    public DataOutputStream c(ChunkCoordIntPair chunkPos) throws IOException {
        return new DataOutputStream(this.p.a(new ChunkBuffer(chunkPos)));
    }

    public void b() throws IOException {
        this.n.force(true);
    }

    public void d(ChunkCoordIntPair chunkPos) throws IOException {
        int offsetIndex = RegionFile.h(chunkPos);
        int i2 = this.r.get(offsetIndex);
        if (i2 != 0) {
            this.r.put(offsetIndex, 0);
            this.s.put(offsetIndex, RegionFile.c());
            this.e();
            Files.deleteIfExists(this.f(chunkPos));
            this.b.b(RegionFile.b(i2), RegionFile.a(i2));
        }
    }

    protected synchronized void a(ChunkCoordIntPair chunkPos, ByteBuffer chunkData) throws IOException {
        b commitOp;
        int i3;
        int offsetIndex = RegionFile.h(chunkPos);
        int i2 = this.r.get(offsetIndex);
        int sectorNumber = RegionFile.b(i2);
        int numSectors = RegionFile.a(i2);
        int i1 = chunkData.remaining();
        int i22 = RegionFile.c(i1);
        if (i22 >= 256) {
            Path externalChunkPath = this.f(chunkPos);
            c.warn("Saving oversized chunk {} ({} bytes} to external file {}", new Object[]{chunkPos, i1, externalChunkPath});
            i22 = 1;
            i3 = this.b.a(i22);
            commitOp = this.a(externalChunkPath, chunkData);
            ByteBuffer byteBuffer = this.d();
            this.n.write(byteBuffer, i3 * 4096);
        } else {
            i3 = this.b.a(i22);
            commitOp = () -> Files.deleteIfExists(this.f(chunkPos));
            this.n.write(chunkData, i3 * 4096);
        }
        this.r.put(offsetIndex, this.a(i3, i22));
        this.s.put(offsetIndex, RegionFile.c());
        this.e();
        commitOp.run();
        if (sectorNumber != 0) {
            this.b.b(sectorNumber, numSectors);
        }
    }

    private ByteBuffer d() {
        return this.createExternalStub(this.p);
    }

    private ByteBuffer createExternalStub(RegionFileCompression version) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.putInt(1);
        byteBuffer.put((byte)(version.b() | 0x80));
        byteBuffer.flip();
        return byteBuffer;
    }

    private b a(Path externalChunkFile, ByteBuffer chunkData) throws IOException {
        Path path = Files.createTempFile(this.o, "tmp", null, new FileAttribute[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            chunkData.position(5);
            fileChannel.write(chunkData);
        }
        catch (Throwable throwable) {
            ServerInternalException.reportInternalException((Throwable)throwable);
            throw throwable;
        }
        return () -> Files.move(path, externalChunkFile, StandardCopyOption.REPLACE_EXISTING);
    }

    private void e() throws IOException {
        this.q.position(0);
        this.n.write(this.q, 0L);
    }

    private int g(ChunkCoordIntPair chunkPos) {
        return this.r.get(RegionFile.h(chunkPos));
    }

    public boolean e(ChunkCoordIntPair chunkPos) {
        return this.g(chunkPos) != 0;
    }

    private static int h(ChunkCoordIntPair chunkPos) {
        return chunkPos.k() + chunkPos.l() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.f();
        }
        finally {
            try {
                this.n.force(true);
            }
            finally {
                this.n.close();
            }
        }
    }

    private void f() throws IOException {
        int i1;
        int i2 = (int)this.n.size();
        if (i2 != (i1 = RegionFile.c(i2) * 4096)) {
            ByteBuffer byteBuffer = g.duplicate();
            byteBuffer.position(0);
            this.n.write(byteBuffer, i1 - 1);
        }
    }

    private synchronized void initOversizedState() throws IOException {
        Path metaFile = this.getOversizedMetaFile();
        if (Files.exists(metaFile, new LinkOption[0])) {
            byte[] read = Files.readAllBytes(metaFile);
            System.arraycopy(read, 0, this.oversized, 0, this.oversized.length);
            for (byte temp : this.oversized) {
                this.oversizedCount += temp;
            }
        }
    }

    private static int getChunkIndex(int x2, int z2) {
        return (x2 & 0x1F) + (z2 & 0x1F) * 32;
    }

    synchronized boolean isOversized(int x2, int z2) {
        return this.oversized[RegionFile.getChunkIndex(x2, z2)] == 1;
    }

    synchronized void setOversized(int x2, int z2, boolean oversized) throws IOException {
        Path oversizedMetaFile;
        Path oversizedFile;
        int offset = RegionFile.getChunkIndex(x2, z2);
        boolean previous = this.oversized[offset] == 1;
        this.oversized[offset] = (byte)(oversized ? 1 : 0);
        if (!previous && oversized) {
            ++this.oversizedCount;
        } else if (!oversized && previous) {
            --this.oversizedCount;
        }
        if (previous && !oversized && Files.exists(oversizedFile = this.getOversizedFile(x2, z2), new LinkOption[0])) {
            Files.delete(oversizedFile);
        }
        if (this.oversizedCount > 0) {
            if (previous != oversized) {
                this.writeOversizedMeta();
            }
        } else if (previous && Files.exists(oversizedMetaFile = this.getOversizedMetaFile(), new LinkOption[0])) {
            Files.delete(oversizedMetaFile);
        }
    }

    private void writeOversizedMeta() throws IOException {
        Files.write(this.getOversizedMetaFile(), this.oversized, new OpenOption[0]);
    }

    private Path getOversizedMetaFile() {
        return this.m.getParent().resolve(this.m.getFileName().toString().replaceAll("\\.mca$", "") + ".oversized.nbt");
    }

    private Path getOversizedFile(int x2, int z2) {
        return this.m.getParent().resolve(this.m.getFileName().toString().replaceAll("\\.mca$", "") + "_oversized_" + x2 + "_" + z2 + ".nbt");
    }

    synchronized NBTTagCompound getOversizedData(int x2, int z2) throws IOException {
        Path file = this.getOversizedFile(x2, z2);
        try (DataInputStream out = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(file, new OpenOption[0]))));){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(out);
            return nBTTagCompound;
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream
    implements ChunkSystemChunkBuffer {
        private final ChunkCoordIntPair b;
        private boolean writeOnClose;

        @Override
        public final boolean moonrise$getWriteOnClose() {
            return this.writeOnClose;
        }

        @Override
        public final void moonrise$setWriteOnClose(boolean value) {
            this.writeOnClose = value;
        }

        @Override
        public final void moonrise$write(RegionFile regionFile) throws IOException {
            regionFile.a(this.b, ByteBuffer.wrap(this.buf, 0, this.count));
        }

        public ChunkBuffer(ChunkCoordIntPair pos) {
            super(8096);
            this.writeOnClose = true;
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.p.b());
            this.b = pos;
        }

        @Override
        public void write(int b2) {
            if (this.count > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + this.count);
            }
            super.write(b2);
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            if (this.count + len > 524288000) {
                throw new RegionFileCache.RegionFileSizeException("Region file too large: " + (this.count + len));
            }
            super.write(b2, off, len);
        }

        @Override
        public void close() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            int i2 = this.count - 5 + 1;
            JvmProfiler.f.b(RegionFile.this.l, this.b, RegionFile.this.p, i2);
            byteBuffer.putInt(0, i2);
            if (this.writeOnClose) {
                RegionFile.this.a(this.b, byteBuffer);
            }
        }
    }

    static interface b {
        public void run() throws IOException;
    }
}

