/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemSimpleRegionStorage;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class SimpleRegionStorage
implements ChunkSystemSimpleRegionStorage,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final RegionFileCache storage;
    private final DataFixer b;
    private final DataFixTypes c;
    private final Supplier<LegacyTagFixer> d;

    public SimpleRegionStorage(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType) {
        this(info, folder, fixerUpper, sync, dataFixType, LegacyTagFixer.a);
    }

    public SimpleRegionStorage(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType, Supplier<LegacyTagFixer> legacyFixer) {
        this.b = fixerUpper;
        this.c = dataFixType;
        this.storage = new IOWorker((RegionStorageInfo)info, (Path)folder, (boolean)sync).e;
        this.d = Suppliers.memoize(legacyFixer::get);
    }

    @Override
    public final RegionFileCache moonrise$getRegionStorage() {
        return this.storage;
    }

    public boolean b(ChunkCoordIntPair chunkPos, int radius) {
        return true;
    }

    public CompletableFuture<Optional<NBTTagCompound>> d(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.a(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, NBTTagCompound data) {
        return this.a(chunkPos, () -> data);
    }

    public CompletableFuture<Void> a(ChunkCoordIntPair chunkPos, Supplier<NBTTagCompound> data) {
        Supplier<NBTTagCompound> guardedPosCheck = () -> {
            boolean chunkStorage;
            NBTTagCompound nbt = (NBTTagCompound)data.get();
            boolean bl = chunkStorage = this.c == DataFixTypes.d;
            if (chunkStorage && nbt != null && !chunkPos.equals(SerializableChunkData.getChunkCoordinate(nbt))) {
                String world = this instanceof PlayerChunkMap ? ((PlayerChunkMap)this).r.getWorld().getName() : null;
                throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(chunkPos) + " but compound says coordinate is " + String.valueOf(SerializableChunkData.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
            }
            return nbt;
        };
        this.e(chunkPos);
        try {
            this.storage.a(chunkPos, guardedPosCheck.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound upgradeChunkTag(NBTTagCompound tag, int fallbackVersion, @Nullable NBTTagCompound contextTag, @Nullable GeneratorAccess levelAccessor) {
        int dataVersion = GameProfileSerializer.b(tag, fallbackVersion);
        if (dataVersion == SharedConstants.b().a().b()) {
            return tag;
        }
        try {
            boolean chunkStorage;
            LegacyTagFixer legacyFixer;
            LegacyTagFixer legacyTagFixer = legacyFixer = this.d.get();
            synchronized (legacyTagFixer) {
                tag = legacyFixer.applyFix(tag);
            }
            boolean stopBelowZero = false;
            boolean bl = chunkStorage = this.c == DataFixTypes.d;
            if (chunkStorage) {
                boolean belowZeroGenerationInExistingChunks;
                boolean bl2 = belowZeroGenerationInExistingChunks = levelAccessor != null ? ((WorldServer)levelAccessor).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
                if (dataVersion <= 2730 && !belowZeroGenerationInExistingChunks) {
                    stopBelowZero = "full".equals(tag.m("Level").flatMap(l2 -> l2.i("Status")).orElse(null));
                }
            }
            SimpleRegionStorage.a(tag, contextTag);
            tag = MCDataConverter.convertTag(this.getDataConverterType(), tag, Math.max(this.d.get().targetDataVersion(), dataVersion), Version.getCurrentVersion());
            if (stopBelowZero) {
                tag.a("Status", BuiltInRegistries.m.b(ChunkStatus.m).toString());
            }
            SimpleRegionStorage.a(tag);
            GameProfileSerializer.e(tag);
            return tag;
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.a(var8, "Updated chunk");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Updated chunk details");
            crashReportCategory.a("Data version", dataVersion);
            throw new ReportedException(crashReport);
        }
    }

    private MCDataType getDataConverterType() {
        if (this.c == DataFixTypes.d) {
            return MCTypeRegistry.CHUNK;
        }
        if (this.c == DataFixTypes.v) {
            return MCTypeRegistry.ENTITY_CHUNK;
        }
        if (this.c == DataFixTypes.t) {
            return MCTypeRegistry.POI_CHUNK;
        }
        throw new UnsupportedOperationException("For " + this.c.name());
    }

    public NBTTagCompound a(NBTTagCompound tag, int version) {
        return this.upgradeChunkTag(tag, version, null, null);
    }

    public Dynamic<NBTBase> a(Dynamic<NBTBase> tag, int version) {
        return new Dynamic<NBTBase>(tag.getOps(), this.upgradeChunkTag((NBTTagCompound)tag.getValue(), version, null, null));
    }

    public static void a(NBTTagCompound tag, @Nullable NBTTagCompound contextTag) {
        if (contextTag != null) {
            tag.a("__context", contextTag);
        }
    }

    private static void a(NBTTagCompound tag) {
        tag.r("__context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void e(ChunkCoordIntPair chunkPos) {
        LegacyTagFixer legacyFixer;
        LegacyTagFixer legacyTagFixer = legacyFixer = this.d.get();
        synchronized (legacyTagFixer) {
            legacyFixer.markChunkDone(chunkPos);
        }
    }

    public CompletableFuture<Void> b(boolean flushStorage) {
        try {
            this.storage.a();
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess m() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.a(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        };
    }

    public RegionStorageInfo n() {
        return this.storage.b();
    }
}

