/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    final Set<UUID> b = Sets.newHashSet();
    final LevelCallback<T> c;
    public final EntityPersistentStorage<T> d;
    private final EntityLookup<T> e;
    final EntitySectionStorage<T> f;
    private final LevelEntityGetter<T> g;
    private final Long2ObjectMap<Visibility> h = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<b> i = new Long2ObjectOpenHashMap();
    private final LongSet j = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> k = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> entityClass, LevelCallback<T> callbacks, EntityPersistentStorage<T> permanentStorage) {
        this.e = new EntityLookup();
        this.f = new EntitySectionStorage<T>(entityClass, (Long2ObjectFunction<Visibility>)this.h);
        this.h.defaultReturnValue((Object)Visibility.a);
        this.i.defaultReturnValue((Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a);
        this.c = callbacks;
        this.d = permanentStorage;
        this.g = new LevelEntityGetterAdapter<T>(this.e, this.f);
    }

    public List<Entity> getEntities(ChunkCoordIntPair chunkPos) {
        return this.f.b(chunkPos.b()).flatMap(EntitySection::b).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.i.get(pair) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b;
    }

    void a(long sectionKey, EntitySection<T> section) {
        if (section.a()) {
            this.f.e(sectionKey);
        }
    }

    private boolean b(T entity) {
        AsyncCatcher.catchOp("Entity add by UUID");
        if (!this.b.add(entity.cY())) {
            a.warn("UUID of added entity already exists: {}", entity);
            return false;
        }
        return true;
    }

    public boolean a(T entity) {
        return this.a(entity, false);
    }

    private boolean a(T entity, boolean worldGenSpawned) {
        Visibility effectiveStatus;
        AsyncCatcher.catchOp("Entity add");
        Entity entityCasted = (Entity)entity;
        boolean wasRemoved = entityCasted.eh();
        boolean screened = PlatformHooks.get().screenEntity((WorldServer)entityCasted.ao(), entityCasted, worldGenSpawned, true);
        if (!wasRemoved && entityCasted.eh() || !screened) {
            return false;
        }
        if (!this.b(entity)) {
            return false;
        }
        long packedSectionPos = SectionPosition.c(entity.dK());
        EntitySection<T> section = this.f.c(packedSectionPos);
        section.a(entity);
        entity.a(new a(this, entity, packedSectionPos, section));
        if (!worldGenSpawned) {
            this.c.g(entity);
        }
        if ((effectiveStatus = PersistentEntitySectionManager.a(entity, section.c())).b()) {
            this.e(entity);
        }
        if (effectiveStatus.a()) {
            this.c(entity);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility a(T entity, Visibility visibility) {
        return entity.el() ? Visibility.c : visibility;
    }

    public boolean a(ChunkCoordIntPair chunkPos) {
        return ((Visibility)((Object)this.h.get(chunkPos.b()))).a();
    }

    public void a(Stream<T> entities) {
        entities.forEach(entity -> this.a(entity, true));
    }

    public void b(Stream<T> entities) {
        entities.forEach(entity -> this.a(entity, false));
    }

    void c(T entity) {
        AsyncCatcher.catchOp("Entity start ticking");
        this.c.e(entity);
    }

    void d(T entity) {
        AsyncCatcher.catchOp("Entity stop ticking");
        this.c.d(entity);
    }

    void e(T entity) {
        AsyncCatcher.catchOp("Entity start tracking");
        this.e.a(entity);
        this.c.c(entity);
    }

    void f(T entity) {
        AsyncCatcher.catchOp("Entity stop tracking");
        this.c.b(entity);
        this.e.b(entity);
    }

    public void a(ChunkCoordIntPair chunkPos, FullChunkStatus fullChunkStatus) {
        Visibility visibility = Visibility.a(fullChunkStatus);
        this.a(chunkPos, visibility);
    }

    public void a(ChunkCoordIntPair pos, Visibility visibility) {
        AsyncCatcher.catchOp("Update chunk status");
        long packedChunkPos = pos.b();
        if (visibility == Visibility.a) {
            this.h.remove(packedChunkPos);
            this.j.add(packedChunkPos);
        } else {
            this.h.put(packedChunkPos, (Object)visibility);
            this.j.remove(packedChunkPos);
            this.b(packedChunkPos);
        }
        this.f.b(packedChunkPos).forEach(entitySection -> {
            Visibility visibility1 = entitySection.a(visibility);
            boolean isAccessible = visibility1.b();
            boolean isAccessible1 = visibility.b();
            boolean isTicking = visibility1.a();
            boolean isTicking1 = visibility.a();
            if (isTicking && !isTicking1) {
                entitySection.b().filter(entity -> !entity.el()).forEach(this::d);
            }
            if (isAccessible && !isAccessible1) {
                entitySection.b().filter(entity -> !entity.el()).forEach(this::f);
            } else if (!isAccessible && isAccessible1) {
                entitySection.b().filter(entity -> !entity.el()).forEach(this::e);
            }
            if (!isTicking && isTicking1) {
                entitySection.b().filter(entity -> !entity.el()).forEach(this::c);
            }
        });
    }

    public void b(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk save");
        b chunkLoadStatus = (b)((Object)this.i.get(chunkPosValue));
        if (chunkLoadStatus == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(chunkPosValue);
        }
    }

    private boolean a(long chunkPosValue, Consumer<T> entityAction) {
        return this.storeChunkSections(chunkPosValue, entityAction, false);
    }

    private boolean storeChunkSections(long chunkPosValue, Consumer<T> entityAction, boolean callEvent) {
        b chunkLoadStatus = (b)((Object)this.i.get(chunkPosValue));
        if (chunkLoadStatus == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b) {
            return false;
        }
        List<T> list = this.f.b(chunkPosValue).flatMap(entitySection -> entitySection.b().filter(EntityAccess::ek)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (chunkLoadStatus == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(chunkPosValue), (List<Entity>)ImmutableList.of());
                }
                this.d.a(new ChunkEntities(new ChunkCoordIntPair(chunkPosValue), ImmutableList.of()));
            }
            return true;
        }
        if (chunkLoadStatus == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(chunkPosValue);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(chunkPosValue), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.d.a(new ChunkEntities(new ChunkCoordIntPair(chunkPosValue), list));
        list.forEach(entityAction);
        return true;
    }

    private void c(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk load request");
        this.i.put(chunkPosValue, (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b);
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkPosValue);
        ((CompletableFuture)this.d.a(chunkPos).thenAccept(this.k::add)).exceptionally(throwable -> {
            a.error("Failed to read chunk {}", (Object)chunkPos, throwable);
            return null;
        });
    }

    private boolean d(long chunkPosValue) {
        AsyncCatcher.catchOp("Entity chunk unload process");
        boolean flag = this.storeChunkSections(chunkPosValue, entity -> entity.dq().forEach(this::g), true);
        if (!flag) {
            return false;
        }
        this.i.remove(chunkPosValue);
        return true;
    }

    private void g(EntityAccess entity) {
        entity.setRemoved(Entity.RemovalReason.c, EntityRemoveEvent.Cause.UNLOAD);
        entity.a(EntityInLevelCallback.a);
    }

    private void h() {
        this.j.removeIf(packedChunkPos -> this.h.get(packedChunkPos) != Visibility.a || this.d(packedChunkPos));
    }

    public void a() {
        ChunkEntities<T> chunkEntities;
        AsyncCatcher.catchOp("Entity chunk process pending loads");
        while ((chunkEntities = this.k.poll()) != null) {
            chunkEntities.b().forEach(entity -> this.a(entity, true));
            this.i.put(chunkEntities.a().b(), (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c);
            List<Entity> entities = this.getEntities(chunkEntities.a());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.d).d, chunkEntities.a(), entities);
        }
    }

    public void b() {
        AsyncCatcher.catchOp("Entity manager tick");
        this.a();
        this.h();
    }

    private LongSet i() {
        LongSet allChunksWithExistingSections = this.f.a();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.i)) {
            if (entry.getValue() != net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) continue;
            allChunksWithExistingSections.add(entry.getLongKey());
        }
        return allChunksWithExistingSections;
    }

    public void c() {
        AsyncCatcher.catchOp("Entity manager autosave");
        this.i().forEach(packedChunkPos -> {
            boolean flag;
            boolean bl = flag = this.h.get(packedChunkPos) == Visibility.a;
            if (flag) {
                this.d(packedChunkPos);
            } else {
                this.a(packedChunkPos, (T entity) -> {});
            }
        });
    }

    public void d() {
        AsyncCatcher.catchOp("Entity manager save");
        LongSet allChunksToSave = this.i();
        while (!allChunksToSave.isEmpty()) {
            this.d.a(false);
            this.a();
            allChunksToSave.removeIf(packedChunkPos -> {
                boolean flag = this.h.get(packedChunkPos) == Visibility.a;
                return flag ? this.d(packedChunkPos) : this.a(packedChunkPos, (T entity) -> {});
            });
        }
        this.d.a(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.d();
        }
        this.d.close();
    }

    public boolean a(UUID uuid) {
        return this.b.contains(uuid);
    }

    public LevelEntityGetter<T> e() {
        return this.g;
    }

    public boolean a(BlockPosition pos) {
        return ((Visibility)((Object)this.h.get(ChunkCoordIntPair.a(pos)))).a();
    }

    public boolean b(ChunkCoordIntPair chunkPos) {
        return ((Visibility)((Object)this.h.get(chunkPos.b()))).a();
    }

    public boolean a(long chunkPos) {
        return this.i.get(chunkPos) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c;
    }

    public void a(Writer writer) throws IOException {
        CSVWriter csvOutput = CSVWriter.a().a("x").a("y").a("z").a("visibility").a("load_status").a("entity_count").a(writer);
        this.f.a().forEach(packedChunkPos -> {
            b chunkLoadStatus = (b)((Object)((Object)this.i.get(packedChunkPos)));
            this.f.a(packedChunkPos).forEach(packedSectionPos -> {
                EntitySection<T> section = this.f.d(packedSectionPos);
                if (section != null) {
                    try {
                        csvOutput.a(new Object[]{SectionPosition.b(packedSectionPos), SectionPosition.c(packedSectionPos), SectionPosition.d(packedSectionPos), section.c(), chunkLoadStatus, section.d()});
                    }
                    catch (IOException var7) {
                        throw new UncheckedIOException(var7);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String f() {
        return this.b.size() + "," + this.e.b() + "," + this.f.b() + "," + this.i.size() + "," + this.h.size() + "," + this.k.size() + "," + this.j.size();
    }

    @VisibleForDebug
    public int g() {
        return this.e.b();
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a();
        }
    }

    class a
    implements EntityInLevelCallback {
        private final T c;
        private long d;
        private EntitySection<T> e;
        final /* synthetic */ PersistentEntitySectionManager b;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        a(T t2, long currentSection, EntitySection<T> entitySection) {
            void var3_3;
            void entity;
            this.b = (PersistentEntitySectionManager)this$0;
            this.c = entity;
            this.d = var3_3;
            this.e = (EntitySection)currentSection;
        }

        @Override
        public void a() {
            BlockPosition blockPos = this.c.dK();
            long packedSectionPos = SectionPosition.c(blockPos);
            if (packedSectionPos != this.d) {
                AsyncCatcher.catchOp("Entity move");
                Visibility status = this.e.c();
                if (!this.e.b(this.c)) {
                    a.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.c, SectionPosition.a(this.d), packedSectionPos});
                }
                this.b.a(this.d, this.e);
                EntitySection section = this.b.f.c(packedSectionPos);
                section.a(this.c);
                this.e = section;
                this.d = packedSectionPos;
                this.a(status, section.c());
            }
        }

        private void a(Visibility oldVisibility, Visibility newVisibility) {
            Visibility effectiveStatus1;
            Visibility effectiveStatus = PersistentEntitySectionManager.a(this.c, oldVisibility);
            if (effectiveStatus == (effectiveStatus1 = PersistentEntitySectionManager.a(this.c, newVisibility))) {
                if (effectiveStatus1.b()) {
                    this.b.c.a(this.c);
                }
            } else {
                boolean isAccessible = effectiveStatus.b();
                boolean isAccessible1 = effectiveStatus1.b();
                if (isAccessible && !isAccessible1) {
                    this.b.f(this.c);
                } else if (!isAccessible && isAccessible1) {
                    this.b.e(this.c);
                }
                boolean isTicking = effectiveStatus.a();
                boolean isTicking1 = effectiveStatus1.a();
                if (isTicking && !isTicking1) {
                    this.b.d(this.c);
                } else if (!isTicking && isTicking1) {
                    this.b.c(this.c);
                }
                if (isAccessible1) {
                    this.b.c.a(this.c);
                }
            }
        }

        @Override
        public void a(Entity.RemovalReason reason) {
            Visibility effectiveStatus;
            AsyncCatcher.catchOp("Entity remove");
            if (!this.e.b(this.c)) {
                a.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.c, SectionPosition.a(this.d), reason});
            }
            if ((effectiveStatus = PersistentEntitySectionManager.a(this.c, this.e.c())).a()) {
                this.b.d(this.c);
            }
            if (effectiveStatus.b()) {
                this.b.f(this.c);
            }
            if (reason.a()) {
                this.b.c.f(this.c);
            }
            this.b.b.remove(this.c.cY());
            this.c.a(a);
            this.b.a(this.d, this.e);
        }
    }
}

