/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class EntityPositionSource
implements PositionSource {
    public static final MapCodec<EntityPositionSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.a.fieldOf("source_entity").forGetter(EntityPositionSource::b), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(positionSource -> Float.valueOf(positionSource.f))).apply((Applicative)instance, (sourceUuid, yOffset) -> new EntityPositionSource(Either.right(Either.left(sourceUuid)), yOffset.floatValue())));
    public static final StreamCodec<ByteBuf, EntityPositionSource> b = StreamCodec.a(ByteBufCodecs.h, EntityPositionSource::c, ByteBufCodecs.l, entityPositionSource -> Float.valueOf(entityPositionSource.f), (integer, _float) -> new EntityPositionSource(Either.right(Either.right(integer)), _float.floatValue()));
    private Either<Entity, Either<UUID, Integer>> e;
    private final float f;

    public EntityPositionSource(Entity entity, float yOffset) {
        this(Either.left(entity), yOffset);
    }

    private EntityPositionSource(Either<Entity, Either<UUID, Integer>> entityOrUuidOrId, float yOffset) {
        this.e = entityOrUuidOrId;
        this.f = yOffset;
    }

    @Override
    public Optional<Vec3D> a(World level) {
        if (this.e.left().isEmpty()) {
            this.b(level);
        }
        return this.e.left().map(entity -> entity.dI().b(0.0, this.f, 0.0));
    }

    private void b(World level) {
        this.e.map(Optional::of, either -> Optional.ofNullable(either.map(uuid -> {
            Entity entity;
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                entity = serverLevel.d((UUID)uuid);
            } else {
                entity = null;
            }
            return entity;
        }, level::a))).ifPresent(entity -> {
            this.e = Either.left(entity);
        });
    }

    public UUID b() {
        return this.e.map(Entity::cY, either -> either.map(Function.identity(), integer -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    private int c() {
        return this.e.map(Entity::aA, either -> either.map(uuid -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    public PositionSourceType<EntityPositionSource> a() {
        return PositionSourceType.b;
    }

    public static class a
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public MapCodec<EntityPositionSource> a() {
            return a;
        }

        @Override
        public StreamCodec<ByteBuf, EntityPositionSource> b() {
            return b;
        }
    }
}

