/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import net.minecraft.world.level.gamerules.GameRules;

public final class GameRule<T>
implements FeatureElement {
    private final GameRuleCategory a;
    private final GameRuleType b;
    private final ArgumentType<T> c;
    private final GameRules.a<T> d;
    private final Codec<T> e;
    private final ToIntFunction<T> f;
    private final T g;
    private final FeatureFlagSet h;
    public final int gameRuleIndex;
    public static int LAST_GAMERULE_INDEX = 0;

    public GameRule(GameRuleCategory category, GameRuleType gameRuleType, ArgumentType<T> argument, GameRules.a<T> visitorCaller, Codec<T> valueCodec, ToIntFunction<T> commandResultFunction, T defaultValue, FeatureFlagSet requiredFeatures) {
        this.a = category;
        this.b = gameRuleType;
        this.c = argument;
        this.d = visitorCaller;
        this.e = valueCodec;
        this.f = commandResultFunction;
        this.g = defaultValue;
        this.h = requiredFeatures;
        this.gameRuleIndex = LAST_GAMERULE_INDEX++;
    }

    public String toString() {
        return this.a();
    }

    public String a() {
        return this.b().f();
    }

    public MinecraftKey b() {
        return Objects.requireNonNull(BuiltInRegistries.an.b(this));
    }

    public String c() {
        return SystemUtils.a("gamerule", this.b());
    }

    public String a(T value) {
        return value.toString();
    }

    public DataResult<T> a(String value) {
        try {
            StringReader stringReader = new StringReader(value);
            Object object = this.c.parse(stringReader);
            return stringReader.canRead() ? DataResult.error(() -> "Failed to deserialize; trailing characters", (Object)object) : DataResult.success((Object)object);
        }
        catch (CommandSyntaxException var4) {
            return DataResult.error(() -> "Failed to deserialize");
        }
    }

    public Class<T> d() {
        return this.g.getClass();
    }

    public void a(GameRuleTypeVisitor visitor) {
        this.d.call(visitor, this);
    }

    public int b(T value) {
        return this.f.applyAsInt(value);
    }

    public GameRuleCategory e() {
        return this.a;
    }

    public GameRuleType f() {
        return this.b;
    }

    public ArgumentType<T> g() {
        return this.c;
    }

    public Codec<T> h() {
        return this.e;
    }

    public T i() {
        return this.g;
    }

    @Override
    public FeatureFlagSet k() {
        return this.h;
    }
}

