/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.gamerules.GameRule;
import org.jspecify.annotations.Nullable;

public final class GameRuleMap {
    public static final Codec<GameRuleMap> a = Codec.dispatchedMap(BuiltInRegistries.an.q(), GameRule::h).xmap(GameRuleMap::a, GameRuleMap::d);
    private final Reference2ObjectMap<GameRule<?>, Object> b;
    private final @Nullable Object[] idAccess;

    GameRuleMap(Reference2ObjectMap<GameRule<?>, Object> map) {
        this.b = map;
        this.idAccess = new Object[GameRule.LAST_GAMERULE_INDEX];
        for (Map.Entry entry : map.entrySet()) {
            this.idAccess[((GameRule)entry.getKey()).gameRuleIndex] = entry.getValue();
        }
    }

    private static GameRuleMap a(Map<GameRule<?>, Object> rules) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(rules));
    }

    public static GameRuleMap a() {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap());
    }

    public static GameRuleMap a(Stream<GameRule<?>> rules) {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        rules.forEach(gameRule -> map.put(gameRule, gameRule.i()));
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)map);
    }

    public static GameRuleMap a(GameRuleMap rules) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(rules.b));
    }

    public boolean a(GameRule<?> rule) {
        return this.idAccess[rule.gameRuleIndex] != null;
    }

    public <T> @Nullable T b(GameRule<T> rule) {
        return (T)this.idAccess[rule.gameRuleIndex];
    }

    public <T> void a(GameRule<T> rule, T value) {
        this.b.put(rule, value);
        this.idAccess[rule.gameRuleIndex] = value;
    }

    public <T> @Nullable T c(GameRule<T> rule) {
        this.idAccess[rule.gameRuleIndex] = null;
        return (T)this.b.remove(rule);
    }

    public Set<GameRule<?>> b() {
        return this.b.keySet();
    }

    public int c() {
        return this.b.size();
    }

    public String toString() {
        return this.b.toString();
    }

    public GameRuleMap b(GameRuleMap rules) {
        GameRuleMap gameRuleMap = GameRuleMap.a(this);
        gameRuleMap.a(rules, gameRule -> true);
        return gameRuleMap;
    }

    public void a(GameRuleMap rules, Predicate<GameRule<?>> predicate) {
        for (GameRule<?> gameRule : rules.b()) {
            if (!predicate.test(gameRule)) continue;
            GameRuleMap.a(rules, gameRule, this);
        }
    }

    private static <T> void a(GameRuleMap from, GameRule<T> rule, GameRuleMap to) {
        to.a(rule, Objects.requireNonNull(from.b(rule)));
    }

    private Reference2ObjectMap<GameRule<?>, Object> d() {
        return this.b;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            GameRuleMap gameRuleMap = (GameRuleMap)other;
            return Objects.equals(this.b, gameRuleMap.b);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.b);
    }

    public static class a {
        final Reference2ObjectMap<GameRule<?>, Object> a = new Reference2ObjectOpenHashMap();

        public <T> a a(GameRule<T> rule, T value) {
            this.a.put(rule, value);
            return this;
        }

        public GameRuleMap a() {
            return new GameRuleMap(this.a);
        }
    }
}

