/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleMap;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import org.jspecify.annotations.Nullable;

public class GameRules {
    private static final boolean DISABLE_LIMITS = Boolean.getBoolean("paper.disableGameRuleLimits");
    public static final GameRule<Boolean> a = GameRules.a("advance_time", GameRuleCategory.e, !SharedConstants.aN);
    public static final GameRule<Boolean> b = GameRules.a("advance_weather", GameRuleCategory.e, !SharedConstants.aN);
    public static final GameRule<Boolean> c = GameRules.a("allow_entering_nether_using_portals", GameRuleCategory.g, true);
    public static final GameRule<Boolean> d = GameRules.a("block_drops", GameRuleCategory.d, true);
    public static final GameRule<Boolean> e = GameRules.a("block_explosion_drop_decay", GameRuleCategory.d, true);
    public static final GameRule<Boolean> f = GameRules.a("command_blocks_work", GameRuleCategory.g, true);
    public static final GameRule<Boolean> g = GameRules.a("command_block_output", GameRuleCategory.f, true);
    public static final GameRule<Boolean> h = GameRules.a("drowning_damage", GameRuleCategory.a, true);
    public static final GameRule<Boolean> i = GameRules.a("elytra_movement_check", GameRuleCategory.a, true);
    public static final GameRule<Boolean> j = GameRules.a("ender_pearls_vanish_on_death", GameRuleCategory.a, true);
    public static final GameRule<Boolean> k = GameRules.a("entity_drops", GameRuleCategory.d, true);
    public static final GameRule<Boolean> l = GameRules.a("fall_damage", GameRuleCategory.a, true);
    public static final GameRule<Boolean> m = GameRules.a("fire_damage", GameRuleCategory.a, true);
    public static final GameRule<Integer> n = GameRules.a("fire_spread_radius_around_player", GameRuleCategory.e, 128, -1);
    public static final GameRule<Boolean> o = GameRules.a("forgive_dead_players", GameRuleCategory.b, true);
    public static final GameRule<Boolean> p = GameRules.a("freeze_damage", GameRuleCategory.a, true);
    public static final GameRule<Boolean> q = GameRules.a("global_sound_events", GameRuleCategory.g, true);
    public static final GameRule<Boolean> r = GameRules.a("immediate_respawn", GameRuleCategory.a, false);
    public static final GameRule<Boolean> s = GameRules.a("keep_inventory", GameRuleCategory.a, false);
    public static final GameRule<Boolean> t = GameRules.a("lava_source_conversion", GameRuleCategory.e, false);
    public static final GameRule<Boolean> u = GameRules.a("limited_crafting", GameRuleCategory.a, false);
    public static final GameRule<Boolean> v = GameRules.a("locator_bar", GameRuleCategory.a, true);
    public static final GameRule<Boolean> w = GameRules.a("log_admin_commands", GameRuleCategory.f, true);
    public static final GameRule<Integer> x = GameRules.a("max_block_modifications", GameRuleCategory.g, 32768, 1);
    public static final GameRule<Integer> y = GameRules.a("max_command_forks", GameRuleCategory.g, 65536, 0);
    public static final GameRule<Integer> z = GameRules.a("max_command_sequence_length", GameRuleCategory.g, 65536, 0);
    public static final GameRule<Integer> A = GameRules.a("max_entity_cramming", GameRuleCategory.b, 24, 0);
    public static final GameRule<Integer> B = GameRules.a("max_minecart_speed", GameRuleCategory.g, 8, 1, 1000, FeatureFlagSet.a(FeatureFlags.d));
    public static final GameRule<Integer> C = GameRules.a("max_snow_accumulation_height", GameRuleCategory.e, 1, 0, 8);
    public static final GameRule<Boolean> D = GameRules.a("mob_drops", GameRuleCategory.d, true);
    public static final GameRule<Boolean> E = GameRules.a("mob_explosion_drop_decay", GameRuleCategory.d, true);
    public static final GameRule<Boolean> F = GameRules.a("mob_griefing", GameRuleCategory.b, true);
    public static final GameRule<Boolean> G = GameRules.a("natural_health_regeneration", GameRuleCategory.a, true);
    public static final GameRule<Boolean> H = GameRules.a("player_movement_check", GameRuleCategory.a, true);
    public static final GameRule<Integer> I = GameRules.a("players_nether_portal_creative_delay", GameRuleCategory.a, 0, 0);
    public static final GameRule<Integer> J = GameRules.a("players_nether_portal_default_delay", GameRuleCategory.a, 80, 0);
    public static final GameRule<Integer> K = GameRules.a("players_sleeping_percentage", GameRuleCategory.a, 100, 0);
    public static final GameRule<Boolean> L = GameRules.a("projectiles_can_break_blocks", GameRuleCategory.d, true);
    public static final GameRule<Boolean> M = GameRules.a("pvp", GameRuleCategory.a, true);
    public static final GameRule<Boolean> N = GameRules.a("raids", GameRuleCategory.b, true);
    public static final GameRule<Integer> O = GameRules.a("random_tick_speed", GameRuleCategory.e, 3, 0);
    public static final GameRule<Boolean> P = GameRules.a("reduced_debug_info", GameRuleCategory.g, false);
    public static final GameRule<Integer> Q = GameRules.a("respawn_radius", GameRuleCategory.a, 10, 0);
    public static final GameRule<Boolean> R = GameRules.a("send_command_feedback", GameRuleCategory.f, true);
    public static final GameRule<Boolean> S = GameRules.a("show_advancement_messages", GameRuleCategory.f, true);
    public static final GameRule<Boolean> T = GameRules.a("show_death_messages", GameRuleCategory.f, true);
    public static final GameRule<Boolean> U = GameRules.a("spawner_blocks_work", GameRuleCategory.g, true);
    public static final GameRule<Boolean> V = GameRules.a("spawn_mobs", GameRuleCategory.c, true);
    public static final GameRule<Boolean> W = GameRules.a("spawn_monsters", GameRuleCategory.c, true);
    public static final GameRule<Boolean> X = GameRules.a("spawn_patrols", GameRuleCategory.c, true);
    public static final GameRule<Boolean> Y = GameRules.a("spawn_phantoms", GameRuleCategory.c, true);
    public static final GameRule<Boolean> Z = GameRules.a("spawn_wandering_traders", GameRuleCategory.c, true);
    public static final GameRule<Boolean> aa = GameRules.a("spawn_wardens", GameRuleCategory.c, true);
    public static final GameRule<Boolean> ab = GameRules.a("spectators_generate_chunks", GameRuleCategory.a, true);
    public static final GameRule<Boolean> ac = GameRules.a("spread_vines", GameRuleCategory.e, true);
    public static final GameRule<Boolean> ad = GameRules.a("tnt_explodes", GameRuleCategory.g, true);
    public static final GameRule<Boolean> ae = GameRules.a("tnt_explosion_drop_decay", GameRuleCategory.d, false);
    public static final GameRule<Boolean> af = GameRules.a("universal_anger", GameRuleCategory.b, false);
    public static final GameRule<Boolean> ag = GameRules.a("water_source_conversion", GameRuleCategory.e, true);
    public final GameRuleMap ah;

    private static int limit(int limit, int unlimited) {
        return DISABLE_LIMITS ? unlimited : limit;
    }

    public static Codec<GameRules> a(FeatureFlagSet enabledFeatures) {
        return GameRuleMap.a.xmap(rules -> new GameRules(enabledFeatures, (GameRuleMap)rules), gameRules -> gameRules.ah);
    }

    public GameRules(FeatureFlagSet enabledFeatures, GameRuleMap rules) {
        this(enabledFeatures);
        this.ah.a(rules, this.ah::a);
    }

    public GameRules(FeatureFlagSet enabledFeatures) {
        this.ah = GameRuleMap.a(BuiltInRegistries.an.a(enabledFeatures).c().map(Holder::a));
    }

    public Stream<GameRule<?>> a() {
        return this.ah.b().stream();
    }

    public <T> T a(GameRule<T> rule) {
        T object = this.ah.b(rule);
        if (object == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return object;
    }

    public <T> void set(GameRule<T> rule, T value, @Nullable WorldServer level) {
        if (!this.ah.a(rule)) {
            throw new IllegalArgumentException("Tried to set invalid game rule");
        }
        this.ah.a(rule, value);
        if (level != null) {
            level.s().onGameRuleChanged(level, rule, value);
        }
    }

    public GameRules b(FeatureFlagSet enabledFeatures) {
        return new GameRules(enabledFeatures, this.ah);
    }

    public void setAll(GameRules gameRules, @Nullable WorldServer level) {
        this.setAll(gameRules.ah, level);
    }

    public void setAll(GameRuleMap rules, @Nullable WorldServer level) {
        rules.b().forEach(rule -> this.setFromOther(rules, (GameRule)rule, level));
    }

    private <T> void setFromOther(GameRuleMap rules, GameRule<T> rule, @Nullable WorldServer level) {
        this.set(rule, Objects.requireNonNull(rules.b(rule)), level);
    }

    public void a(GameRuleTypeVisitor visitor) {
        this.ah.b().forEach(gameRule -> {
            visitor.a(gameRule);
            gameRule.a(visitor);
        });
    }

    private static GameRule<Boolean> a(String name, GameRuleCategory category, boolean defaultValue) {
        return GameRules.a(name, category, GameRuleType.b, BoolArgumentType.bool(), Codec.BOOL, defaultValue, FeatureFlagSet.a(), GameRuleTypeVisitor::b, _boolean -> _boolean != false ? 1 : 0);
    }

    private static GameRule<Integer> a(String name, GameRuleCategory category, int defaultValue, int min) {
        return GameRules.a(name, category, defaultValue, min, Integer.MAX_VALUE, FeatureFlagSet.a());
    }

    private static GameRule<Integer> a(String name, GameRuleCategory category, int defaultValue, int min, int max) {
        return GameRules.a(name, category, defaultValue, min, max, FeatureFlagSet.a());
    }

    private static GameRule<Integer> a(String name, GameRuleCategory category, int defaultValue, int min, int max, FeatureFlagSet requiredFeatures) {
        return GameRules.a(name, category, GameRuleType.a, IntegerArgumentType.integer((int)min, (int)max), Codec.intRange((int)min, (int)max), defaultValue, requiredFeatures, GameRuleTypeVisitor::c, integer -> integer);
    }

    private static <T> GameRule<T> a(String name, GameRuleCategory category, GameRuleType type, ArgumentType<T> argument, Codec<T> valueCodec, T defaultValue, FeatureFlagSet requiredFeatures, a<T> visitorCaller, ToIntFunction<T> commandResultFunction) {
        return IRegistry.a(BuiltInRegistries.an, name, new GameRule<T>(category, type, argument, visitorCaller, valueCodec, commandResultFunction, defaultValue, requiredFeatures));
    }

    public static GameRule<?> a(IRegistry<GameRule<?>> registry) {
        return a;
    }

    public <T> String b(GameRule<T> rule) {
        return rule.a(this.a(rule));
    }

    public static interface a<T> {
        public void call(GameRuleTypeVisitor var1, GameRule<T> var2);
    }
}

